/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.skins;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.EaglerXBungee;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.skins.BinaryHttpClient;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.skins.ICacheProvider;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.skins.SimpleRateLimiter;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.skins.SkinPackets;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.skins.SkinRescaler;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.skins.SkinService;
import org.apache.commons.codec.binary.Base64;

public class AsyncSkinProvider {
    private static final SimpleRateLimiter rateLimitDownload = new SimpleRateLimiter();
    private static final SimpleRateLimiter rateLimitLookup = new SimpleRateLimiter();

    public static void downloadSkin(String string, ICacheProvider iCacheProvider, Consumer<byte[]> consumer) {
        AsyncSkinProvider.downloadSkin(SkinPackets.createEaglerURLSkinUUID(string), string, iCacheProvider, consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadSkin(UUID uUID, String string, ICacheProvider iCacheProvider, Consumer<byte[]> consumer) {
        URI uRI;
        ICacheProvider.CacheLoadedSkin cacheLoadedSkin = iCacheProvider.loadSkinByUUID(uUID);
        if (cacheLoadedSkin == null) {
            boolean bl;
            try {
                uRI = URI.create(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                try {
                    consumer.accept(null);
                }
                catch (Throwable throwable) {
                    EaglerXBungee.logger().log(Level.SEVERE, "Exception thrown handling invalid skin!", throwable);
                }
                throw new CancelException();
            }
            int n = EaglerXBungee.getEagler().getConfig().getSkinRateLimitGlobal();
            SimpleRateLimiter simpleRateLimiter = rateLimitDownload;
            synchronized (simpleRateLimiter) {
                bl = !rateLimitDownload.rateLimit(n);
            }
            if (bl) {
                EaglerXBungee.logger().warning("skin system reached the global texture download ratelimit of " + n + " while downloading up \"" + string + "\"");
                throw new CancelException();
            }
        } else {
            try {
                consumer.accept(cacheLoadedSkin.texture);
            }
            catch (Throwable throwable) {
                EaglerXBungee.logger().log(Level.SEVERE, "Exception thrown processing cached skin!", throwable);
            }
            throw new CancelException();
        }
        BinaryHttpClient.asyncRequest("GET", uRI, new SkinConsumerImpl(new SkinCachingConsumer(uUID, string, iCacheProvider, consumer)));
    }

    public static void lookupProfileByUUID(UUID uUID, ICacheProvider iCacheProvider, Consumer<CacheFetchedProfile> consumer) {
        AsyncSkinProvider.lookupProfileByUUID(uUID, iCacheProvider, consumer, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void lookupProfileByUUID(UUID uUID, ICacheProvider iCacheProvider, Consumer<CacheFetchedProfile> consumer, boolean bl) {
        URI uRI;
        ICacheProvider.CacheLoadedProfile cacheLoadedProfile = iCacheProvider.loadProfileByUUID(uUID);
        if (cacheLoadedProfile == null) {
            boolean bl2;
            uRI = URI.create("https://sessionserver.mojang.com/session/minecraft/profile/" + SkinService.getMojangUUID(uUID));
            int n = EaglerXBungee.getEagler().getConfig().getUuidRateLimitGlobal();
            if (bl) {
                SimpleRateLimiter simpleRateLimiter = rateLimitLookup;
                synchronized (simpleRateLimiter) {
                    bl2 = !rateLimitLookup.rateLimit(n);
                }
            } else {
                bl2 = false;
            }
            if (bl2) {
                EaglerXBungee.logger().warning("skin system reached the global UUID lookup ratelimit of " + n + " while looking up \"" + uUID + "\"");
                throw new CancelException();
            }
        } else {
            try {
                consumer.accept(new CacheFetchedProfile(cacheLoadedProfile));
            }
            catch (Throwable throwable) {
                EaglerXBungee.logger().log(Level.SEVERE, "Exception thrown processing cached profile!", throwable);
            }
            throw new CancelException();
        }
        BinaryHttpClient.asyncRequest("GET", uRI, new ProfileConsumerImpl(uUID, new ProfileCachingConsumer(uUID, iCacheProvider, consumer)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void lookupProfileByUsername(String string, ICacheProvider iCacheProvider, Consumer<CacheFetchedProfile> consumer) {
        URI uRI;
        String string2 = string.toLowerCase();
        ICacheProvider.CacheLoadedProfile cacheLoadedProfile = iCacheProvider.loadProfileByUsername(string2);
        if (cacheLoadedProfile == null) {
            boolean bl;
            if (!string2.equals(string2.replaceAll("[^a-z0-9_]", "_").trim())) {
                try {
                    consumer.accept(null);
                }
                catch (Throwable throwable) {
                    EaglerXBungee.logger().log(Level.SEVERE, "Exception thrown processing invalid profile!", throwable);
                }
                throw new CancelException();
            }
            uRI = URI.create("https://api.mojang.com/users/profiles/minecraft/" + string);
            int n = EaglerXBungee.getEagler().getConfig().getUuidRateLimitGlobal();
            SimpleRateLimiter simpleRateLimiter = rateLimitLookup;
            synchronized (simpleRateLimiter) {
                bl = !rateLimitLookup.rateLimit(n);
            }
            if (bl) {
                EaglerXBungee.logger().warning("skin system reached the global UUID lookup ratelimit of " + n + " while looking up \"" + string + "\"");
                throw new CancelException();
            }
        } else {
            try {
                consumer.accept(new CacheFetchedProfile(cacheLoadedProfile));
            }
            catch (Throwable throwable) {
                EaglerXBungee.logger().log(Level.SEVERE, "Exception thrown processing cached profile!", throwable);
            }
            throw new CancelException();
        }
        BinaryHttpClient.asyncRequest("GET", uRI, new UsernameToUUIDConsumerImpl(string, iCacheProvider, consumer));
    }

    public static class CacheFetchedProfile {
        public final UUID uuid;
        public final String username;
        public final String texture;
        public final UUID textureUUID;
        public final String model;

        protected CacheFetchedProfile(UUID uUID, String string, String string2, String string3) {
            this.uuid = uUID;
            this.username = string;
            this.texture = string2;
            this.textureUUID = SkinPackets.createEaglerURLSkinUUID(string2);
            this.model = string3;
        }

        protected CacheFetchedProfile(ICacheProvider.CacheLoadedProfile cacheLoadedProfile) {
            this.uuid = cacheLoadedProfile.uuid;
            this.username = cacheLoadedProfile.username;
            this.texture = cacheLoadedProfile.texture;
            this.textureUUID = SkinPackets.createEaglerURLSkinUUID(cacheLoadedProfile.texture);
            this.model = cacheLoadedProfile.model;
        }
    }

    public static class CancelException
    extends RuntimeException {
    }

    private static class ProfileCachingConsumer
    implements Consumer<CacheFetchedProfile> {
        protected final UUID uuid;
        protected final ICacheProvider cacheProvider;
        protected final Consumer<CacheFetchedProfile> responseConsumer;

        protected ProfileCachingConsumer(UUID uUID, ICacheProvider iCacheProvider, Consumer<CacheFetchedProfile> consumer) {
            this.uuid = uUID;
            this.cacheProvider = iCacheProvider;
            this.responseConsumer = consumer;
        }

        @Override
        public void accept(CacheFetchedProfile cacheFetchedProfile) {
            if (cacheFetchedProfile != null) {
                try {
                    this.cacheProvider.cacheProfileByUUID(this.uuid, cacheFetchedProfile.username, cacheFetchedProfile.texture, cacheFetchedProfile.model);
                }
                catch (Throwable throwable) {
                    EaglerXBungee.logger().log(Level.SEVERE, "Exception thrown writing new profile to database!", throwable);
                }
                this.responseConsumer.accept(cacheFetchedProfile);
            } else {
                this.responseConsumer.accept(null);
            }
        }
    }

    private static class ProfileConsumerImpl
    implements Consumer<BinaryHttpClient.Response> {
        protected final UUID uuid;
        protected final Consumer<CacheFetchedProfile> responseConsumer;

        protected ProfileConsumerImpl(UUID uUID, Consumer<CacheFetchedProfile> consumer) {
            this.uuid = uUID;
            this.responseConsumer = consumer;
        }

        protected void doAccept(CacheFetchedProfile cacheFetchedProfile) {
            try {
                this.responseConsumer.accept(cacheFetchedProfile);
            }
            catch (Throwable throwable) {
                EaglerXBungee.logger().log(Level.SEVERE, "Exception thrown caching new profile!", throwable);
            }
        }

        @Override
        public void accept(BinaryHttpClient.Response response) {
            if (response == null || response.exception != null || response.code != 200 || response.data == null) {
                this.doAccept(null);
            } else {
                try {
                    String string;
                    String string2;
                    String string3;
                    block13: {
                        JsonObject jsonObject = new JsonParser().parse(new String(response.data, StandardCharsets.UTF_8)).getAsJsonObject();
                        string3 = jsonObject.get("name").getAsString().toLowerCase();
                        string2 = null;
                        string = null;
                        JsonElement jsonElement = jsonObject.get("properties");
                        if (jsonElement != null) {
                            try {
                                JsonArray jsonArray = jsonElement.getAsJsonArray();
                                if (jsonArray.size() <= 0) break block13;
                                int n = 0;
                                int n2 = jsonArray.size();
                                while (n < n2) {
                                    JsonObject jsonObject2;
                                    JsonElement jsonElement2 = jsonArray.get(n);
                                    if (jsonElement2.isJsonObject() && (jsonObject2 = jsonElement2.getAsJsonObject()).get("name").getAsString().equals("textures")) {
                                        JsonElement jsonElement3;
                                        String string4 = new String(Base64.decodeBase64((String)jsonObject2.get("value").getAsString()), StandardCharsets.UTF_8);
                                        JsonObject jsonObject3 = new JsonParser().parse(string4).getAsJsonObject();
                                        if (jsonObject3 != null && jsonObject3.has("textures") && (jsonElement3 = (jsonObject3 = jsonObject3.getAsJsonObject("textures")).get("SKIN")) != null) {
                                            JsonObject jsonObject4;
                                            JsonElement jsonElement4;
                                            JsonElement jsonElement5;
                                            string = "default";
                                            JsonObject jsonObject5 = jsonElement3.getAsJsonObject();
                                            JsonElement jsonElement6 = jsonObject5.get("url");
                                            if (jsonElement6 != null && !jsonElement6.isJsonNull()) {
                                                string2 = jsonElement6.getAsString();
                                            }
                                            if ((jsonElement5 = jsonObject5.get("metadata")) != null && (jsonElement4 = (jsonObject4 = jsonElement5.getAsJsonObject()).get("model")) != null) {
                                                string = jsonElement4.getAsString();
                                            }
                                        }
                                        break;
                                    }
                                    ++n;
                                }
                            }
                            catch (Throwable throwable) {}
                        }
                    }
                    if (string2 == null && string == null) {
                        string = SkinService.isAlex(this.uuid) ? "slim" : "default";
                    }
                    this.doAccept(new CacheFetchedProfile(this.uuid, string3, string2, string));
                }
                catch (Throwable throwable) {
                    this.doAccept(null);
                }
            }
        }
    }

    private static class SkinCachingConsumer
    implements Consumer<byte[]> {
        protected final UUID skinUUID;
        protected final String skinTexture;
        protected final ICacheProvider cacheProvider;
        protected final Consumer<byte[]> responseConsumer;

        protected SkinCachingConsumer(UUID uUID, String string, ICacheProvider iCacheProvider, Consumer<byte[]> consumer) {
            this.skinUUID = uUID;
            this.skinTexture = string;
            this.cacheProvider = iCacheProvider;
            this.responseConsumer = consumer;
        }

        @Override
        public void accept(byte[] byArray) {
            if (byArray != null) {
                try {
                    this.cacheProvider.cacheSkinByUUID(this.skinUUID, this.skinTexture, byArray);
                }
                catch (Throwable throwable) {
                    EaglerXBungee.logger().log(Level.SEVERE, "Exception thrown writing new skin to database!", throwable);
                }
                this.responseConsumer.accept(byArray);
            } else {
                this.responseConsumer.accept(null);
            }
        }
    }

    private static class SkinConsumerImpl
    implements Consumer<BinaryHttpClient.Response> {
        protected final Consumer<byte[]> responseConsumer;

        protected SkinConsumerImpl(Consumer<byte[]> consumer) {
            this.responseConsumer = consumer;
        }

        protected void doAccept(byte[] byArray) {
            try {
                this.responseConsumer.accept(byArray);
            }
            catch (Throwable throwable) {
                EaglerXBungee.logger().log(Level.SEVERE, "Exception thrown caching new skin!", throwable);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void accept(BinaryHttpClient.Response response) {
            Object object;
            if (response == null || response.exception != null || response.code != 200 || response.data == null) {
                this.doAccept(null);
                return;
            }
            try {
                object = ImageIO.read(new ByteArrayInputStream(response.data));
            }
            catch (IOException iOException) {
                this.doAccept(null);
                return;
            }
            try {
                Object object2;
                Object object3;
                int n = ((BufferedImage)object).getWidth();
                int n2 = ((BufferedImage)object).getHeight();
                if (n < 64 || n > 512 || n2 < 32 || n2 > 512) {
                    this.doAccept(null);
                    return;
                }
                if (n != 64 || n2 != 64) {
                    if (n % 64 != 0) {
                        this.doAccept(null);
                        return;
                    }
                    if (n == n2 * 2) {
                        object3 = new BufferedImage(64, 32, 2);
                        object2 = ((BufferedImage)object3).createGraphics();
                        ((Graphics)object2).drawImage((Image)object, 0, 0, 64, 32, 0, 0, n, n2, null);
                        ((Graphics)object2).dispose();
                        object = object3;
                        n = 64;
                        n2 = 32;
                    } else {
                        if (n != n2) {
                            this.doAccept(null);
                            return;
                        }
                        object3 = new BufferedImage(64, 64, 2);
                        object2 = ((BufferedImage)object3).createGraphics();
                        ((Graphics)object2).drawImage((Image)object, 0, 0, 64, 64, 0, 0, n, n2, null);
                        ((Graphics)object2).dispose();
                        object = object3;
                        n = 64;
                        n2 = 64;
                    }
                }
                if (n == 64 && n2 == 64) {
                    object3 = new int[4096];
                    object2 = new byte[16384];
                    ((BufferedImage)object).getRGB(0, 0, 64, 64, (int[])object3, 0, 64);
                    SkinRescaler.convertToBytes((int[])object3, (byte[])object2);
                    SkinPackets.setAlphaForChest((byte[])object2, (byte)-1);
                    this.doAccept((byte[])object2);
                    return;
                }
                if (n == 64 && n2 == 32) {
                    object3 = new int[2048];
                    object2 = new byte[16384];
                    ((BufferedImage)object).getRGB(0, 0, 64, 32, (int[])object3, 0, 64);
                    SkinRescaler.convert64x32To64x64((int[])object3, (byte[])object2);
                    SkinPackets.setAlphaForChest((byte[])object2, (byte)-1);
                    this.doAccept((byte[])object2);
                    return;
                }
                this.doAccept(null);
                return;
            }
            catch (Throwable throwable) {}
        }
    }

    private static class UsernameToUUIDConsumerImpl
    implements Consumer<BinaryHttpClient.Response> {
        protected final String username;
        protected final ICacheProvider cacheProvider;
        protected final Consumer<CacheFetchedProfile> responseConsumer;

        protected UsernameToUUIDConsumerImpl(String string, ICacheProvider iCacheProvider, Consumer<CacheFetchedProfile> consumer) {
            this.username = string;
            this.cacheProvider = iCacheProvider;
            this.responseConsumer = consumer;
        }

        protected void doAccept(CacheFetchedProfile cacheFetchedProfile) {
            try {
                this.responseConsumer.accept(cacheFetchedProfile);
            }
            catch (Throwable throwable) {
                EaglerXBungee.logger().log(Level.SEVERE, "Exception thrown caching new profile!", throwable);
            }
        }

        @Override
        public void accept(BinaryHttpClient.Response response) {
            if (response == null || response.exception != null || response.code != 200 || response.data == null) {
                this.doAccept(null);
            } else {
                try {
                    JsonObject jsonObject = new JsonParser().parse(new String(response.data, StandardCharsets.UTF_8)).getAsJsonObject();
                    String string = jsonObject.get("name").getAsString().toLowerCase();
                    if (!this.username.equals(string)) {
                        this.doAccept(null);
                    }
                    UUID uUID = SkinService.parseMojangUUID(jsonObject.get("id").getAsString());
                    AsyncSkinProvider.lookupProfileByUUID(uUID, this.cacheProvider, this.responseConsumer, false);
                }
                catch (Throwable throwable) {
                    this.doAccept(null);
                }
            }
        }
    }
}

