/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.query;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.EaglerXBungee;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.config.EaglerBungeeConfig;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.HttpServerQueryHandler;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.query.MOTDQueryHandler;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.query.VersionQueryHandler;
import net.md_5.bungee.api.plugin.PluginDescription;

public class QueryManager {
    private static final Map<String, Class<? extends HttpServerQueryHandler>> queryTypes = new HashMap<String, Class<? extends HttpServerQueryHandler>>();

    static {
        queryTypes.put("motd", MOTDQueryHandler.class);
        queryTypes.put("motd.cache", MOTDQueryHandler.class);
        queryTypes.put("version", VersionQueryHandler.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpServerQueryHandler createQueryHandler(String string) {
        Class<? extends HttpServerQueryHandler> clazz;
        Object object = queryTypes;
        synchronized (object) {
            clazz = queryTypes.get(string);
        }
        if (clazz != null) {
            object = null;
            try {
                object = clazz.newInstance();
            }
            catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                EaglerXBungee.logger().log(Level.SEVERE, "Exception creating query handler for '" + string + "'!", reflectiveOperationException);
            }
            if (object != null) {
                return object;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerQueryType(String string, Class<? extends HttpServerQueryHandler> clazz) {
        Map<String, Class<? extends HttpServerQueryHandler>> map = queryTypes;
        synchronized (map) {
            if (queryTypes.put(string, clazz) != null) {
                EaglerXBungee.logger().warning("Query type '" + string + "' was registered twice, probably by two different plugins!");
                Thread.dumpStack();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterQueryType(String string) {
        Map<String, Class<? extends HttpServerQueryHandler>> map = queryTypes;
        synchronized (map) {
            queryTypes.remove(string);
        }
    }

    private static JsonObject createBaseResponse() {
        EaglerXBungee eaglerXBungee = EaglerXBungee.getEagler();
        EaglerBungeeConfig eaglerBungeeConfig = eaglerXBungee.getConfig();
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("name", eaglerBungeeConfig.getServerName());
        jsonObject.addProperty("brand", "lax1dude");
        PluginDescription pluginDescription = eaglerXBungee.getDescription();
        jsonObject.addProperty("vers", "EaglerXBungee/" + pluginDescription.getVersion());
        jsonObject.addProperty("cracked", Boolean.valueOf(eaglerBungeeConfig.isCracked()));
        jsonObject.addProperty("secure", Boolean.valueOf(false));
        jsonObject.addProperty("time", (Number)System.currentTimeMillis());
        jsonObject.addProperty("uuid", eaglerBungeeConfig.getServerUUID().toString());
        return jsonObject;
    }

    public static JsonObject createStringResponse(String string, String string2) {
        JsonObject jsonObject = QueryManager.createBaseResponse();
        jsonObject.addProperty("type", string);
        jsonObject.addProperty("data", string2);
        return jsonObject;
    }

    public static JsonObject createJsonObjectResponse(String string, JsonObject jsonObject) {
        JsonObject jsonObject2 = QueryManager.createBaseResponse();
        jsonObject2.addProperty("type", string);
        jsonObject2.add("data", (JsonElement)jsonObject);
        return jsonObject2;
    }
}

