/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import java.util.List;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.EaglerXBungee;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.EaglerConnectionInstance;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.EaglerPipeline;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.bungeeprotocol.EaglerBungeeProtocol;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.bungeeprotocol.EaglerProtocolAccessProxy;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.PacketWrapper;
import net.md_5.bungee.protocol.ProtocolConstants;

public class EaglerMinecraftDecoder
extends MessageToMessageDecoder<WebSocketFrame> {
    private EaglerBungeeProtocol protocol;
    private final boolean server;
    private int protocolVersion;

    protected void decode(ChannelHandlerContext channelHandlerContext, WebSocketFrame webSocketFrame, List<Object> list) throws Exception {
        if (!channelHandlerContext.channel().isActive()) {
            return;
        }
        EaglerConnectionInstance eaglerConnectionInstance = (EaglerConnectionInstance)channelHandlerContext.channel().attr(EaglerPipeline.CONNECTION_INSTANCE).get();
        long l = System.currentTimeMillis();
        if (webSocketFrame instanceof BinaryWebSocketFrame) {
            BinaryWebSocketFrame binaryWebSocketFrame = (BinaryWebSocketFrame)webSocketFrame;
            ByteBuf byteBuf = binaryWebSocketFrame.content();
            int n = DefinedPacket.readVarInt((ByteBuf)byteBuf);
            DefinedPacket definedPacket = EaglerProtocolAccessProxy.createPacket(this.protocol, this.protocolVersion, n, this.server);
            if (definedPacket != null) {
                definedPacket.read(byteBuf, this.server ? ProtocolConstants.Direction.TO_CLIENT : ProtocolConstants.Direction.TO_SERVER, this.protocolVersion);
                if (byteBuf.isReadable()) {
                    EaglerXBungee.logger().severe("[DECODER][" + channelHandlerContext.channel().remoteAddress() + "] Packet " + definedPacket.getClass().getSimpleName() + " had extra bytes! (" + byteBuf.readableBytes() + ")");
                } else {
                    list.add(new PacketWrapper(definedPacket, byteBuf.copy(0, byteBuf.writerIndex())));
                }
            } else {
                list.add(new PacketWrapper(null, byteBuf.copy(0, byteBuf.writerIndex())));
            }
        } else if (webSocketFrame instanceof PingWebSocketFrame) {
            if (l - eaglerConnectionInstance.lastClientPingPacket > 500L) {
                channelHandlerContext.write((Object)new PongWebSocketFrame());
                eaglerConnectionInstance.lastClientPingPacket = l;
            }
        } else if (webSocketFrame instanceof PongWebSocketFrame) {
            eaglerConnectionInstance.lastClientPongPacket = l;
        } else {
            channelHandlerContext.close();
        }
    }

    public EaglerMinecraftDecoder(EaglerBungeeProtocol eaglerBungeeProtocol, boolean bl, int n) {
        this.protocol = eaglerBungeeProtocol;
        this.server = bl;
        this.protocolVersion = n;
    }

    public void setProtocol(EaglerBungeeProtocol eaglerBungeeProtocol) {
        this.protocol = eaglerBungeeProtocol;
    }

    public void setProtocolVersion(int n) {
        this.protocolVersion = n;
    }
}

