/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server;

import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.config.EaglerBungeeConfig;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.skins.SimpleRateLimiter;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.config.ListenerInfo;
import net.md_5.bungee.api.connection.Connection;
import net.md_5.bungee.connection.InitialHandler;
import net.md_5.bungee.connection.LoginResult;
import net.md_5.bungee.netty.ChannelWrapper;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.PacketWrapper;
import net.md_5.bungee.protocol.Property;
import net.md_5.bungee.protocol.packet.EncryptionResponse;
import net.md_5.bungee.protocol.packet.Handshake;
import net.md_5.bungee.protocol.packet.LegacyHandshake;
import net.md_5.bungee.protocol.packet.LegacyPing;
import net.md_5.bungee.protocol.packet.LoginPayloadResponse;
import net.md_5.bungee.protocol.packet.LoginRequest;
import net.md_5.bungee.protocol.packet.PingPacket;
import net.md_5.bungee.protocol.packet.PluginMessage;
import net.md_5.bungee.protocol.packet.StatusRequest;

public class EaglerInitialHandler
extends InitialHandler {
    private final int gameProtocolVersion;
    private final String username;
    private final UUID playerUUID;
    private LoginResult loginResult;
    private final InetSocketAddress eaglerAddress;
    private final InetSocketAddress virtualHost;
    private final Connection.Unsafe eaglerUnsafe;
    public final SimpleRateLimiter skinLookupRateLimiter;
    public final SimpleRateLimiter skinUUIDLookupRateLimiter;
    public final SimpleRateLimiter skinTextureDownloadRateLimiter;
    public final String origin;

    public EaglerInitialHandler(BungeeCord bungeeCord, ListenerInfo listenerInfo, final ChannelWrapper channelWrapper, int n, String string, UUID uUID, InetSocketAddress inetSocketAddress, String string2, String string3) {
        super(bungeeCord, listenerInfo);
        this.gameProtocolVersion = n;
        this.username = string;
        this.playerUUID = uUID;
        this.eaglerAddress = inetSocketAddress;
        this.origin = string3;
        this.skinLookupRateLimiter = new SimpleRateLimiter();
        this.skinUUIDLookupRateLimiter = new SimpleRateLimiter();
        this.skinTextureDownloadRateLimiter = new SimpleRateLimiter();
        if (string2 == null) {
            string2 = "";
        }
        int n2 = 25565;
        if (string2.contains(":")) {
            int n3 = string2.lastIndexOf(58);
            try {
                n2 = Integer.parseInt(string2.substring(n3 + 1));
                string2 = string2.substring(0, n3);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        this.virtualHost = InetSocketAddress.createUnresolved(string2, n2);
        this.eaglerUnsafe = new Connection.Unsafe(){

            public void sendPacket(DefinedPacket definedPacket) {
                channelWrapper.getHandle().writeAndFlush((Object)definedPacket);
            }
        };
        this.setLoginProfile(new LoginResult(uUID.toString(), string, new Property[]{EaglerBungeeConfig.isEaglerProperty}));
        try {
            super.connected(channelWrapper);
        }
        catch (Exception exception) {}
    }

    void setLoginProfile(LoginResult loginResult) {
        this.loginResult = loginResult;
        try {
            Field field = InitialHandler.class.getDeclaredField("loginProfile");
            field.setAccessible(true);
            field.set((Object)this, loginResult);
        }
        catch (Throwable throwable) {}
    }

    public void handle(PacketWrapper packetWrapper) throws Exception {
    }

    public void handle(PluginMessage pluginMessage) throws Exception {
    }

    public void handle(LegacyHandshake legacyHandshake) throws Exception {
    }

    public void handle(LegacyPing legacyPing) throws Exception {
    }

    public void handle(StatusRequest statusRequest) throws Exception {
    }

    public void handle(PingPacket pingPacket) throws Exception {
    }

    public void handle(Handshake handshake) throws Exception {
    }

    public void handle(LoginRequest loginRequest) throws Exception {
    }

    public void handle(EncryptionResponse encryptionResponse) throws Exception {
    }

    public void handle(LoginPayloadResponse loginPayloadResponse) throws Exception {
    }

    public void disconnect(String string) {
        super.disconnect(string);
    }

    public void disconnect(BaseComponent ... baseComponentArray) {
        super.disconnect(baseComponentArray);
    }

    public void disconnect(BaseComponent baseComponent) {
        super.disconnect(baseComponent);
    }

    public String getName() {
        return this.username;
    }

    public int getVersion() {
        return this.gameProtocolVersion;
    }

    public Handshake getHandshake() {
        return new Handshake(this.gameProtocolVersion, this.virtualHost.getHostName(), this.virtualHost.getPort(), this.gameProtocolVersion);
    }

    public LoginRequest getLoginRequest() {
        throw new UnsupportedOperationException("A plugin attempted to retrieve the LoginRequest packet from an EaglercraftX connection, which is not supported because Eaglercraft does not use online mode encryption. Please analyze the stack trace of this exception and reconfigure or remove the offending plugin to fix this issue.");
    }

    public PluginMessage getBrandMessage() {
        String string = "EaglercraftX";
        byte[] byArray = new byte[string.length() + 1];
        byArray[0] = (byte)string.length();
        System.arraycopy(string.getBytes(StandardCharsets.US_ASCII), 0, byArray, 1, string.length());
        return new PluginMessage("MC|Brand", byArray, true);
    }

    public UUID getUniqueId() {
        return this.playerUUID;
    }

    public UUID getOfflineId() {
        return this.playerUUID;
    }

    public String getUUID() {
        return this.playerUUID.toString().replace("-", "");
    }

    public LoginResult getLoginProfile() {
        return this.loginResult;
    }

    public InetSocketAddress getVirtualHost() {
        return this.virtualHost;
    }

    public SocketAddress getSocketAddress() {
        return this.eaglerAddress;
    }

    public Connection.Unsafe unsafe() {
        return this.eaglerUnsafe;
    }

    public String getOrigin() {
        return this.origin;
    }
}

