/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.handlers;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.EaglerXBungee;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.auth.DefaultAuthSystem;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.config.EaglerAuthConfig;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.EaglerInitialHandler;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.skins.SkinPackets;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.skins.SkinService;
import net.md_5.bungee.UserConnection;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.connection.Server;
import net.md_5.bungee.api.event.PlayerDisconnectEvent;
import net.md_5.bungee.api.event.PluginMessageEvent;
import net.md_5.bungee.api.event.PostLoginEvent;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.connection.InitialHandler;
import net.md_5.bungee.connection.LoginResult;
import net.md_5.bungee.event.EventHandler;
import net.md_5.bungee.protocol.Property;
import org.apache.commons.codec.binary.Base64;

public class EaglerPacketEventListener
implements Listener {
    public final EaglerXBungee plugin;

    public EaglerPacketEventListener(EaglerXBungee eaglerXBungee) {
        this.plugin = eaglerXBungee;
    }

    @EventHandler
    public void onPluginMessage(final PluginMessageEvent pluginMessageEvent) {
        if (pluginMessageEvent.getSender() instanceof UserConnection) {
            if ("EAG|Skins-1.8".equals(pluginMessageEvent.getTag())) {
                pluginMessageEvent.setCancelled(true);
                final UserConnection userConnection = (UserConnection)pluginMessageEvent.getSender();
                if (userConnection.getPendingConnection() instanceof EaglerInitialHandler) {
                    ProxyServer.getInstance().getScheduler().runAsync((Plugin)this.plugin, new Runnable(){

                        @Override
                        public void run() {
                            try {
                                SkinPackets.processPacket(pluginMessageEvent.getData(), userConnection, EaglerPacketEventListener.this.plugin.getSkinService());
                            }
                            catch (IOException iOException) {
                                pluginMessageEvent.getSender().disconnect((BaseComponent)new TextComponent("Skin packet error!"));
                                EaglerXBungee.logger().log(Level.SEVERE, "Eagler user \"" + userConnection.getName() + "\" raised an exception handling skins!", iOException);
                            }
                        }
                    });
                } else {
                    pluginMessageEvent.getSender().disconnect((BaseComponent)new TextComponent("Cannot send \"EAG|Skins-1.8\" on a non-eagler connection!"));
                }
            }
        } else if (pluginMessageEvent.getSender() instanceof Server && pluginMessageEvent.getReceiver() instanceof UserConnection) {
            UserConnection userConnection = (UserConnection)pluginMessageEvent.getReceiver();
            if ("EAG|GetDomain".equals(pluginMessageEvent.getTag()) && userConnection.getPendingConnection() instanceof EaglerInitialHandler) {
                String string = ((EaglerInitialHandler)userConnection.getPendingConnection()).getOrigin();
                if (string == null) {
                    ((Server)pluginMessageEvent.getSender()).sendData("EAG|Domain", new byte[1]);
                } else {
                    ((Server)pluginMessageEvent.getSender()).sendData("EAG|Domain", string.getBytes(StandardCharsets.UTF_8));
                }
            }
        }
    }

    @EventHandler
    public void onPostLogin(PostLoginEvent postLoginEvent) {
        ProxiedPlayer proxiedPlayer = postLoginEvent.getPlayer();
        if (proxiedPlayer instanceof UserConnection) {
            DefaultAuthSystem defaultAuthSystem;
            Object object;
            UserConnection userConnection = (UserConnection)proxiedPlayer;
            InitialHandler initialHandler = userConnection.getPendingConnection();
            LoginResult loginResult = initialHandler.getLoginProfile();
            if (loginResult != null && ((Property[])(object = loginResult.getProperties())).length > 0) {
                int n = 0;
                while (n < ((Object)object).length) {
                    Object object2 = object[n];
                    if (object2.getName().equals("textures")) {
                        try {
                            JsonElement jsonElement;
                            String string = SkinPackets.bytesToAscii(Base64.decodeBase64((String)object2.getValue()));
                            JsonObject jsonObject = new JsonParser().parse(string).getAsJsonObject();
                            JsonObject jsonObject2 = jsonObject.getAsJsonObject("SKIN");
                            if (jsonObject2 != null && (jsonElement = jsonObject.get("url")) != null) {
                                String string2 = SkinService.sanitizeTextureURL(jsonElement.getAsString());
                                this.plugin.getSkinService().registerTextureToPlayerAssociation(string2, userConnection.getUniqueId());
                            }
                        }
                        catch (Throwable throwable) {}
                    }
                    ++n;
                }
            }
            if (((EaglerAuthConfig)(object = EaglerXBungee.getEagler().getConfig().getAuthConfig())).isEnableAuthentication() && ((EaglerAuthConfig)object).isUseBuiltInAuthentication() && (defaultAuthSystem = EaglerXBungee.getEagler().getAuthService()) != null) {
                defaultAuthSystem.handleVanillaLogin(postLoginEvent);
            }
        }
    }

    @EventHandler
    public void onConnectionLost(PlayerDisconnectEvent playerDisconnectEvent) {
        this.plugin.getSkinService().unregisterPlayer(playerDisconnectEvent.getPlayer().getUniqueId());
    }
}

