/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.config;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import java.util.logging.Level;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.EaglerXBungee;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.config.EaglerBungeeConfig;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.skins.BinaryHttpClient;
import net.md_5.bungee.protocol.Property;

class VanillaDefaultSkinProfileLoader
implements Consumer<BinaryHttpClient.Response> {
    private final EaglerBungeeConfig config;
    private volatile boolean isLocked = true;
    private final Object lock = new Object();

    private VanillaDefaultSkinProfileLoader(EaglerBungeeConfig eaglerBungeeConfig) {
        this.config = eaglerBungeeConfig;
    }

    @Override
    public void accept(BinaryHttpClient.Response response) {
        if (response == null) {
            EaglerXBungee.logger().severe("Request error (null)");
            this.doNotify();
        } else if (response.exception != null) {
            EaglerXBungee.logger().log(Level.SEVERE, "Exception loading vanilla default profile!", response.exception);
            this.doNotify();
        } else if (response.code != 200) {
            EaglerXBungee.logger().severe("Recieved code " + response.code + " while looking up UUID of " + this.config.getEaglerPlayersVanillaSkin());
            this.doNotify();
        } else if (response.data == null) {
            EaglerXBungee.logger().severe("Recieved null payload while looking up UUID of " + this.config.getEaglerPlayersVanillaSkin());
            this.doNotify();
        } else {
            try {
                JsonObject jsonObject = new JsonParser().parse(new String(response.data, StandardCharsets.UTF_8)).getAsJsonObject();
                String string = jsonObject.get("id").getAsString();
                URI uRI = URI.create("https://sessionserver.mojang.com/session/minecraft/profile/" + string + "?unsigned=false");
                BinaryHttpClient.asyncRequest("GET", uRI, new ProfileSkinConsumerImpl(string));
            }
            catch (Throwable throwable) {
                EaglerXBungee.logger().log(Level.SEVERE, "Exception processing name to UUID lookup response!", throwable);
                this.doNotify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doNotify() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isLocked) {
                this.isLocked = false;
                this.lock.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void lookupVanillaSkinUser(EaglerBungeeConfig eaglerBungeeConfig) {
        String string = eaglerBungeeConfig.getEaglerPlayersVanillaSkin();
        EaglerXBungee.logger().info("Loading vanilla profile: " + string);
        URI uRI = URI.create("https://api.mojang.com/users/profiles/minecraft/" + string);
        VanillaDefaultSkinProfileLoader vanillaDefaultSkinProfileLoader = new VanillaDefaultSkinProfileLoader(eaglerBungeeConfig);
        Object object = vanillaDefaultSkinProfileLoader.lock;
        synchronized (object) {
            BinaryHttpClient.asyncRequest("GET", uRI, vanillaDefaultSkinProfileLoader);
            if (vanillaDefaultSkinProfileLoader.isLocked) {
                try {
                    vanillaDefaultSkinProfileLoader.lock.wait(5000L);
                }
                catch (InterruptedException interruptedException) {}
                if (vanillaDefaultSkinProfileLoader.isLocked) {
                    EaglerXBungee.logger().warning("Profile load timed out");
                }
            }
        }
    }

    private class ProfileSkinConsumerImpl
    implements Consumer<BinaryHttpClient.Response> {
        private final String uuid;

        private ProfileSkinConsumerImpl(String string) {
            this.uuid = string;
        }

        @Override
        public void accept(BinaryHttpClient.Response response) {
            if (response == null) {
                EaglerXBungee.logger().severe("Request error (null)");
                VanillaDefaultSkinProfileLoader.this.doNotify();
            } else if (response.exception != null) {
                EaglerXBungee.logger().log(Level.SEVERE, "Exception loading vanilla default profile!", response.exception);
                VanillaDefaultSkinProfileLoader.this.doNotify();
            } else if (response.code != 200) {
                EaglerXBungee.logger().severe("Recieved code " + response.code + " while looking up profile of " + this.uuid);
                VanillaDefaultSkinProfileLoader.this.doNotify();
            } else if (response.data == null) {
                EaglerXBungee.logger().severe("Recieved null payload while looking up profile of " + this.uuid);
                VanillaDefaultSkinProfileLoader.this.doNotify();
            } else {
                try {
                    JsonArray jsonArray;
                    JsonObject jsonObject = new JsonParser().parse(new String(response.data, StandardCharsets.UTF_8)).getAsJsonObject();
                    JsonElement jsonElement = jsonObject.get("properties");
                    if (jsonElement != null && (jsonArray = jsonElement.getAsJsonArray()).size() > 0) {
                        int n = 0;
                        int n2 = jsonArray.size();
                        while (n < n2) {
                            JsonObject jsonObject2;
                            JsonElement jsonElement2 = jsonArray.get(n);
                            if (jsonElement2.isJsonObject() && (jsonObject2 = jsonElement2.getAsJsonObject()).get("name").getAsString().equals("textures")) {
                                JsonElement jsonElement3 = jsonObject2.get("value");
                                JsonElement jsonElement4 = jsonObject2.get("signature");
                                if (jsonElement3 != null) {
                                    Property property = new Property("textures", jsonElement3.getAsString(), jsonElement4 != null ? jsonElement4.getAsString() : null);
                                    ((VanillaDefaultSkinProfileLoader)VanillaDefaultSkinProfileLoader.this).config.eaglerPlayersVanillaSkinCached = new Property[]{property, EaglerBungeeConfig.isEaglerProperty};
                                }
                                EaglerXBungee.logger().info("Loaded vanilla profile: " + VanillaDefaultSkinProfileLoader.this.config.getEaglerPlayersVanillaSkin());
                                VanillaDefaultSkinProfileLoader.this.doNotify();
                                return;
                            }
                            ++n;
                        }
                    }
                    EaglerXBungee.logger().warning("No skin was found for: " + VanillaDefaultSkinProfileLoader.this.config.getEaglerPlayersVanillaSkin());
                }
                catch (Throwable throwable) {
                    EaglerXBungee.logger().log(Level.SEVERE, "Exception processing name to UUID lookup response!", throwable);
                }
                VanillaDefaultSkinProfileLoader.this.doNotify();
            }
        }
    }
}

