/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.command;

import java.util.logging.Level;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.EaglerXBungee;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.auth.DefaultAuthSystem;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.config.EaglerAuthConfig;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.command.ConsoleCommandSender;

public class CommandEaglerPurge
extends Command {
    public CommandEaglerPurge(String string) {
        super(String.valueOf(string) + "-purge", "eaglercraft.command.purge", new String[0]);
    }

    public void execute(CommandSender commandSender, String[] stringArray) {
        if (commandSender instanceof ConsoleCommandSender) {
            DefaultAuthSystem defaultAuthSystem;
            int n;
            if (stringArray.length != 1) {
                TextComponent textComponent = new TextComponent("Use /" + this.getName() + " <maxAge>");
                textComponent.setColor(ChatColor.RED);
                commandSender.sendMessage((BaseComponent)textComponent);
                return;
            }
            try {
                n = Integer.parseInt(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                TextComponent textComponent = new TextComponent("'" + stringArray[0] + "' is not an integer!");
                textComponent.setColor(ChatColor.RED);
                commandSender.sendMessage((BaseComponent)textComponent);
                return;
            }
            EaglerAuthConfig eaglerAuthConfig = EaglerXBungee.getEagler().getConfig().getAuthConfig();
            if (eaglerAuthConfig.isEnableAuthentication() && eaglerAuthConfig.isUseBuiltInAuthentication() && (defaultAuthSystem = EaglerXBungee.getEagler().getAuthService()) != null) {
                int n2;
                try {
                    EaglerXBungee.logger().warning("Console is attempting to purge all accounts with " + n + " days of inactivity");
                    n2 = defaultAuthSystem.pruneUsers(System.currentTimeMillis() - (long)n * 86400000L);
                }
                catch (DefaultAuthSystem.AuthException authException) {
                    EaglerXBungee.logger().log(Level.SEVERE, "Failed to purge accounts", authException);
                    TextComponent textComponent = new TextComponent("Failed to purge, check log! Reason: " + authException.getMessage());
                    textComponent.setColor(ChatColor.AQUA);
                    commandSender.sendMessage((BaseComponent)textComponent);
                    return;
                }
                EaglerXBungee.logger().warning("Console purged " + n2 + " accounts from auth database");
                TextComponent textComponent = new TextComponent("Purged " + n2 + " old accounts from the database");
                textComponent.setColor(ChatColor.AQUA);
                commandSender.sendMessage((BaseComponent)textComponent);
            }
        } else {
            TextComponent textComponent = new TextComponent("This command can only be run from the console!");
            textComponent.setColor(ChatColor.RED);
            commandSender.sendMessage((BaseComponent)textComponent);
        }
    }
}

