/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.auth;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class AuthLoadingCache<K, V> {
    private final Map<K, CacheEntry<V>> cacheMap = new HashMap<K, CacheEntry<V>>();
    private final CacheLoader<K, V> provider;
    private final long cacheTTL;
    private long cacheTimer;

    public AuthLoadingCache(CacheLoader<K, V> cacheLoader, long l) {
        this.provider = cacheLoader;
        this.cacheTTL = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K k) {
        CacheEntry<V> cacheEntry;
        Map<K, CacheEntry<V>> map = this.cacheMap;
        synchronized (map) {
            cacheEntry = this.cacheMap.get(k);
        }
        if (cacheEntry == null) {
            map = this.provider.load(k);
            Map<K, CacheEntry<V>> map2 = this.cacheMap;
            synchronized (map2) {
                this.cacheMap.put(k, new CacheEntry(map));
            }
            return (V)map;
        }
        ((CacheEntry)cacheEntry).lastHit = System.currentTimeMillis();
        return (V)((CacheEntry)cacheEntry).instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evict(K k) {
        Map<K, CacheEntry<V>> map = this.cacheMap;
        synchronized (map) {
            this.cacheMap.remove(k);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evictAll(CacheVisitor<K, V> cacheVisitor) {
        Map<K, CacheEntry<V>> map = this.cacheMap;
        synchronized (map) {
            Iterator<Map.Entry<K, CacheEntry<V>>> iterator = this.cacheMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<K, CacheEntry<V>> entry = iterator.next();
                if (!cacheVisitor.shouldEvict(entry.getKey(), ((CacheEntry)entry.getValue()).instance)) continue;
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick() {
        long l = System.currentTimeMillis();
        if (l - this.cacheTimer > this.cacheTTL / 2L) {
            this.cacheTimer = l;
            Map<K, CacheEntry<V>> map = this.cacheMap;
            synchronized (map) {
                Iterator<CacheEntry<V>> iterator = this.cacheMap.values().iterator();
                while (iterator.hasNext()) {
                    CacheEntry<V> cacheEntry = iterator.next();
                    if (l - ((CacheEntry)cacheEntry).lastHit <= this.cacheTTL) continue;
                    iterator.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        Map<K, CacheEntry<V>> map = this.cacheMap;
        synchronized (map) {
            this.cacheMap.clear();
        }
    }

    private static class CacheEntry<V> {
        private long lastHit = System.currentTimeMillis();
        private V instance;

        private CacheEntry(V v) {
            this.instance = v;
        }
    }

    public static interface CacheLoader<K, V> {
        public V load(K var1);
    }

    public static interface CacheVisitor<K, V> {
        public boolean shouldEvict(K var1, V var2);
    }
}

