"use strict";
var main;
(function() {
var $rt_seed = 2463534242;
function $rt_nextId() {
    var x = $rt_seed;
    x ^= x << 13;
    x ^= x >> 17;
    x ^= x << 5;
    $rt_seed = x;
    return x;
}
function $rt_compare(a, b) {
    return a > b ? 1 : a < b ?  -1 : a === b ? 0 : 1;
}
function $rt_isInstance(obj, cls) {
    return obj !== null && !!obj.constructor.$meta && $rt_isAssignable(obj.constructor, cls);
}
function $rt_isAssignable(from, to) {
    if (from === to) {
        return true;
    }
    if (to.$meta.item !== null) {
        return from.$meta.item !== null && $rt_isAssignable(from.$meta.item, to.$meta.item);
    }
    var supertypes = from.$meta.supertypes;
    for (var i = 0;i < supertypes.length;i = i + 1 | 0) {
        if ($rt_isAssignable(supertypes[i], to)) {
            return true;
        }
    }
    return false;
}
function $rt_createArray(cls, sz) {
    var data = new Array(sz);
    var arr = new $rt_array(cls, data);
    if (sz > 0) {
        var i = 0;
        do  {
            data[i] = null;
            i = i + 1 | 0;
        }while (i < sz);
    }
    return arr;
}
function $rt_wrapArray(cls, data) {
    return new $rt_array(cls, data);
}
function $rt_createUnfilledArray(cls, sz) {
    return new $rt_array(cls, new Array(sz));
}
function $rt_createLongArray(sz) {
    var data = new Array(sz);
    var arr = new $rt_array($rt_longcls(), data);
    for (var i = 0;i < sz;i = i + 1 | 0) {
        data[i] = Long_ZERO;
    }
    return arr;
}
function $rt_createNumericArray(cls, nativeArray) {
    return new $rt_array(cls, nativeArray);
}
function $rt_createCharArray(sz) {
    return $rt_createNumericArray($rt_charcls(), new Uint16Array(sz));
}
function $rt_createByteArray(sz) {
    return $rt_createNumericArray($rt_bytecls(), new Int8Array(sz));
}
function $rt_createShortArray(sz) {
    return $rt_createNumericArray($rt_shortcls(), new Int16Array(sz));
}
function $rt_createIntArray(sz) {
    return $rt_createNumericArray($rt_intcls(), new Int32Array(sz));
}
function $rt_createBooleanArray(sz) {
    return $rt_createNumericArray($rt_booleancls(), new Int8Array(sz));
}
function $rt_createFloatArray(sz) {
    return $rt_createNumericArray($rt_floatcls(), new Float32Array(sz));
}
function $rt_createDoubleArray(sz) {
    return $rt_createNumericArray($rt_doublecls(), new Float64Array(sz));
}
function $rt_arraycls(cls) {
    var result = cls.$array;
    if (result === null) {
        var arraycls = {  };
        var name = "[" + cls.$meta.binaryName;
        arraycls.$meta = { item : cls, supertypes : [$rt_objcls()], primitive : false, superclass : $rt_objcls(), name : name, binaryName : name, enum : false };
        arraycls.classObject = null;
        arraycls.$array = null;
        result = arraycls;
        cls.$array = arraycls;
    }
    return result;
}
function $rt_createcls() {
    return { $array : null, classObject : null, $meta : { supertypes : [], superclass : null } };
}
function $rt_createPrimitiveCls(name, binaryName) {
    var cls = $rt_createcls();
    cls.$meta.primitive = true;
    cls.$meta.name = name;
    cls.$meta.binaryName = binaryName;
    cls.$meta.enum = false;
    cls.$meta.item = null;
    return cls;
}
var $rt_booleanclsCache = null;
function $rt_booleancls() {
    if ($rt_booleanclsCache === null) {
        $rt_booleanclsCache = $rt_createPrimitiveCls("boolean", "Z");
    }
    return $rt_booleanclsCache;
}
var $rt_charclsCache = null;
function $rt_charcls() {
    if ($rt_charclsCache === null) {
        $rt_charclsCache = $rt_createPrimitiveCls("char", "C");
    }
    return $rt_charclsCache;
}
var $rt_byteclsCache = null;
function $rt_bytecls() {
    if ($rt_byteclsCache === null) {
        $rt_byteclsCache = $rt_createPrimitiveCls("byte", "B");
    }
    return $rt_byteclsCache;
}
var $rt_shortclsCache = null;
function $rt_shortcls() {
    if ($rt_shortclsCache === null) {
        $rt_shortclsCache = $rt_createPrimitiveCls("short", "S");
    }
    return $rt_shortclsCache;
}
var $rt_intclsCache = null;
function $rt_intcls() {
    if ($rt_intclsCache === null) {
        $rt_intclsCache = $rt_createPrimitiveCls("int", "I");
    }
    return $rt_intclsCache;
}
var $rt_longclsCache = null;
function $rt_longcls() {
    if ($rt_longclsCache === null) {
        $rt_longclsCache = $rt_createPrimitiveCls("long", "J");
    }
    return $rt_longclsCache;
}
var $rt_floatclsCache = null;
function $rt_floatcls() {
    if ($rt_floatclsCache === null) {
        $rt_floatclsCache = $rt_createPrimitiveCls("float", "F");
    }
    return $rt_floatclsCache;
}
var $rt_doubleclsCache = null;
function $rt_doublecls() {
    if ($rt_doubleclsCache === null) {
        $rt_doubleclsCache = $rt_createPrimitiveCls("double", "D");
    }
    return $rt_doubleclsCache;
}
var $rt_voidclsCache = null;
function $rt_voidcls() {
    if ($rt_voidclsCache === null) {
        $rt_voidclsCache = $rt_createPrimitiveCls("void", "V");
    }
    return $rt_voidclsCache;
}
function $rt_throw(ex) {
    throw $rt_exception(ex);
}
function $rt_exception(ex) {
    var err = ex.$jsException;
    if (!err) {
        err = new Error("Java exception thrown");
        if (typeof Error.captureStackTrace === "function") {
            Error.captureStackTrace(err);
        }
        err.$javaException = ex;
        ex.$jsException = err;
        $rt_fillStack(err, ex);
    }
    return err;
}
function $rt_fillStack(err, ex) {
    if (typeof $rt_decodeStack === "function" && err.stack) {
        var stack = $rt_decodeStack(err.stack);
        var javaStack = $rt_createArray($rt_objcls(), stack.length);
        var elem;
        var noStack = false;
        for (var i = 0;i < stack.length;++i) {
            var element = stack[i];
            elem = $rt_createStackElement($rt_str(element.className), $rt_str(element.methodName), $rt_str(element.fileName), element.lineNumber);
            if (elem == null) {
                noStack = true;
                break;
            }
            javaStack.data[i] = elem;
        }
        if (!noStack) {
            $rt_setStack(ex, javaStack);
        }
    }
}
function $rt_createMultiArray(cls, dimensions) {
    var first = 0;
    for (var i = dimensions.length - 1;i >= 0;i = i - 1 | 0) {
        if (dimensions[i] === 0) {
            first = i;
            break;
        }
    }
    if (first > 0) {
        for (i = 0;i < first;i = i + 1 | 0) {
            cls = $rt_arraycls(cls);
        }
        if (first === dimensions.length - 1) {
            return $rt_createArray(cls, dimensions[first]);
        }
    }
    var arrays = new Array($rt_primitiveArrayCount(dimensions, first));
    var firstDim = dimensions[first] | 0;
    for (i = 0;i < arrays.length;i = i + 1 | 0) {
        arrays[i] = $rt_createArray(cls, firstDim);
    }
    return $rt_createMultiArrayImpl(cls, arrays, dimensions, first);
}
function $rt_createByteMultiArray(dimensions) {
    var arrays = new Array($rt_primitiveArrayCount(dimensions, 0));
    if (arrays.length === 0) {
        return $rt_createMultiArray($rt_bytecls(), dimensions);
    }
    var firstDim = dimensions[0] | 0;
    for (var i = 0;i < arrays.length;i = i + 1 | 0) {
        arrays[i] = $rt_createByteArray(firstDim);
    }
    return $rt_createMultiArrayImpl($rt_bytecls(), arrays, dimensions);
}
function $rt_createCharMultiArray(dimensions) {
    var arrays = new Array($rt_primitiveArrayCount(dimensions, 0));
    if (arrays.length === 0) {
        return $rt_createMultiArray($rt_charcls(), dimensions);
    }
    var firstDim = dimensions[0] | 0;
    for (var i = 0;i < arrays.length;i = i + 1 | 0) {
        arrays[i] = $rt_createCharArray(firstDim);
    }
    return $rt_createMultiArrayImpl($rt_charcls(), arrays, dimensions, 0);
}
function $rt_createBooleanMultiArray(dimensions) {
    var arrays = new Array($rt_primitiveArrayCount(dimensions, 0));
    if (arrays.length === 0) {
        return $rt_createMultiArray($rt_booleancls(), dimensions);
    }
    var firstDim = dimensions[0] | 0;
    for (var i = 0;i < arrays.length;i = i + 1 | 0) {
        arrays[i] = $rt_createBooleanArray(firstDim);
    }
    return $rt_createMultiArrayImpl($rt_booleancls(), arrays, dimensions, 0);
}
function $rt_createShortMultiArray(dimensions) {
    var arrays = new Array($rt_primitiveArrayCount(dimensions, 0));
    if (arrays.length === 0) {
        return $rt_createMultiArray($rt_shortcls(), dimensions);
    }
    var firstDim = dimensions[0] | 0;
    for (var i = 0;i < arrays.length;i = i + 1 | 0) {
        arrays[i] = $rt_createShortArray(firstDim);
    }
    return $rt_createMultiArrayImpl($rt_shortcls(), arrays, dimensions, 0);
}
function $rt_createIntMultiArray(dimensions) {
    var arrays = new Array($rt_primitiveArrayCount(dimensions, 0));
    if (arrays.length === 0) {
        return $rt_createMultiArray($rt_intcls(), dimensions);
    }
    var firstDim = dimensions[0] | 0;
    for (var i = 0;i < arrays.length;i = i + 1 | 0) {
        arrays[i] = $rt_createIntArray(firstDim);
    }
    return $rt_createMultiArrayImpl($rt_intcls(), arrays, dimensions, 0);
}
function $rt_createLongMultiArray(dimensions) {
    var arrays = new Array($rt_primitiveArrayCount(dimensions, 0));
    if (arrays.length === 0) {
        return $rt_createMultiArray($rt_longcls(), dimensions);
    }
    var firstDim = dimensions[0] | 0;
    for (var i = 0;i < arrays.length;i = i + 1 | 0) {
        arrays[i] = $rt_createLongArray(firstDim);
    }
    return $rt_createMultiArrayImpl($rt_longcls(), arrays, dimensions, 0);
}
function $rt_createFloatMultiArray(dimensions) {
    var arrays = new Array($rt_primitiveArrayCount(dimensions, 0));
    if (arrays.length === 0) {
        return $rt_createMultiArray($rt_floatcls(), dimensions);
    }
    var firstDim = dimensions[0] | 0;
    for (var i = 0;i < arrays.length;i = i + 1 | 0) {
        arrays[i] = $rt_createFloatArray(firstDim);
    }
    return $rt_createMultiArrayImpl($rt_floatcls(), arrays, dimensions, 0);
}
function $rt_createDoubleMultiArray(dimensions) {
    var arrays = new Array($rt_primitiveArrayCount(dimensions, 0));
    if (arrays.length === 0) {
        return $rt_createMultiArray($rt_doublecls(), dimensions);
    }
    var firstDim = dimensions[0] | 0;
    for (var i = 0;i < arrays.length;i = i + 1 | 0) {
        arrays[i] = $rt_createDoubleArray(firstDim);
    }
    return $rt_createMultiArrayImpl($rt_doublecls(), arrays, dimensions, 0);
}
function $rt_primitiveArrayCount(dimensions, start) {
    var val = dimensions[start + 1] | 0;
    for (var i = start + 2;i < dimensions.length;i = i + 1 | 0) {
        val = val * (dimensions[i] | 0) | 0;
        if (val === 0) {
            break;
        }
    }
    return val;
}
function $rt_createMultiArrayImpl(cls, arrays, dimensions, start) {
    var limit = arrays.length;
    for (var i = start + 1 | 0;i < dimensions.length;i = i + 1 | 0) {
        cls = $rt_arraycls(cls);
        var dim = dimensions[i];
        var index = 0;
        var packedIndex = 0;
        while (index < limit) {
            var arr = $rt_createUnfilledArray(cls, dim);
            for (var j = 0;j < dim;j = j + 1 | 0) {
                arr.data[j] = arrays[index];
                index = index + 1 | 0;
            }
            arrays[packedIndex] = arr;
            packedIndex = packedIndex + 1 | 0;
        }
        limit = packedIndex;
    }
    return arrays[0];
}
function $rt_assertNotNaN(value) {
    if (typeof value === 'number' && isNaN(value)) {
        throw "NaN";
    }
    return value;
}
var $rt_stdoutBuffer = "";
var $rt_putStdout = typeof $rt_putStdoutCustom === "function" ? $rt_putStdoutCustom : function(ch) {
    if (ch === 0xA) {
        if (console) {
            console.info($rt_stdoutBuffer);
        }
        $rt_stdoutBuffer = "";
    } else {
        $rt_stdoutBuffer += String.fromCharCode(ch);
    }
};
var $rt_stderrBuffer = "";
var $rt_putStderr = typeof $rt_putStderrCustom === "function" ? $rt_putStderrCustom : function(ch) {
    if (ch === 0xA) {
        if (console) {
            console.error($rt_stderrBuffer);
        }
        $rt_stderrBuffer = "";
    } else {
        $rt_stderrBuffer += String.fromCharCode(ch);
    }
};
var $rt_packageData = null;
function $rt_packages(data) {
    var i = 0;
    var packages = new Array(data.length);
    for (var j = 0;j < data.length;++j) {
        var prefixIndex = data[i++];
        var prefix = prefixIndex >= 0 ? packages[prefixIndex] : "";
        packages[j] = prefix + data[i++] + ".";
    }
    $rt_packageData = packages;
}
function $rt_metadata(data) {
    var packages = $rt_packageData;
    var i = 0;
    while (i < data.length) {
        var cls = data[i++];
        cls.$meta = {  };
        var m = cls.$meta;
        var className = data[i++];
        m.name = className !== 0 ? className : null;
        if (m.name !== null) {
            var packageIndex = data[i++];
            if (packageIndex >= 0) {
                m.name = packages[packageIndex] + m.name;
            }
        }
        m.binaryName = "L" + m.name + ";";
        var superclass = data[i++];
        m.superclass = superclass !== 0 ? superclass : null;
        m.supertypes = data[i++];
        if (m.superclass) {
            m.supertypes.push(m.superclass);
            cls.prototype = Object.create(m.superclass.prototype);
        } else {
            cls.prototype = {  };
        }
        var flags = data[i++];
        m.enum = (flags & 8) !== 0;
        m.flags = flags;
        m.primitive = false;
        m.item = null;
        cls.prototype.constructor = cls;
        cls.classObject = null;
        m.accessLevel = data[i++];
        var clinit = data[i++];
        cls.$clinit = clinit !== 0 ? clinit : function() {
        };
        var virtualMethods = data[i++];
        if (virtualMethods !== 0) {
            for (var j = 0;j < virtualMethods.length;j += 2) {
                var name = virtualMethods[j];
                var func = virtualMethods[j + 1];
                if (typeof name === 'string') {
                    name = [name];
                }
                for (var k = 0;k < name.length;++k) {
                    cls.prototype[name[k]] = func;
                }
            }
        }
        cls.$array = null;
    }
}
function $rt_threadStarter(f) {
    return function() {
        var args = Array.prototype.slice.apply(arguments);
        $rt_startThread(function() {
            f.apply(this, args);
        });
    };
}
function $rt_mainStarter(f) {
    return function(args, callback) {
        if (!args) {
            args = [];
        }
        var javaArgs = $rt_createArray($rt_objcls(), args.length);
        for (var i = 0;i < args.length;++i) {
            javaArgs.data[i] = $rt_str(args[i]);
        }
        $rt_startThread(function() {
            f.call(null, javaArgs);
        }, callback);
    };
}
var $rt_stringPool_instance;
function $rt_stringPool(strings) {
    $rt_stringPool_instance = new Array(strings.length);
    for (var i = 0;i < strings.length;++i) {
        $rt_stringPool_instance[i] = $rt_intern($rt_str(strings[i]));
    }
}
function $rt_s(index) {
    return $rt_stringPool_instance[index];
}
function $rt_eraseClinit(target) {
    return target.$clinit = function() {
    };
}
var $rt_numberConversionView = new DataView(new ArrayBuffer(8));
function $rt_doubleToLongBits(n) {
    $rt_numberConversionView.setFloat64(0, n, true);
    return new Long($rt_numberConversionView.getInt32(0, true), $rt_numberConversionView.getInt32(4, true));
}
function $rt_longBitsToDouble(n) {
    $rt_numberConversionView.setInt32(0, n.lo, true);
    $rt_numberConversionView.setInt32(4, n.hi, true);
    return $rt_numberConversionView.getFloat64(0, true);
}
function $rt_floatToIntBits(n) {
    $rt_numberConversionView.setFloat32(0, n);
    return $rt_numberConversionView.getInt32(0);
}
function $rt_intBitsToFloat(n) {
    $rt_numberConversionView.setInt32(0, n);
    return $rt_numberConversionView.getFloat32(0);
}
function $rt_javaException(e) {
    return e instanceof Error && typeof e.$javaException === 'object' ? e.$javaException : null;
}
function $rt_jsException(e) {
    return typeof e.$jsException === 'object' ? e.$jsException : null;
}
function $rt_wrapException(err) {
    var ex = err.$javaException;
    if (!ex) {
        ex = $rt_createException($rt_str("(JavaScript) " + err.toString()));
        err.$javaException = ex;
        ex.$jsException = err;
        $rt_fillStack(err, ex);
    }
    return ex;
}
function $dbg_class(obj) {
    var cls = obj.constructor;
    var arrayDegree = 0;
    while (cls.$meta && cls.$meta.item) {
        ++arrayDegree;
        cls = cls.$meta.item;
    }
    var clsName = "";
    if (cls === $rt_booleancls()) {
        clsName = "boolean";
    } else if (cls === $rt_bytecls()) {
        clsName = "byte";
    } else if (cls === $rt_shortcls()) {
        clsName = "short";
    } else if (cls === $rt_charcls()) {
        clsName = "char";
    } else if (cls === $rt_intcls()) {
        clsName = "int";
    } else if (cls === $rt_longcls()) {
        clsName = "long";
    } else if (cls === $rt_floatcls()) {
        clsName = "float";
    } else if (cls === $rt_doublecls()) {
        clsName = "double";
    } else {
        clsName = cls.$meta ? cls.$meta.name || "a/" + cls.name : "@" + cls.name;
    }
    while (arrayDegree-- > 0) {
        clsName += "[]";
    }
    return clsName;
}
function Long(lo, hi) {
    this.lo = lo | 0;
    this.hi = hi | 0;
}
Long.prototype.__teavm_class__ = function() {
    return "long";
};
Long.prototype.toString = function() {
    var result = [];
    var n = this;
    var positive = Long_isPositive(n);
    if (!positive) {
        n = Long_neg(n);
    }
    var radix = new Long(10, 0);
    do  {
        var divRem = Long_divRem(n, radix);
        result.push(String.fromCharCode(48 + divRem[1].lo));
        n = divRem[0];
    }while (n.lo !== 0 || n.hi !== 0);
    result = (result.reverse()).join('');
    return positive ? result : "-" + result;
};
Long.prototype.valueOf = function() {
    return Long_toNumber(this);
};
var Long_ZERO = new Long(0, 0);
var Long_MAX_NORMAL = 1 << 18;
function Long_fromInt(val) {
    return val >= 0 ? new Long(val, 0) : new Long(val,  -1);
}
function Long_fromNumber(val) {
    if (val >= 0) {
        return new Long(val | 0, val / 0x100000000 | 0);
    } else {
        return Long_neg(new Long( -val | 0,  -val / 0x100000000 | 0));
    }
}
function Long_toNumber(val) {
    var lo = val.lo;
    var hi = val.hi;
    if (lo < 0) {
        lo += 0x100000000;
    }
    return 0x100000000 * hi + lo;
}
var $rt_imul = Math.imul || function(a, b) {
    var ah = a >>> 16 & 0xFFFF;
    var al = a & 0xFFFF;
    var bh = b >>> 16 & 0xFFFF;
    var bl = b & 0xFFFF;
    return al * bl + (ah * bl + al * bh << 16 >>> 0) | 0;
};
var $rt_udiv = function(a, b) {
    if (a < 0) {
        a += 0x100000000;
    }
    if (b < 0) {
        b += 0x100000000;
    }
    return a / b | 0;
};
var $rt_umod = function(a, b) {
    if (a < 0) {
        a += 0x100000000;
    }
    if (b < 0) {
        b += 0x100000000;
    }
    return a % b | 0;
};
function $rt_setCloneMethod(target, f) {
    target.$clone = f;
}
function $rt_cls(cls) {
    return jl_Class_getClass(cls);
}
function $rt_str(str) {
    if (str === null) {
        return null;
    }
    var characters = $rt_createCharArray(str.length);
    var charsBuffer = characters.data;
    for (var i = 0; i < str.length; i = (i + 1) | 0) {
        charsBuffer[i] = str.charCodeAt(i) & 0xFFFF;
    }
    return jl_String__init_(characters);
}
function $rt_ustr(str) {
    if (str === null) {
        return null;
    }
    var data = str.$characters.data;
    var result = "";
    for (var i = 0; i < data.length; i = (i + 1) | 0) {
        result += String.fromCharCode(data[i]);
    }
    return result;
}
function $rt_objcls() { return jl_Object; }
function $rt_nullCheck(val) {
    if (val === null) {
        $rt_throw(jl_NullPointerException__init_());
    }
    return val;
}
function $rt_intern(str) {
    return str;
}
function $rt_getThread() {
    return jl_Thread_currentThread();
}
function $rt_setThread(t) {
    return jl_Thread_setCurrentThread(t);
}
function $rt_createException(message) {
    return jl_RuntimeException__init_(message);
}
function $rt_createStackElement(className, methodName, fileName, lineNumber) {
    return null;
}
function $rt_setStack(e, stack) {
}
var $java = Object.create(null);
function jl_Object() {
    this.$monitor = null;
    this.$id$ = 0;
}
function jl_Object__init_() {
    var var_0 = new jl_Object();
    jl_Object__init_0(var_0);
    return var_0;
}
function jl_Object_monitorEnterSync($o) {
    var var$2;
    if ($o.$monitor === null)
        jl_Object_createMonitor($o);
    if ($o.$monitor.$owner === null)
        $o.$monitor.$owner = jl_Thread_currentThread0;
    else if ($o.$monitor.$owner !== jl_Thread_currentThread0) {
        var$2 = new jl_IllegalStateException;
        jl_Throwable__init_(var$2, $rt_s(0));
        $rt_throw(var$2);
    }
    $o = $o.$monitor;
    $o.$count = $o.$count + 1 | 0;
}
function jl_Object_monitorExitSync($o) {
    var var$2, var$3;
    if (!jl_Object_isEmptyMonitor($o) && $o.$monitor.$owner === jl_Thread_currentThread0) {
        var$2 = $o.$monitor;
        var$3 = var$2.$count - 1 | 0;
        var$2.$count = var$3;
        if (!var$3)
            $o.$monitor.$owner = null;
        jl_Object_isEmptyMonitor($o);
        return;
    }
    $o = new jl_IllegalMonitorStateException;
    jl_Throwable__init_0($o);
    $rt_throw($o);
}
function jl_Object_monitorEnter($o) {
    if ($o.$monitor === null)
        jl_Object_createMonitor($o);
    if ($o.$monitor.$owner === null)
        $o.$monitor.$owner = jl_Thread_currentThread0;
    if ($o.$monitor.$owner !== jl_Thread_currentThread0)
        jl_Object_monitorEnterWait($o, 1);
    else {
        $o = $o.$monitor;
        $o.$count = $o.$count + 1 | 0;
    }
}
function jl_Object_createMonitor($o) {
    $o.$monitor = jl_Object$Monitor__init_();
}
function jl_Object_monitorEnterWait(var$1, var$2) {
    var thread = $rt_nativeThread();
    var javaThread = $rt_getThread();
    if (thread.isResuming()) {
        thread.status = 0;
        var result = thread.attribute;
        if (result instanceof Error) {
            throw result;
        }
        return result;
    }
    var callback = function() {};
    callback.$complete = function(val) {
        thread.attribute = val;
        $rt_setThread(javaThread);
        thread.resume();
    };
    callback.$error = function(e) {
        thread.attribute = $rt_exception(e);
        $rt_setThread(javaThread);
        thread.resume();
    };
    callback = otpp_AsyncCallbackWrapper_create(callback);
    return thread.suspend(function() {
        try {
            jl_Object_monitorEnterWait0(var$1, var$2, callback);
        } catch($e) {
            callback.$error($rt_exception($e));
        }
    });
}
function jl_Object_monitorEnterWait0($o, $count, $callback) {
    var $thread_0, $monitor, var$6;
    $thread_0 = jl_Thread_currentThread0;
    if ($o.$monitor === null) {
        jl_Object_createMonitor($o);
        jl_Thread_setCurrentThread($thread_0);
        $o = $o.$monitor;
        $o.$count = $o.$count + $count | 0;
        otpp_AsyncCallbackWrapper_complete($callback, null);
        return;
    }
    if ($o.$monitor.$owner === null) {
        $o.$monitor.$owner = $thread_0;
        jl_Thread_setCurrentThread($thread_0);
        $o = $o.$monitor;
        $o.$count = $o.$count + $count | 0;
        otpp_AsyncCallbackWrapper_complete($callback, null);
        return;
    }
    $monitor = $o.$monitor;
    if ($monitor.$enteringThreads === null)
        $monitor.$enteringThreads = otp_Platform_createQueueJs$js_body$_30();
    $monitor = $monitor.$enteringThreads;
    var$6 = new jl_Object$monitorEnterWait$lambda$_6_0;
    var$6.$_0 = $thread_0;
    var$6.$_1 = $o;
    var$6.$_2 = $count;
    var$6.$_3 = $callback;
    $callback = var$6;
    $monitor.push($callback);
}
function jl_Object_monitorExit($o) {
    var var$2;
    if (!jl_Object_isEmptyMonitor($o) && $o.$monitor.$owner === jl_Thread_currentThread0) {
        var$2 = $o.$monitor;
        var$2.$count = var$2.$count - 1 | 0;
        if (var$2.$count <= 0) {
            var$2.$owner = null;
            if (var$2.$enteringThreads !== null && !otp_PlatformQueue_isEmpty$static(var$2.$enteringThreads)) {
                var$2 = new jl_Object$monitorExit$lambda$_8_0;
                var$2.$_00 = $o;
                otp_Platform_postpone(var$2);
            } else
                jl_Object_isEmptyMonitor($o);
        }
        return;
    }
    $o = new jl_IllegalMonitorStateException;
    jl_Throwable__init_0($o);
    $rt_throw($o);
}
function jl_Object_isEmptyMonitor($this) {
    var $monitor;
    $monitor = $this.$monitor;
    if ($monitor === null)
        return 1;
    a: {
        if ($monitor.$owner === null && !($monitor.$enteringThreads !== null && !otp_PlatformQueue_isEmpty$static($monitor.$enteringThreads))) {
            if ($monitor.$notifyListeners === null)
                break a;
            if (otp_PlatformQueue_isEmpty$static($monitor.$notifyListeners))
                break a;
        }
        return 0;
    }
    $this.$monitor = null;
    return 1;
}
function jl_Object__init_0($this) {
    return;
}
function jl_Object_getClass($this) {
    return jl_Class_getClass($this.constructor);
}
function jl_Object_hashCode($this) {
    return jl_Object_identity($this);
}
function jl_Object_equals($this, $other) {
    return $this !== $other ? 0 : 1;
}
function jl_Object_toString($this) {
    var var$1;
    var$1 = new jl_StringBuilder;
    jl_AbstractStringBuilder__init_(var$1);
    jl_AbstractStringBuilder_append(var$1, jl_Class_getName(jl_Object_getClass($this)));
    jl_AbstractStringBuilder_append(var$1, $rt_s(1));
    jl_AbstractStringBuilder_append(var$1, jl_Integer_toHexString(jl_Object_identity($this)));
    return jl_AbstractStringBuilder_toString(var$1);
}
function jl_Object_identity($this) {
    var $platformThis, var$2;
    $platformThis = $this;
    if (!$platformThis.$id$) {
        var$2 = $rt_nextId();
        $platformThis.$id$ = var$2;
    }
    return $this.$id$;
}
function jl_Object_clone($this) {
    var $result, var$2, var$3;
    if (!$rt_isInstance($this, jl_Cloneable) && $this.constructor.$meta.item === null) {
        $result = new jl_CloneNotSupportedException;
        jl_Throwable__init_0($result);
        $rt_throw($result);
    }
    $result = otp_Platform_clone($this);
    var$2 = $result;
    var$3 = $rt_nextId();
    var$2.$id$ = var$3;
    return $result;
}
function jl_Object_notifyAll($this) {
    var $listeners, $listener;
    if (!($this.$monitor !== null && $this.$monitor.$owner === jl_Thread_currentThread0 ? 1 : 0)) {
        $listeners = new jl_IllegalMonitorStateException;
        jl_Throwable__init_0($listeners);
        $rt_throw($listeners);
    }
    $listeners = $this.$monitor.$notifyListeners;
    if ($listeners === null)
        return;
    while (!otp_PlatformQueue_isEmpty$static($listeners)) {
        $listener = otp_PlatformQueue_remove$static($listeners);
        if (!$listener.$expired())
            otp_Platform_postpone($listener);
    }
    $this.$monitor.$notifyListeners = null;
}
function nle_Client() {
    jl_Object.call(this);
}
var nle_Client_rootElement = null;
var nle_Client_instance = null;
var nle_Client_isCrashed = 0;
function nle_Client__init_() {
    var var_0 = new nle_Client();
    nle_Client__init_0(var_0);
    return var_0;
}
function nle_Client__init_0($this) {
    return;
}
function nle_Client_main($args) {
    var var$2, var$3, var$4, $ptr, $tmp;
    $ptr = 0;
    if ($rt_resuming()) {
        var $thread = $rt_nativeThread();
        $ptr = $thread.pop();var$4 = $thread.pop();var$3 = $thread.pop();var$2 = $thread.pop();$args = $thread.pop();
    }
    main: while (true) { switch ($ptr) {
    case 0:
        nle_Client__clinit_();
        jl_String__clinit_();
        jl_Integer__clinit_();
        jl_Character__clinit_();
        ju_Locale__clinit_();
        ju_Calendar__clinit_();
        ju_GregorianCalendar__clinit_();
        otcit_CachedDateTimeZone__clinit_();
        otcit_DateTimeZoneProvider__clinit_();
        nms_NBTBase__clinit_();
        jl_Float__clinit_();
        jl_Byte__clinit_();
        jl_Long__clinit_();
        jl_Double__clinit_();
        jm_BigInteger__clinit_();
        jl_Short__clinit_();
        jl_Boolean__clinit_();
        ju_TimeZone__clinit_();
        nle_LocalStorageManager__clinit_();
        nms_ServerList__clinit_();
        nle_EarlyLoadScreen__clinit_();
        jl_Thread__clinit_();
        nle_AssetRepository__clinit_();
        nle_Base64__clinit_();
        nle_BaseNCodec__clinit_();
        jur_AbstractSet__clinit_();
        jur_AbstractCharClass$PredefinedCharacterClasses__clinit_();
        jur_AbstractCharClass__clinit_();
        jur_FSet__clinit_();
        nle_ConfigConstants__clinit_();
        nms_ServerData__clinit_();
        nmc_Minecraft__clinit_();
        nms_GLAllocation__clinit_();
        nms_Packet3Chat__clinit_();
        jl_AbstractStringBuilder$Constants__clinit_();
        otcit_FloatAnalyzer__clinit_();
        otcit_DoubleAnalyzer__clinit_();
        nms_EntityLiving__clinit_();
        nms_DataWatcher__clinit_();
        nms_Entity__clinit_();
        nms_EntityList__clinit_();
        ju_Hashtable__clinit_();
        nms_StringTranslate__clinit_();
        nms_StatCollector__clinit_();
        nms_MapColor__clinit_();
        nms_CreativeTabs__clinit_();
        nms_BlockWood__clinit_();
        nms_BlockSapling__clinit_();
        nms_BlockSand__clinit_();
        nms_BlockLog__clinit_();
        nms_BlockLeaves__clinit_();
        nms_BlockSandStone__clinit_();
        nms_BlockBed__clinit_();
        nms_BlockTallGrass__clinit_();
        nms_BlockStep__clinit_();
        nms_BlockStairs__clinit_();
        nms_BlockFurnace__clinit_();
        nms_BlockDoor__clinit_();
        nms_EnumMobType__clinit_();
        nms_BlockRedstoneTorch__clinit_();
        nms_BlockRedstoneRepeater__clinit_();
        nms_BlockSilverfish__clinit_();
        nms_BlockStoneBrick__clinit_();
        nms_BlockMushroomCap__clinit_();
        nms_BlockNetherStalk__clinit_();
        nms_BlockEndPortal__clinit_();
        nms_BlockWoodSlab__clinit_();
        nms_BlockCocoa__clinit_();
        nms_BlockWall__clinit_();
        nms_BlockAnvil__clinit_();
        nms_BlockQuartz__clinit_();
        nms_EnumToolMaterial__clinit_();
        jn_ByteOrder__clinit_();
        jnc_CodingErrorAction__clinit_();
        jnc_CoderResult__clinit_();
        cjj_Deflate__clinit_();
        cjj_CRC32__clinit_();
        cjj_Tree__clinit_();
        nms_ItemBow__clinit_();
        nms_Potion__clinit_();
        nms_ItemArmor__clinit_();
        nms_EnumArmorMaterial__clinit_();
        nms_ItemDye__clinit_();
        nms_ItemPotion__clinit_();
        nms_ItemSkull__clinit_();
        nms_ItemRecord__clinit_();
        nms_MathHelper__clinit_();
        jt_DecimalFormat__clinit_();
        jm_RoundingMode__clinit_();
        jm_Conversion__clinit_();
        jlr_Modifier__clinit_();
        oj_JSONObject__clinit_();
        jl_Package__clinit_();
        jl_ClassLoader__clinit_();
        ju_Collections__clinit_();
        nle_TextureLocation__clinit_();
        nle_GuiScreenEditProfile__clinit_();
        jnc_Charset$Charsets__clinit_();
        nms_EnumOS__clinit_();
        nle_BaseNCodec$CodecPolicy__clinit_();
        cjj_Inflate__clinit_();
        nms_AxisAlignedBB__clinit_();
        nms_RenderBlocks__clinit_();
        nms_EntityRenderer__clinit_();
        nms_GuiAchievement__clinit_();
        ju_Date__clinit_();
        nms_TexturePackImplementation__clinit_();
        nms_ChatAllowedCharacters__clinit_();
        nms_ColorizerGrass__clinit_();
        nms_ColorizerFoliage__clinit_();
        nms_RenderManager__clinit_();
        nms_ItemRenderer__clinit_();
        nms_RenderGlobal__clinit_();
        nms_EffectRenderer__clinit_();
        nms_GuiIngame__clinit_();
        nms_LoadingScreenRenderer__clinit_();
        nle_GuiScreenLicense__clinit_();
        cjj_InfBlocks__clinit_();
        nle_DefaultSkinRenderer__clinit_();
        nms_GuiMultiplayer__clinit_();
        nle_GuiScreenVoiceChannel__clinit_();
        nms_KeyBinding__clinit_();
        nleg_FixedFunctionShader__clinit_();
        nms_EnumOptions__clinit_();
        nms_GuiInventory__clinit_();
        nms_InventoryEffectRenderer__clinit_();
        nms_GuiContainer__clinit_();
        nms_IMob__clinit_();
        nms_RenderSpider__clinit_();
        nms_RenderLiving__clinit_();
        nms_Render__clinit_();
        nms_RenderPig__clinit_();
        nms_EntitySheep__clinit_();
        nms_RenderSheep__clinit_();
        nms_RenderCow__clinit_();
        nms_RenderMooshroom__clinit_();
        nms_RenderWolf__clinit_();
        nms_RenderChicken__clinit_();
        nms_RenderOcelot__clinit_();
        nms_RenderSilverfish__clinit_();
        nms_RenderCreeper__clinit_();
        nms_RenderEnderman__clinit_();
        nms_RenderSnowMan__clinit_();
        nms_RenderSkeleton__clinit_();
        nms_RenderBiped__clinit_();
        nms_RenderWitch__clinit_();
        nms_RenderBlaze__clinit_();
        nms_RenderZombie__clinit_();
        nms_EntitySlime__clinit_();
        nms_RenderSlime__clinit_();
        nms_RenderMagmaCube__clinit_();
        nms_RenderPlayer__clinit_();
        nms_RenderGhast__clinit_();
        nms_RenderSquid__clinit_();
        nms_RenderVillager__clinit_();
        nms_RenderIronGolem__clinit_();
        nms_RenderBat__clinit_();
        nms_RenderDragon__clinit_();
        nms_RenderEnderCrystal__clinit_();
        nms_EntityWither__clinit_();
        nms_RenderWither__clinit_();
        nms_RenderPainting__clinit_();
        nms_RenderItemFrame__clinit_();
        nms_RenderArrow__clinit_();
        nms_RenderSnowball__clinit_();
        nms_RenderFireball__clinit_();
        nms_RenderWitherSkull__clinit_();
        nms_RenderItem__clinit_();
        nms_RenderXPOrb__clinit_();
        nms_RenderTNTPrimed__clinit_();
        nms_RenderFallingSand__clinit_();
        nms_EntityMinecart__clinit_();
        nms_RenderMinecart__clinit_();
        nms_RenderBoat__clinit_();
        nms_RenderFish__clinit_();
        nms_MapItemRenderer__clinit_();
        cjj_InfTree__clinit_();
        cjj_InfCodes__clinit_();
        nms_Vec3__clinit_();
        nms_GuiParticle__clinit_();
        nms_EnumMovingObjectType__clinit_();
        nms_ModelSilverfish__clinit_();
        ju_TreeSet__clinit_();
        maat_TMIConfig__clinit_();
        maat_TMI__clinit_();
        nms_TileEntity__clinit_();
        maat_TMIView__clinit_();
        maat_TMIUtils__clinit_();
        maat_TMIPotionPanel__clinit_();
        maat_TMIFireworkPanel__clinit_();
        maat_TMIImages__clinit_();
        nms_BiomeGenBase__clinit_();
        maa_Color__clinit_();
        nms_EnumEntitySize__clinit_();
        nms_GuiButton__clinit_();
        nle_License__clinit_();
        nms_EnumChatFormatting__clinit_();
        nleg_EffectPipelineFXAA__clinit_();
        nms_ActiveRenderInfo__clinit_();
        nms_ClippingHelperImpl__clinit_();
        nms_StringUtils__clinit_();
        nle_EnumBrowser__clinit_();
        nms_Direction__clinit_();
        maat_TMIItemPanel__clinit_();
        maat_TMIFavoritesPanel__clinit_();
        nms_Facing__clinit_();
        nms_Packet51MapChunk__clinit_();
        nms_Packet52MultiBlockChange__clinit_();
        nms_Packet56MapChunks__clinit_();
        nms_Packet70GameEvent__clinit_();
        nms_IEntitySelector__clinit_();
        nms_TileEntityFurnace__clinit_();
        nms_TileEntityBrewingStand__clinit_();
        nms_EnchantmentProtection__clinit_();
        nms_EnumEnchantmentType__clinit_();
        nms_EnchantmentDamage__clinit_();
        jn_URL__clinit_();
        nms_Score__clinit_();
        nms_TextureClock__clinit_();
        jn_URLConnection__clinit_();
        jn_HttpURLConnection__clinit_();
        nms_GuiButtonLanguage__clinit_();
        nms_TileEntitySignRenderer__clinit_();
        nms_TileEntityRendererPiston__clinit_();
        nms_TileEntityChestRenderer__clinit_();
        nms_TileEntityEnderChestRenderer__clinit_();
        nms_RenderEnchantmentTable__clinit_();
        nms_RenderEndPortal__clinit_();
        nms_TileEntityBeaconRenderer__clinit_();
        nms_TileEntitySkullRenderer__clinit_();
        nms_EnumAction__clinit_();
        nms_GuiRepair__clinit_();
        nms_EnumRarity__clinit_();
        nms_ChatClickData__clinit_();
        maat_TMICompatibility__clinit_();
        nms_ChestItemRenderHelper__clinit_();
        nms_EnumGameType__clinit_();
        nms_GuiSlot__clinit_();
        nms_GuiSlotServer__clinit_();
        maa_MidiConverter__clinit_();
        nms_DamageSource__clinit_();
        nlea_EaglerAdapterImpl2$RateLimit__clinit_();
        maan_Instrument__clinit_();
        cjj_JZlib$WrapperType__clinit_();
        nms_EnumSkyBlock__clinit_();
        nms_EnumStatus__clinit_();
        nms_EnumCreatureAttribute__clinit_();
        jt_AttributedCharacterIterator$Attribute__clinit_();
        nms_EnumFacing__clinit_();
        nms_WorldType__clinit_();
        nms_ScoreObjectiveCriteria__clinit_();
        maa_PubKey__clinit_();
        otcf_VirtualFileSystemProvider__clinit_();
        ji_File__clinit_();
        jss_AudioFormat$Encoding__clinit_();
        jss_AudioFileFormat$Type__clinit_();
        jsm_Sequencer$SyncMode__clinit_();
        otjc_JSRegExpFlag__clinit_();
        jus_Collector$Characteristics__clinit_();
        jss_LineEvent$Type__clinit_();
        nms_EnumArt__clinit_();
        nms_PacketCount__clinit_();
        maa_CryptManager__clinit_();
        nms_GuiMerchant__clinit_();
        nms_GuiWinGame__clinit_();
        ju_Vector__clinit_();
        jt_MessageFormat$Field__clinit_();
        nms_GuiChest__clinit_();
        nms_GuiCrafting__clinit_();
        nms_GuiBeacon__clinit_();
        nms_GuiDispenser__clinit_();
        nms_GuiHopper__clinit_();
        nms_GuiBrewingStand__clinit_();
        nms_GuiEnchantment__clinit_();
        nms_GuiFurnace__clinit_();
        nms_FurnaceRecipes__clinit_();
        nms_EntityFootStepFX__clinit_();
        nms_EntityLargeExplodeFX__clinit_();
        nms_GuiBeaconButton__clinit_();
        nms_GuiButtonMerchant__clinit_();
        nms_GuiScreenBook__clinit_();
        nms_GuiButtonNextPage__clinit_();
        nle_Client_registerErrorHandler$js_body$_5();
        $args = otji_JS_unwrapStringArray(window.minecraftOpts).data;
        var$2 = window.document;
        var$3 = $args[0];
        var$3 = var$2.getElementById($rt_ustr(var$3));
        nle_Client_rootElement = var$3;
        var$2 = $args[1];
        $ptr = 1;
    case 1:
        nlea_EaglerAdapterImpl2_initializeContext(var$3, var$2);
        if ($rt_suspending()) {
            break main;
        }
        nle_LocalStorageManager_loadStorage();
        var$4 = $args.length;
        if (var$4 > 2 && jl_String_length($args[2]) > 0)
            nms_ServerList_loadDefaultServers($args[2]);
        if (var$4 > 3)
            nlea_EaglerAdapterImpl2_setServerToJoinOnLaunch($args[3]);
        $ptr = 2;
    case 2:
        nle_Client_run0();
        if ($rt_suspending()) {
            break main;
        }
        return;
    default: $rt_invalidPointer();
    }}
    $rt_nativeThread().push($args, var$2, var$3, var$4, $ptr);
}
function nle_Client_run0() {
    var var$1, $ptr, $tmp;
    $ptr = 0;
    if ($rt_resuming()) {
        var $thread = $rt_nativeThread();
        $ptr = $thread.pop();var$1 = $thread.pop();
    }
    main: while (true) { switch ($ptr) {
    case 0:
        ji_PrintStream_println(jl_System_out(), $rt_s(2));
        nle_Client_instance = nmc_Minecraft__init_();
        var$1 = nle_Client_instance;
        $ptr = 1;
    case 1:
        nmc_Minecraft_run(var$1);
        if ($rt_suspending()) {
            break main;
        }
        return;
    default: $rt_invalidPointer();
    }}
    $rt_nativeThread().push(var$1, $ptr);
}
function nle_Client_showCrashScreen($t) {
    var $str, $doc, $s, var$5, $img, $div;
    if (!nle_Client_isCrashed) {
        nle_Client_isCrashed = 1;
        nlea_EaglerAdapterImpl2_$callClinit();
        $str = nlea_EaglerAdapterImpl2_win;
        $doc = nlea_EaglerAdapterImpl2_contextmenu;
        $str.removeEventListener("contextmenu", otji_JS_function($doc, "handleEvent"));
        $str = nlea_EaglerAdapterImpl2_win;
        $doc = nlea_EaglerAdapterImpl2_mousedown;
        $str.removeEventListener("mousedown", otji_JS_function($doc, "handleEvent"));
        $str = nlea_EaglerAdapterImpl2_win;
        $doc = nlea_EaglerAdapterImpl2_mouseup;
        $str.removeEventListener("mouseup", otji_JS_function($doc, "handleEvent"));
        $str = nlea_EaglerAdapterImpl2_win;
        $doc = nlea_EaglerAdapterImpl2_mousemove;
        $str.removeEventListener("mousemove", otji_JS_function($doc, "handleEvent"));
        $str = nlea_EaglerAdapterImpl2_win;
        $doc = nlea_EaglerAdapterImpl2_keydown;
        $str.removeEventListener("keydown", otji_JS_function($doc, "handleEvent"));
        $str = nlea_EaglerAdapterImpl2_win;
        $doc = nlea_EaglerAdapterImpl2_keyup;
        $str.removeEventListener("keyup", otji_JS_function($doc, "handleEvent"));
        $str = nlea_EaglerAdapterImpl2_win;
        $doc = nlea_EaglerAdapterImpl2_keypress;
        $str.removeEventListener("keypress", otji_JS_function($doc, "handleEvent"));
        $str = nlea_EaglerAdapterImpl2_win;
        $doc = nlea_EaglerAdapterImpl2_wheel;
        $str.removeEventListener("wheel", otji_JS_function($doc, "handleEvent"));
        $str = new jl_StringBuilder;
        jl_AbstractStringBuilder__init_($str);
        jl_AbstractStringBuilder_append($str, $rt_s(3));
        jl_AbstractStringBuilder_append($str, $t);
        jl_AbstractStringBuilder_append0($str, 10);
        jl_AbstractStringBuilder_append0($str, 10);
        jl_AbstractStringBuilder_append($str, $rt_s(4));
        jl_AbstractStringBuilder_append($str, $rt_s(5));
        jl_AbstractStringBuilder_append($str, $rt_s(6));
        jl_AbstractStringBuilder_append($str, $rt_s(7));
        jl_AbstractStringBuilder_append($str, $rt_s(8));
        jl_AbstractStringBuilder_append($str, $rt_s(9));
        nle_EaglerProfile_$callClinit();
        jl_AbstractStringBuilder_append($str, nle_EaglerProfile_username);
        jl_AbstractStringBuilder_append($str, $rt_s(6));
        jl_StringBuilder_append(jl_StringBuilder_append(jl_StringBuilder_append($str, $rt_s(10)), nle_EaglerProfile_myChannel), $rt_s(6));
        jl_StringBuilder_append0($str, 10);
        nle_Client_addArray($str, $rt_s(11));
        jl_StringBuilder_append0($str, 10);
        nle_Client_addDebug($str, $rt_s(12));
        nle_Client_addDebug($str, $rt_s(13));
        nle_Client_addDebug($str, $rt_s(14));
        nle_Client_addDebug($str, $rt_s(15));
        nle_Client_addDebug($str, $rt_s(16));
        nle_Client_addDebug($str, $rt_s(17));
        nle_Client_addDebug($str, $rt_s(18));
        jl_StringBuilder_append0($str, 10);
        jl_StringBuilder_append0(jl_StringBuilder_append1(jl_StringBuilder_append($str, $rt_s(19)), nle_Client_rootElement.clientWidth), 10);
        jl_StringBuilder_append0(jl_StringBuilder_append1(jl_StringBuilder_append($str, $rt_s(20)), nle_Client_rootElement.clientHeight), 10);
        nle_Client_addDebug($str, $rt_s(21));
        nle_Client_addDebug($str, $rt_s(22));
        nle_Client_addDebug($str, $rt_s(23));
        nle_Client_addDebug($str, $rt_s(24));
        nle_Client_addDebug($str, $rt_s(25));
        nle_Client_addDebug($str, $rt_s(26));
        nle_Client_addDebug($str, $rt_s(27));
        nle_Client_addDebug($str, $rt_s(28));
        nle_Client_addDebug($str, $rt_s(29));
        jl_StringBuilder_append0($str, 10);
        nle_Client_addDebug($str, $rt_s(30));
        jl_StringBuilder_append0($str, 10);
        nle_Client_addDebug($str, $rt_s(31));
        nle_Client_addArray($str, $rt_s(32));
        jl_StringBuilder_append($str, $rt_s(33));
        jl_StringBuilder_append($str, nle_LocalStorageManager_dumpConfiguration());
        jl_StringBuilder_append($str, $rt_s(34));
        nle_Client_addDebug($str, $rt_s(35));
        $s = $rt_str(nle_Client_rootElement.getAttribute("style"));
        var$5 = nle_Client_rootElement;
        $t = jl_StringBuilder__init_();
        if ($s === null)
            $s = $rt_s(36);
        $t = jl_StringBuilder_toString(jl_StringBuilder_append(jl_StringBuilder_append($t, $s), $rt_s(37)));
        var$5.setAttribute("style", $rt_ustr($t));
        $doc = window.document;
        $img = $doc.createElement("img");
        $div = $doc.createElement("div");
        $img.setAttribute("style", "z-index:100;position:absolute;top:10px;left:calc(50% - 151px);");
        $img.setAttribute("src", "data:image/png;base64,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");
        $div.setAttribute("style", "z-index:100;position:absolute;top:135px;left:10%;right:10%;bottom:30px;background-color:white;border:1px solid #cccccc;overflow-x:hidden;overflow-y:scroll;overflow-wrap:break-word;white-space:pre-wrap;font: 14px monospace;padding:10px;");
        nle_Client_rootElement.appendChild($img);
        nle_Client_rootElement.appendChild($div);
        $t = jl_StringBuilder_toString($str);
        $t = $doc.createTextNode($rt_ustr($t));
        $div.appendChild($t);
    }
}
function nle_Client_addDebug($str, $var) {
    jl_AbstractStringBuilder_append($str, $var);
    jl_AbstractStringBuilder_append($str, $rt_s(38));
    jl_AbstractStringBuilder_append($str, $rt_str(nle_Client_getString$js_body$_10($rt_ustr($var))));
    jl_AbstractStringBuilder_append0($str, 10);
}
function nle_Client_addArray($str, $var) {
    jl_AbstractStringBuilder_append($str, $var);
    jl_AbstractStringBuilder_append($str, $rt_s(38));
    jl_AbstractStringBuilder_append($str, $rt_str(nle_Client_getArray$js_body$_13($rt_ustr($var))));
    jl_AbstractStringBuilder_append0($str, 10);
}
function nle_Client__clinit_() {
    nle_Client_rootElement = null;
    nle_Client_instance = null;
    nle_Client_isCrashed = 0;
}
function nle_Client_registerErrorHandler$js_body$_5() {
    window.minecraftError = null;
    window.onerror = function(message, file, line, column, errorObj) {
        if (errorObj) {
            window.minecraftError = errorObj;
            window.minecraftErrorL = "" + line + ":" + column;
            nle_Client_handleNativeError$jsocb$_0();
        } else {
            alert("a native browser exception was thrown but your browser does not support fith argument in onerror");
        }
    };
}
function nle_Client_handleNativeError$jsocb$_0() {
    var var$1, var$2;
    var$1 = window.minecraftError;
    var$2 = new jl_StringBuilder;
    jl_AbstractStringBuilder__init_(var$2);
    jl_AbstractStringBuilder_append(var$2, $rt_s(39));
    jl_AbstractStringBuilder_append(var$2, $rt_s(40));
    jl_AbstractStringBuilder_append(var$2, $rt_s(41));
    jl_AbstractStringBuilder_append(var$2, $rt_str(window.minecraftErrorL));
    jl_AbstractStringBuilder_append0(var$2, 10);
    jl_AbstractStringBuilder_append(var$2, $rt_s(42));
    jl_AbstractStringBuilder_append(var$2, $rt_str(var$1.name));
    jl_AbstractStringBuilder_append0(var$2, 10);
    jl_AbstractStringBuilder_append(var$2, $rt_s(43));
    jl_AbstractStringBuilder_append(var$2, $rt_str(var$1.message));
    jl_AbstractStringBuilder_append0(var$2, 10);
    jl_AbstractStringBuilder_append(var$2, $rt_s(44));
    jl_AbstractStringBuilder_append(var$2, $rt_str(var$1.stack));
    jl_AbstractStringBuilder_append0(var$2, 10);
    nle_Client_showCrashScreen(jl_AbstractStringBuilder_toString(var$2));
}
function nle_Client_getString$js_body$_10(var$1) {
    try {
        return "" + window.eval(var$1);
    } catch (e){
        return "<error>";
    }
}
function nle_Client_getArray$js_body$_13(var$1) {
    try {
        return JSON.stringify(window.eval(var$1));
    } catch (e){
        return "[\"<error>\"]";
    }
}
function jlr_AnnotatedElement() {
}
function jlr_AnnotatedElement_isAnnotationPresent($this, $annotationClass) {
    return 0;
}
function jl_Class() {
    var a = this; jl_Object.call(a);
    a.$name = null;
    a.$simpleName = null;
    a.$platformClass = null;
    a.$declaredMethods = null;
}
var jl_Class_reflectionInitialized = 0;
function jl_Class_getClass($cls) {
    var $result, var$3;
    if ($cls === null)
        return null;
    $result = $cls.classObject;
    if ($result === null) {
        $result = new jl_Class;
        $result.$platformClass = $cls;
        var$3 = $result;
        $cls.classObject = var$3;
    }
    return $result;
}
function jl_Class_getPlatformClass($this) {
    return $this.$platformClass;
}
function jl_Class_isInstance($this, $obj) {
    var var$2;
    $obj = $obj;
    var$2 = $this.$platformClass;
    return $obj !== null && !(typeof $obj.constructor.$meta === 'undefined' ? 1 : 0) && otp_Platform_isAssignable($obj.constructor, var$2) ? 1 : 0;
}
function jl_Class_isAssignableFrom($this, $obj) {
    return otp_Platform_isAssignable($obj.$platformClass, $this.$platformClass);
}
function jl_Class_getName($this) {
    if ($this.$name === null)
        $this.$name = otp_Platform_getName($this.$platformClass);
    return $this.$name;
}
function jl_Class_getSimpleName($this) {
    var $simpleName, $lastDollar, $lastDot;
    $simpleName = $this.$simpleName;
    if ($simpleName === null) {
        if (jl_Class_isArray($this)) {
            $simpleName = new jl_StringBuilder;
            jl_AbstractStringBuilder__init_($simpleName);
            jl_AbstractStringBuilder_append($simpleName, jl_Class_getSimpleName(jl_Class_getComponentType($this)));
            jl_AbstractStringBuilder_append($simpleName, $rt_s(45));
            $simpleName = jl_AbstractStringBuilder_toString($simpleName);
            $this.$simpleName = $simpleName;
            return $simpleName;
        }
        $simpleName = otp_Platform_getName($this.$platformClass);
        $lastDollar = jl_String_lastIndexOf($simpleName, 36);
        if ($lastDollar == (-1)) {
            $lastDot = jl_String_lastIndexOf($simpleName, 46);
            if ($lastDot != (-1))
                $simpleName = jl_String_substring($simpleName, $lastDot + 1 | 0);
        } else {
            $simpleName = jl_String_substring($simpleName, $lastDollar + 1 | 0);
            if (jl_String_charAt($simpleName, 0) >= 48 && jl_String_charAt($simpleName, 0) <= 57)
                $simpleName = $rt_s(36);
        }
        $this.$simpleName = $simpleName;
    }
    return $simpleName;
}
function jl_Class_isPrimitive($this) {
    return $this.$platformClass.$meta.primitive ? 1 : 0;
}
function jl_Class_isArray($this) {
    return otp_Platform_getArrayItem($this.$platformClass) === null ? 0 : 1;
}
function jl_Class_isInterface($this) {
    return !($this.$platformClass.$meta.flags & 2) ? 0 : 1;
}
function jl_Class_getComponentType($this) {
    return jl_Class_getClass(otp_Platform_getArrayItem($this.$platformClass));
}
function jl_Class_createMetadata() {
    jl_String.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_charcls())],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_charcls()), $rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls()), $rt_intcls(), $rt_intcls(), jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls()), $rt_intcls(), $rt_intcls(), jnc_Charset],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls()), $rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls())],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls()), jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls()), jnc_Charset],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_intcls()), $rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "initWithBytes",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [$rt_arraycls($rt_bytecls()), $rt_intcls(), $rt_intcls(), jnc_Charset],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_StringBuilder],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "charAt",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_charcls(),
            callable : null
        }, {
            name : "codePointAt",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "codePointBefore",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "codePointCount",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "offsetByCodePoints",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "length",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "isEmpty",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "getChars",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls(), $rt_arraycls($rt_charcls()), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "contentEquals",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_StringBuffer],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "contentEquals",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_CharSequence],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "compareTo",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "compareToIgnoreCase",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "startsWith",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String, $rt_intcls()],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "startsWith",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "regionMatches",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_booleancls(), $rt_intcls(), jl_String, $rt_intcls(), $rt_intcls()],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "regionMatches",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_String, $rt_intcls(), $rt_intcls()],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "endsWith",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "indexOf",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "indexOf",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "lastIndexOf",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "lastIndexOf",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "indexOf",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String, $rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "indexOf",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "lastIndexOf",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String, $rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "lastIndexOf",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "substring",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : jl_String,
            callable : null
        }, {
            name : "substring",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : jl_String,
            callable : null
        }, {
            name : "subSequence",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : jl_CharSequence,
            callable : null
        }, {
            name : "concat",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : jl_String,
            callable : null
        }, {
            name : "replace",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_charcls(), $rt_charcls()],
            returnType : jl_String,
            callable : null
        }, {
            name : "contains",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_CharSequence],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "replace",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_CharSequence, jl_CharSequence],
            returnType : jl_String,
            callable : null
        }, {
            name : "trim",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "toString",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "toCharArray",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_arraycls($rt_charcls()),
            callable : null
        }, {
            name : "valueOf",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : jl_String,
            callable : null
        }, {
            name : "valueOf",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_charcls())],
            returnType : jl_String,
            callable : null
        }, {
            name : "valueOf",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_charcls()), $rt_intcls(), $rt_intcls()],
            returnType : jl_String,
            callable : null
        }, {
            name : "copyValueOf",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_charcls())],
            returnType : jl_String,
            callable : null
        }, {
            name : "copyValueOf",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_charcls()), $rt_intcls(), $rt_intcls()],
            returnType : jl_String,
            callable : null
        }, {
            name : "valueOf",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_booleancls()],
            returnType : jl_String,
            callable : null
        }, {
            name : "valueOf",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_charcls()],
            returnType : jl_String,
            callable : null
        }, {
            name : "valueOf",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : jl_String,
            callable : null
        }, {
            name : "valueOf",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_longcls()],
            returnType : jl_String,
            callable : null
        }, {
            name : "valueOf",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_floatcls()],
            returnType : jl_String,
            callable : null
        }, {
            name : "valueOf",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_doublecls()],
            returnType : jl_String,
            callable : null
        }, {
            name : "equals",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "equalsIgnoreCase",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "getBytes",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_arraycls($rt_bytecls()),
            callable : null
        }, {
            name : "getBytes",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_arraycls($rt_bytecls()),
            callable : null
        }, {
            name : "getBytes",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jnc_Charset],
            returnType : $rt_arraycls($rt_bytecls()),
            callable : null
        }, {
            name : "hashCode",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "toLowerCase",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "toLowerCase",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [ju_Locale],
            returnType : jl_String,
            callable : null
        }, {
            name : "toUpperCase",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "toUpperCase",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [ju_Locale],
            returnType : jl_String,
            callable : null
        }, {
            name : "intern",
            modifiers : 256,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "matches",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "split",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_arraycls(jl_String),
            callable : null
        }, {
            name : "split",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String, $rt_intcls()],
            returnType : $rt_arraycls(jl_String),
            callable : null
        }, {
            name : "replaceAll",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String, jl_String],
            returnType : jl_String,
            callable : null
        }, {
            name : "replaceFirst",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String, jl_String],
            returnType : jl_String,
            callable : null
        }, {
            name : "format",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [jl_String, $rt_arraycls(jl_Object)],
            returnType : jl_String,
            callable : null
        }, {
            name : "format",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [ju_Locale, jl_String, $rt_arraycls(jl_Object)],
            returnType : jl_String,
            callable : null
        }, {
            name : "join",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [jl_CharSequence, $rt_arraycls(jl_CharSequence)],
            returnType : jl_String,
            callable : null
        }, {
            name : "join",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [jl_CharSequence, jl_Iterable],
            returnType : jl_String,
            callable : null
        }, {
            name : "compareTo",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "lambda$static$0",
            modifiers : 544,
            accessLevel : 1,
            parameterTypes : [jl_String, jl_String],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "<clinit>",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }];
    jl_Object.$meta.methods = [
        {
            name : "monitorEnterSync",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [jl_Object],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "monitorExitSync",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [jl_Object],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "monitorEnter",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [jl_Object],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "monitorEnter",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [jl_Object, $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "createMonitor",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [jl_Object],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "monitorEnterWait",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [jl_Object, $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "monitorEnterWait",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [jl_Object, $rt_intcls(), oti_AsyncCallback],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "monitorExit",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [jl_Object],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "monitorExit",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [jl_Object, $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "waitForOtherThreads",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [jl_Object],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "isEmptyMonitor",
            modifiers : 4,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "deleteMonitor",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "holdsLock",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [jl_Object],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "fakeInit",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getClass",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_Class,
            callable : null
        }, {
            name : "hashCode",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "equals",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "toString",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "identity",
            modifiers : 4,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "hashCodeLowLevel",
            modifiers : 768,
            accessLevel : 1,
            parameterTypes : [jl_Object],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "hashCodeLowLevelImpl",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [otr_RuntimeObject],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "setHashCodeLowLevel",
            modifiers : 768,
            accessLevel : 1,
            parameterTypes : [jl_Object, $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "setHashCodeLowLevelImpl",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [otr_RuntimeObject, $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "identityLowLevel",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "identityOrMonitor",
            modifiers : 256,
            accessLevel : 1,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "identityOrMonitorLowLevel",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [otr_RuntimeObject],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "setIdentity",
            modifiers : 256,
            accessLevel : 0,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "setIdentityLowLevel",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [otr_RuntimeObject, $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "clone",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [],
            returnType : jl_Object,
            callable : null
        }, {
            name : "cloneLowLevel",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [otr_RuntimeObject],
            returnType : otr_RuntimeObject,
            callable : null
        }, {
            name : "notify",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "notifyAll",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "wait",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [$rt_longcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "wait",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [$rt_longcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "waitImpl",
            modifiers : 256,
            accessLevel : 1,
            parameterTypes : [$rt_longcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "waitImpl",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [$rt_longcls(), $rt_intcls(), oti_AsyncCallback],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "wait",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "finalize",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "lambda$monitorExit$2",
            modifiers : 544,
            accessLevel : 1,
            parameterTypes : [jl_Object],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "lambda$monitorExit$1",
            modifiers : 544,
            accessLevel : 1,
            parameterTypes : [jl_Object],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "lambda$monitorEnterWait$0",
            modifiers : 544,
            accessLevel : 1,
            parameterTypes : [jl_Thread, jl_Object, $rt_intcls(), oti_AsyncCallback],
            returnType : $rt_voidcls(),
            callable : null
        }];
    ji_Serializable.$meta.methods = [];
    jl_Comparable.$meta.methods = [
        {
            name : "compareTo",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_intcls(),
            callable : null
        }];
    jl_CharSequence.$meta.methods = [
        {
            name : "length",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "charAt",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_charcls(),
            callable : null
        }, {
            name : "subSequence",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : jl_CharSequence,
            callable : null
        }, {
            name : "toString",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }];
    otj_JSObject.$meta.methods = [
        {
            name : "cast",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "cast$static",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }];
    jl_Class.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [otp_PlatformClass],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getClass",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [otp_PlatformClass],
            returnType : jl_Class,
            callable : null
        }, {
            name : "getPlatformClass",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : otp_PlatformClass,
            callable : null
        }, {
            name : "isInstance",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "isInstanceLowLevel",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [otr_RuntimeObject],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "isAssignableFrom",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Class],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "isAssignableFromLowLevel",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [otr_RuntimeClass],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "getName",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "getSimpleName",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "getSimpleNameCache",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "getSimpleNameCacheLowLevel",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [],
            returnType : otr_RuntimeObject,
            callable : null
        }, {
            name : "setSimpleNameCache",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "setSimpleNameCacheLowLevel",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [otr_RuntimeObject],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "isPrimitive",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "isArray",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "isEnum",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "isInterface",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "getComponentType",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_Class,
            callable : null
        }, {
            name : "getDeclaredFields",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_arraycls(jlr_Field),
            callable : null
        }, {
            name : "initReflection",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "createMetadata",
            modifiers : 768,
            accessLevel : 1,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getFields",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_arraycls(jlr_Field),
            callable : null
        }, {
            name : "getDeclaredField",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : jlr_Field,
            callable : null
        }, {
            name : "getField",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : jlr_Field,
            callable : null
        }, {
            name : "findField",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [jl_String, ju_Set],
            returnType : jlr_Field,
            callable : null
        }, {
            name : "newEmptyInstance",
            modifiers : 256,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_Object,
            callable : null
        }, {
            name : "getDeclaredConstructors",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_arraycls(jlr_Constructor),
            callable : null
        }, {
            name : "getConstructors",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_arraycls(jlr_Constructor),
            callable : null
        }, {
            name : "getDeclaredConstructor",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls(jl_Class)],
            returnType : jlr_Constructor,
            callable : null
        }, {
            name : "getConstructor",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls(jl_Class)],
            returnType : jlr_Constructor,
            callable : null
        }, {
            name : "getFieldsOfInterfaces",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [jl_Class, ju_List, ju_Set],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getDeclaredMethods",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_arraycls(jlr_Method),
            callable : null
        }, {
            name : "getDeclaredMethod",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String, $rt_arraycls(jl_Class)],
            returnType : jlr_Method,
            callable : null
        }, {
            name : "getMethods",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_arraycls(jlr_Method),
            callable : null
        }, {
            name : "getMethod",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String, $rt_arraycls(jl_Class)],
            returnType : jlr_Method,
            callable : null
        }, {
            name : "findMethods",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [jl_Class, ju_Map],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "findMethod",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [jl_Class, jlr_Method, jl_String, $rt_arraycls(jl_Class)],
            returnType : jlr_Method,
            callable : null
        }, {
            name : "getModifiers",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "desiredAssertionStatus",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "getSuperclass",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_Class,
            callable : null
        }, {
            name : "getInterfaces",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_arraycls(jl_Class),
            callable : null
        }, {
            name : "getEnumConstants",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_arraycls(jl_Object),
            callable : null
        }, {
            name : "cast",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : jl_Object,
            callable : null
        }, {
            name : "getClassLoader",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_ClassLoader,
            callable : null
        }, {
            name : "forName",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : jl_Class,
            callable : null
        }, {
            name : "forName",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [jl_String, $rt_booleancls(), jl_ClassLoader],
            returnType : jl_Class,
            callable : null
        }, {
            name : "initialize",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "newInstance",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_Object,
            callable : null
        }, {
            name : "getDeclaringClass",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_Class,
            callable : null
        }, {
            name : "getDeclaringClassImpl",
            modifiers : 768,
            accessLevel : 1,
            parameterTypes : [otp_PlatformClass],
            returnType : otp_PlatformClass,
            callable : null
        }, {
            name : "asSubclass",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Class],
            returnType : jl_Class,
            callable : null
        }, {
            name : "isAnnotationPresent",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Class],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "getAnnotation",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Class],
            returnType : jla_Annotation,
            callable : null
        }, {
            name : "getAnnotations",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_arraycls(jla_Annotation),
            callable : null
        }, {
            name : "getDeclaredAnnotations",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_arraycls(jla_Annotation),
            callable : null
        }, {
            name : "ensureAnnotationsByType",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getResourceAsStream",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : ji_InputStream,
            callable : null
        }, {
            name : "getPackage",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_Package,
            callable : null
        }];
    jlr_AnnotatedElement.$meta.methods = [
        {
            name : "isAnnotationPresent",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Class],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "getAnnotation",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [jl_Class],
            returnType : jla_Annotation,
            callable : null
        }, {
            name : "getAnnotations",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_arraycls(jla_Annotation),
            callable : null
        }, {
            name : "getDeclaredAnnotations",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_arraycls(jla_Annotation),
            callable : null
        }, {
            name : "getAnnotationsByType",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Class],
            returnType : $rt_arraycls(jla_Annotation),
            callable : null
        }, {
            name : "getDeclaredAnnotation",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Class],
            returnType : jla_Annotation,
            callable : null
        }, {
            name : "getDeclaredAnnotationsByType",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Class],
            returnType : $rt_arraycls(jla_Annotation),
            callable : null
        }];
    jl_NoClassDefFoundError.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }];
    jl_LinkageError.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String, jl_Throwable],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }];
    jl_Error.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String, jl_Throwable],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Throwable],
            returnType : $rt_voidcls(),
            callable : null
        }];
    jl_Throwable.$meta.methods = [
        {
            name : "fakeInit",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [jl_String, jl_Throwable, $rt_booleancls(), $rt_booleancls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String, jl_Throwable, $rt_booleancls(), $rt_booleancls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "fakeInit",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "fakeInit",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "fakeInit",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String, jl_Throwable],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [jl_String, jl_Throwable],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "fakeInit",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Throwable],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [jl_Throwable],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "fillInStackTrace",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_Throwable,
            callable : null
        }, {
            name : "getMessage",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "getLocalizedMessage",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "getCause",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_Throwable,
            callable : null
        }, {
            name : "toString",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "initCause",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Throwable],
            returnType : jl_Throwable,
            callable : null
        }, {
            name : "printStackTrace",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "printStackTrace",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [ji_PrintStream],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "printStackTrace",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [ji_PrintWriter],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getStackTrace",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_arraycls(jl_StackTraceElement),
            callable : null
        }, {
            name : "setStackTrace",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls(jl_StackTraceElement)],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getSuppressed",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_arraycls(jl_Throwable),
            callable : null
        }, {
            name : "addSuppressed",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [jl_Throwable],
            returnType : $rt_voidcls(),
            callable : null
        }];
    jl_NoSuchFieldError.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }];
    jl_IncompatibleClassChangeError.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }];
    jl_NoSuchMethodError.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }];
    jl_RuntimeException.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String, jl_Throwable],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Throwable],
            returnType : $rt_voidcls(),
            callable : null
        }];
    jl_Exception.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String, jl_Throwable],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Throwable],
            returnType : $rt_voidcls(),
            callable : null
        }];
    jl_StringBuilder.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_CharSequence],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "append",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : jl_StringBuilder,
            callable : null
        }, {
            name : "append",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : jl_StringBuilder,
            callable : null
        }, {
            name : "append",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_longcls()],
            returnType : jl_StringBuilder,
            callable : null
        }, {
            name : "append",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_floatcls()],
            returnType : jl_StringBuilder,
            callable : null
        }, {
            name : "append",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_doublecls()],
            returnType : jl_StringBuilder,
            callable : null
        }, {
            name : "append",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_charcls()],
            returnType : jl_StringBuilder,
            callable : null
        }, {
            name : "append",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_charcls()), $rt_intcls(), $rt_intcls()],
            returnType : jl_StringBuilder,
            callable : null
        }, {
            name : "append",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_charcls())],
            returnType : jl_StringBuilder,
            callable : null
        }, {
            name : "appendCodePoint",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : jl_StringBuilder,
            callable : null
        }, {
            name : "append",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_CharSequence, $rt_intcls(), $rt_intcls()],
            returnType : jl_StringBuilder,
            callable : null
        }, {
            name : "append",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_CharSequence],
            returnType : jl_StringBuilder,
            callable : null
        }, {
            name : "append",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_StringBuffer],
            returnType : jl_StringBuilder,
            callable : null
        }, {
            name : "append",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : jl_StringBuilder,
            callable : null
        }, {
            name : "append",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_booleancls()],
            returnType : jl_StringBuilder,
            callable : null
        }, {
            name : "insert",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_longcls()],
            returnType : jl_StringBuilder,
            callable : null
        }, {
            name : "insert",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_floatcls()],
            returnType : jl_StringBuilder,
            callable : null
        }, {
            name : "insert",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_doublecls()],
            returnType : jl_StringBuilder,
            callable : null
        }, {
            name : "insert",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_CharSequence, $rt_intcls(), $rt_intcls()],
            returnType : jl_StringBuilder,
            callable : null
        }, {
            name : "insert",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_CharSequence],
            returnType : jl_StringBuilder,
            callable : null
        }, {
            name : "insert",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : jl_StringBuilder,
            callable : null
        }, {
            name : "insert",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_arraycls($rt_charcls()), $rt_intcls(), $rt_intcls()],
            returnType : jl_StringBuilder,
            callable : null
        }, {
            name : "insert",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_Object],
            returnType : jl_StringBuilder,
            callable : null
        }, {
            name : "insert",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_arraycls($rt_charcls())],
            returnType : jl_StringBuilder,
            callable : null
        }, {
            name : "insert",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_booleancls()],
            returnType : jl_StringBuilder,
            callable : null
        }, {
            name : "insert",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_charcls()],
            returnType : jl_StringBuilder,
            callable : null
        }, {
            name : "delete",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : jl_StringBuilder,
            callable : null
        }, {
            name : "replace",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls(), jl_String],
            returnType : jl_StringBuilder,
            callable : null
        }, {
            name : "deleteCharAt",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : jl_StringBuilder,
            callable : null
        }, {
            name : "insert",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_String],
            returnType : jl_StringBuilder,
            callable : null
        }, {
            name : "reverse",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_StringBuilder,
            callable : null
        }, {
            name : "codePointBefore",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "codePointAt",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "codePointCount",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "offsetByCodePoints",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "setCharAt",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_charcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "substring",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : jl_String,
            callable : null
        }, {
            name : "substring",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : jl_String,
            callable : null
        }, {
            name : "reverse",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_AbstractStringBuilder,
            callable : null
        }, {
            name : "lastIndexOf",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [jl_String, $rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "lastIndexOf",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "indexOf",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [jl_String, $rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "indexOf",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "replace",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls(), jl_String],
            returnType : jl_AbstractStringBuilder,
            callable : null
        }, {
            name : "delete",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : jl_AbstractStringBuilder,
            callable : null
        }, {
            name : "deleteCharAt",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : jl_AbstractStringBuilder,
            callable : null
        }, {
            name : "setLength",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getChars",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls(), $rt_arraycls($rt_charcls()), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "subSequence",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : jl_CharSequence,
            callable : null
        }, {
            name : "append",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_charcls())],
            returnType : jl_AbstractStringBuilder,
            callable : null
        }, {
            name : "insert",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_arraycls($rt_charcls()), $rt_intcls(), $rt_intcls()],
            returnType : jl_AbstractStringBuilder,
            callable : null
        }, {
            name : "insert",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_arraycls($rt_charcls())],
            returnType : jl_AbstractStringBuilder,
            callable : null
        }, {
            name : "append",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_charcls()), $rt_intcls(), $rt_intcls()],
            returnType : jl_AbstractStringBuilder,
            callable : null
        }, {
            name : "insert",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_CharSequence],
            returnType : jl_AbstractStringBuilder,
            callable : null
        }, {
            name : "append",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [jl_StringBuffer],
            returnType : jl_AbstractStringBuilder,
            callable : null
        }, {
            name : "append",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [jl_CharSequence],
            returnType : jl_AbstractStringBuilder,
            callable : null
        }, {
            name : "insert",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_CharSequence, $rt_intcls(), $rt_intcls()],
            returnType : jl_AbstractStringBuilder,
            callable : null
        }, {
            name : "append",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [jl_CharSequence, $rt_intcls(), $rt_intcls()],
            returnType : jl_AbstractStringBuilder,
            callable : null
        }, {
            name : "charAt",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_charcls(),
            callable : null
        }, {
            name : "length",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "toString",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "capacity",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "trimToSize",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "ensureCapacity",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "insert",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_booleancls()],
            returnType : jl_AbstractStringBuilder,
            callable : null
        }, {
            name : "append",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [$rt_booleancls()],
            returnType : jl_AbstractStringBuilder,
            callable : null
        }, {
            name : "insert",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_Object],
            returnType : jl_AbstractStringBuilder,
            callable : null
        }, {
            name : "append",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : jl_AbstractStringBuilder,
            callable : null
        }, {
            name : "appendCodePoint",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : jl_AbstractStringBuilder,
            callable : null
        }, {
            name : "insert",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_charcls()],
            returnType : jl_AbstractStringBuilder,
            callable : null
        }, {
            name : "append",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [$rt_charcls()],
            returnType : jl_AbstractStringBuilder,
            callable : null
        }, {
            name : "insert",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_doublecls()],
            returnType : jl_AbstractStringBuilder,
            callable : null
        }, {
            name : "append",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [$rt_doublecls()],
            returnType : jl_AbstractStringBuilder,
            callable : null
        }, {
            name : "insert",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_floatcls()],
            returnType : jl_AbstractStringBuilder,
            callable : null
        }, {
            name : "append",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [$rt_floatcls()],
            returnType : jl_AbstractStringBuilder,
            callable : null
        }, {
            name : "insert",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_longcls()],
            returnType : jl_AbstractStringBuilder,
            callable : null
        }, {
            name : "append",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [$rt_longcls()],
            returnType : jl_AbstractStringBuilder,
            callable : null
        }, {
            name : "insert",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : jl_AbstractStringBuilder,
            callable : null
        }, {
            name : "append",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : jl_AbstractStringBuilder,
            callable : null
        }, {
            name : "insert",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_String],
            returnType : jl_AbstractStringBuilder,
            callable : null
        }, {
            name : "append",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : jl_AbstractStringBuilder,
            callable : null
        }, {
            name : "append",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [$rt_charcls()],
            returnType : jl_Appendable,
            callable : null
        }, {
            name : "append",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [jl_CharSequence, $rt_intcls(), $rt_intcls()],
            returnType : jl_Appendable,
            callable : null
        }, {
            name : "append",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [jl_CharSequence],
            returnType : jl_Appendable,
            callable : null
        }];
    jl_AbstractStringBuilder.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_CharSequence],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "append",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [jl_String],
            returnType : jl_AbstractStringBuilder,
            callable : null
        }, {
            name : "insert",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [$rt_intcls(), jl_String],
            returnType : jl_AbstractStringBuilder,
            callable : null
        }, {
            name : "append",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [$rt_intcls()],
            returnType : jl_AbstractStringBuilder,
            callable : null
        }, {
            name : "insert",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : jl_AbstractStringBuilder,
            callable : null
        }, {
            name : "append",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : jl_AbstractStringBuilder,
            callable : null
        }, {
            name : "insert",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [$rt_intcls(), $rt_intcls(), $rt_intcls()],
            returnType : jl_AbstractStringBuilder,
            callable : null
        }, {
            name : "append",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [$rt_longcls()],
            returnType : jl_AbstractStringBuilder,
            callable : null
        }, {
            name : "insert",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [$rt_intcls(), $rt_longcls()],
            returnType : jl_AbstractStringBuilder,
            callable : null
        }, {
            name : "insert",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [$rt_intcls(), $rt_longcls(), $rt_intcls()],
            returnType : jl_AbstractStringBuilder,
            callable : null
        }, {
            name : "append",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [$rt_floatcls()],
            returnType : jl_AbstractStringBuilder,
            callable : null
        }, {
            name : "insert",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [$rt_intcls(), $rt_floatcls()],
            returnType : jl_AbstractStringBuilder,
            callable : null
        }, {
            name : "append",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [$rt_doublecls()],
            returnType : jl_AbstractStringBuilder,
            callable : null
        }, {
            name : "insert",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [$rt_intcls(), $rt_doublecls()],
            returnType : jl_AbstractStringBuilder,
            callable : null
        }, {
            name : "trailingDecimalZeros",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "trailingDecimalZeros",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [$rt_longcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "append",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [$rt_charcls()],
            returnType : jl_AbstractStringBuilder,
            callable : null
        }, {
            name : "insert",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [$rt_intcls(), $rt_charcls()],
            returnType : jl_AbstractStringBuilder,
            callable : null
        }, {
            name : "appendCodePoint",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [$rt_intcls()],
            returnType : jl_AbstractStringBuilder,
            callable : null
        }, {
            name : "append",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [jl_Object],
            returnType : jl_AbstractStringBuilder,
            callable : null
        }, {
            name : "insert",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [$rt_intcls(), jl_Object],
            returnType : jl_AbstractStringBuilder,
            callable : null
        }, {
            name : "append",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [$rt_booleancls()],
            returnType : jl_AbstractStringBuilder,
            callable : null
        }, {
            name : "insert",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [$rt_intcls(), $rt_booleancls()],
            returnType : jl_AbstractStringBuilder,
            callable : null
        }, {
            name : "ensureCapacity",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "trimToSize",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "capacity",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "toString",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "length",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "charAt",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_charcls(),
            callable : null
        }, {
            name : "append",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [jl_CharSequence, $rt_intcls(), $rt_intcls()],
            returnType : jl_AbstractStringBuilder,
            callable : null
        }, {
            name : "insert",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [$rt_intcls(), jl_CharSequence, $rt_intcls(), $rt_intcls()],
            returnType : jl_AbstractStringBuilder,
            callable : null
        }, {
            name : "append",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [jl_CharSequence],
            returnType : jl_AbstractStringBuilder,
            callable : null
        }, {
            name : "append",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [jl_StringBuffer],
            returnType : jl_AbstractStringBuilder,
            callable : null
        }, {
            name : "insert",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [$rt_intcls(), jl_CharSequence],
            returnType : jl_AbstractStringBuilder,
            callable : null
        }, {
            name : "append",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [$rt_arraycls($rt_charcls()), $rt_intcls(), $rt_intcls()],
            returnType : jl_AbstractStringBuilder,
            callable : null
        }, {
            name : "insert",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [$rt_intcls(), $rt_arraycls($rt_charcls())],
            returnType : jl_AbstractStringBuilder,
            callable : null
        }, {
            name : "insert",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [$rt_intcls(), $rt_arraycls($rt_charcls()), $rt_intcls(), $rt_intcls()],
            returnType : jl_AbstractStringBuilder,
            callable : null
        }, {
            name : "append",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [$rt_arraycls($rt_charcls())],
            returnType : jl_AbstractStringBuilder,
            callable : null
        }, {
            name : "subSequence",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : jl_CharSequence,
            callable : null
        }, {
            name : "getChars",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls(), $rt_arraycls($rt_charcls()), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "setLength",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "deleteCharAt",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : jl_AbstractStringBuilder,
            callable : null
        }, {
            name : "delete",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : jl_AbstractStringBuilder,
            callable : null
        }, {
            name : "replace",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls(), jl_String],
            returnType : jl_AbstractStringBuilder,
            callable : null
        }, {
            name : "insertSpace",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "indexOf",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "indexOf",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String, $rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "lastIndexOf",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "lastIndexOf",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String, $rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "reverse",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_AbstractStringBuilder,
            callable : null
        }, {
            name : "substring",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : jl_String,
            callable : null
        }, {
            name : "substring",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : jl_String,
            callable : null
        }, {
            name : "setCharAt",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_charcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "offsetByCodePoints",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "codePointCount",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "codePointAt",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "codePointBefore",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }];
    jl_Appendable.$meta.methods = [
        {
            name : "append",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [jl_CharSequence],
            returnType : jl_Appendable,
            callable : null
        }, {
            name : "append",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [jl_CharSequence, $rt_intcls(), $rt_intcls()],
            returnType : jl_Appendable,
            callable : null
        }, {
            name : "append",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_charcls()],
            returnType : jl_Appendable,
            callable : null
        }];
    nle_Client.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "main",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls(jl_String)],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "run0",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "run1",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getOpts",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_arraycls(jl_String),
            callable : null
        }, {
            name : "registerErrorHandler",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getWindowError",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [],
            returnType : otjc_JSError,
            callable : null
        }, {
            name : "getWindowErrorL",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "handleNativeError",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "showCrashScreen",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getString",
            modifiers : 768,
            accessLevel : 1,
            parameterTypes : [jl_String],
            returnType : jl_String,
            callable : null
        }, {
            name : "addDebug",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [jl_StringBuilder, jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "addArray",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [jl_StringBuilder, jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getArray",
            modifiers : 768,
            accessLevel : 1,
            parameterTypes : [jl_String],
            returnType : jl_String,
            callable : null
        }, {
            name : "<clinit>",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getOpts$js_body$_4",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "registerErrorHandler$js_body$_5",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "handleNativeError$jsocb$_0",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getWindowError$js_body$_6",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "getWindowErrorL$js_body$_7",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "getString$js_body$_10",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "getArray$js_body$_13",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }];
    otjc_JSArrayReader.$meta.methods = [
        {
            name : "getLength",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "get",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : otj_JSObject,
            callable : null
        }];
    otjb_Window.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getDocument",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : otjdh_HTMLDocument,
            callable : null
        }, {
            name : "getScreen",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : otjb_Screen,
            callable : null
        }, {
            name : "getScreenX",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getScreenY",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getLocation",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : otjb_Location,
            callable : null
        }, {
            name : "getHistory",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : otjb_History,
            callable : null
        }, {
            name : "getFrameElement",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : otjdh_HTMLElement,
            callable : null
        }, {
            name : "getFrames",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : otjc_JSArrayReader,
            callable : null
        }, {
            name : "getInnerWidth",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getInnerHeight",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getOuterWidth",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getOuterHeight",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getScrollY",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getName",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "setName",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getParent",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : otjb_Window,
            callable : null
        }, {
            name : "getTop",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : otjb_Window,
            callable : null
        }, {
            name : "alert",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [otj_JSObject],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "alert",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "confirm",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [otj_JSObject],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "confirm",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "prompt",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : jl_String,
            callable : null
        }, {
            name : "prompt",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [jl_String, jl_String],
            returnType : jl_String,
            callable : null
        }, {
            name : "setTimeout",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [otjb_TimerHandler, $rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "setTimeout",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [otjb_TimerHandler, $rt_doublecls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "clearTimeout",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "setInterval",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [otjb_TimerHandler, $rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "setInterval",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [otjb_TimerHandler, $rt_doublecls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "clearInterval",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "requestAnimationFrame",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [otjb_AnimationFrameCallback],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "cancelAnimationFrame",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "blur",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "focus",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "close",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "moveBy",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "moveTo",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "resizeBy",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "resizeTo",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "scrollBy",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "scrollTo",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "open",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [jl_String, jl_String],
            returnType : otjb_Window,
            callable : null
        }, {
            name : "open",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [jl_String, jl_String, otjb_WindowFeatures],
            returnType : otjb_Window,
            callable : null
        }, {
            name : "open",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [jl_String, jl_String, jl_String],
            returnType : otjb_Window,
            callable : null
        }, {
            name : "print",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "stop",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "postMessage",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [otj_JSObject],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "postMessage",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [otj_JSObject, jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "postMessage",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [otj_JSObject, jl_String, otjc_JSArrayReader],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "postMessage",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [otj_JSObject, jl_String, $rt_arraycls(otj_JSObject)],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "current",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [],
            returnType : otjb_Window,
            callable : null
        }, {
            name : "worker",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [],
            returnType : otjb_Window,
            callable : null
        }, {
            name : "encodeURI",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : jl_String,
            callable : null
        }, {
            name : "encodeURIComponent",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : jl_String,
            callable : null
        }, {
            name : "decodeURI",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : jl_String,
            callable : null
        }, {
            name : "decodeURIComponent",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : jl_String,
            callable : null
        }, {
            name : "getDevicePixelRatio",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_doublecls(),
            callable : null
        }, {
            name : "atob",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : jl_String,
            callable : null
        }, {
            name : "btoa",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : jl_String,
            callable : null
        }, {
            name : "<init>$static",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [otjb_Window],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "open$static",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [otjb_Window, jl_String, jl_String, otjb_WindowFeatures],
            returnType : otjb_Window,
            callable : null
        }, {
            name : "postMessage$static",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [otjb_Window, otj_JSObject, jl_String, $rt_arraycls(otj_JSObject)],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "alert$js_body$_18",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [otj_JSObject],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "alert$js_body$_19",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [otj_JSObject],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "confirm$js_body$_20",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "confirm$js_body$_21",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "prompt$js_body$_23",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [otj_JSObject, otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "setTimeout$js_body$_24",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [otj_JSObject, otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "setTimeout$js_body$_25",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [otj_JSObject, otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "clearTimeout$js_body$_26",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [otj_JSObject],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "setInterval$js_body$_27",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [otj_JSObject, otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "setInterval$js_body$_28",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [otj_JSObject, otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "clearInterval$js_body$_29",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [otj_JSObject],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "requestAnimationFrame$js_body$_30",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "cancelAnimationFrame$js_body$_31",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [otj_JSObject],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "current$js_body$_50",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "worker$js_body$_51",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "encodeURI$js_body$_52",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "encodeURIComponent$js_body$_53",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "decodeURI$js_body$_54",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "decodeURIComponent$js_body$_55",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "atob$js_body$_57",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "btoa$js_body$_58",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "addEventListener$exported$0",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [otj_JSObject, otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "removeEventListener$exported$1",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [otj_JSObject, otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "get$exported$2",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "removeEventListener$exported$3",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [otj_JSObject, otj_JSObject, otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "dispatchEvent$exported$4",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "getLength$exported$5",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "addEventListener$exported$6",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [otj_JSObject, otj_JSObject, otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }];
    otjb_WindowEventTarget.$meta.methods = [
        {
            name : "listenBeforeOnload",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [otjde_EventListener],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "neglectBeforeOnload",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [otjde_EventListener],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "listenMessage",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [otjde_EventListener],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "neglectMessage",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [otjde_EventListener],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "listenHashChange",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [otjde_EventListener],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "neglectHashChange",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [otjde_EventListener],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "listenBeforeOnload$static",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [otjb_WindowEventTarget, otjde_EventListener],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "neglectBeforeOnload$static",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [otjb_WindowEventTarget, otjde_EventListener],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "listenMessage$static",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [otjb_WindowEventTarget, otjde_EventListener],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "neglectMessage$static",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [otjb_WindowEventTarget, otjde_EventListener],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "listenHashChange$static",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [otjb_WindowEventTarget, otjde_EventListener],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "neglectHashChange$static",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [otjb_WindowEventTarget, otjde_EventListener],
            returnType : $rt_voidcls(),
            callable : null
        }];
    otjde_EventTarget.$meta.methods = [
        {
            name : "addEventListener",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [jl_String, otjde_EventListener, $rt_booleancls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "addEventListener",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [jl_String, otjde_EventListener],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "removeEventListener",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [jl_String, otjde_EventListener, $rt_booleancls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "removeEventListener",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [jl_String, otjde_EventListener],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "dispatchEvent",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [otjde_Event],
            returnType : $rt_booleancls(),
            callable : null
        }];
    otjde_FocusEventTarget.$meta.methods = [
        {
            name : "listenFocus",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [otjde_EventListener],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "neglectFocus",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [otjde_EventListener],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "listenBlur",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [otjde_EventListener],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "neglectBlur",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [otjde_EventListener],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "listenFocus$static",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [otjde_FocusEventTarget, otjde_EventListener],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "neglectFocus$static",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [otjde_FocusEventTarget, otjde_EventListener],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "listenBlur$static",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [otjde_FocusEventTarget, otjde_EventListener],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "neglectBlur$static",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [otjde_FocusEventTarget, otjde_EventListener],
            returnType : $rt_voidcls(),
            callable : null
        }];
    otjde_MouseEventTarget.$meta.methods = [
        {
            name : "listenClick",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [otjde_EventListener],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "neglectClick",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [otjde_EventListener],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "listenDoubleClick",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [otjde_EventListener],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "neglectDoubleClick",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [otjde_EventListener],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "listenMouseDown",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [otjde_EventListener],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "neglectMouseDown",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [otjde_EventListener],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "listenMouseUp",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [otjde_EventListener],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "neglectMouseUp",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [otjde_EventListener],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "listenMouseOver",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [otjde_EventListener],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "neglectMouseOver",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [otjde_EventListener],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "listenMouseEnter",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [otjde_EventListener],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "neglectMouseEnter",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [otjde_EventListener],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "listenMouseLeaeve",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [otjde_EventListener],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "neglectMouseLeave",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [otjde_EventListener],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "listenMouseOut",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [otjde_EventListener],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "neglectMouseOut",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [otjde_EventListener],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "listenClick$static",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [otjde_MouseEventTarget, otjde_EventListener],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "neglectClick$static",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [otjde_MouseEventTarget, otjde_EventListener],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "listenDoubleClick$static",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [otjde_MouseEventTarget, otjde_EventListener],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "neglectDoubleClick$static",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [otjde_MouseEventTarget, otjde_EventListener],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "listenMouseDown$static",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [otjde_MouseEventTarget, otjde_EventListener],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "neglectMouseDown$static",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [otjde_MouseEventTarget, otjde_EventListener],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "listenMouseUp$static",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [otjde_MouseEventTarget, otjde_EventListener],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "neglectMouseUp$static",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [otjde_MouseEventTarget, otjde_EventListener],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "listenMouseOver$static",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [otjde_MouseEventTarget, otjde_EventListener],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "neglectMouseOver$static",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [otjde_MouseEventTarget, otjde_EventListener],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "listenMouseEnter$static",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [otjde_MouseEventTarget, otjde_EventListener],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "neglectMouseEnter$static",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [otjde_MouseEventTarget, otjde_EventListener],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "listenMouseLeaeve$static",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [otjde_MouseEventTarget, otjde_EventListener],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "neglectMouseLeave$static",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [otjde_MouseEventTarget, otjde_EventListener],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "listenMouseOut$static",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [otjde_MouseEventTarget, otjde_EventListener],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "neglectMouseOut$static",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [otjde_MouseEventTarget, otjde_EventListener],
            returnType : $rt_voidcls(),
            callable : null
        }];
    otjde_KeyboardEventTarget.$meta.methods = [
        {
            name : "listenKeyDown",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [otjde_EventListener],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "neglectKeyDown",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [otjde_EventListener],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "listenKeyUp",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [otjde_EventListener],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "neglectKeyUp",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [otjde_EventListener],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "listenKeyPress",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [otjde_EventListener],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "neglectKeyPress",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [otjde_EventListener],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "listenKeyDown$static",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [otjde_KeyboardEventTarget, otjde_EventListener],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "neglectKeyDown$static",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [otjde_KeyboardEventTarget, otjde_EventListener],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "listenKeyUp$static",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [otjde_KeyboardEventTarget, otjde_EventListener],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "neglectKeyUp$static",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [otjde_KeyboardEventTarget, otjde_EventListener],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "listenKeyPress$static",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [otjde_KeyboardEventTarget, otjde_EventListener],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "neglectKeyPress$static",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [otjde_KeyboardEventTarget, otjde_EventListener],
            returnType : $rt_voidcls(),
            callable : null
        }];
    otjde_LoadEventTarget.$meta.methods = [
        {
            name : "listenLoad",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [otjde_EventListener],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "neglectLoad",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [otjde_EventListener],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "listenLoad$static",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [otjde_LoadEventTarget, otjde_EventListener],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "neglectLoad$static",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [otjde_LoadEventTarget, otjde_EventListener],
            returnType : $rt_voidcls(),
            callable : null
        }];
    otjb_StorageProvider.$meta.methods = [
        {
            name : "getSessionStorage",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : otjb_Storage,
            callable : null
        }, {
            name : "getLocalStorage",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : otjb_Storage,
            callable : null
        }];
    otji_JS.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "arrayData",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "dataToByteArray",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [otj_JSObject],
            returnType : $rt_arraycls($rt_bytecls()),
            callable : null
        }, {
            name : "dataToCharArray",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [otj_JSObject],
            returnType : $rt_arraycls($rt_charcls()),
            callable : null
        }, {
            name : "dataToShortArray",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [otj_JSObject],
            returnType : $rt_arraycls($rt_shortcls()),
            callable : null
        }, {
            name : "dataToIntArray",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [otj_JSObject],
            returnType : $rt_arraycls($rt_intcls()),
            callable : null
        }, {
            name : "dataToFloatArray",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [otj_JSObject],
            returnType : $rt_arraycls($rt_floatcls()),
            callable : null
        }, {
            name : "dataToDoubleArray",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [otj_JSObject],
            returnType : $rt_arraycls($rt_doublecls()),
            callable : null
        }, {
            name : "dataToArray",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [otj_JSObject],
            returnType : $rt_arraycls(otj_JSObject),
            callable : null
        }, {
            name : "wrap",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [$rt_bytecls()],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "wrap",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [$rt_shortcls()],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "wrap",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "wrap",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [$rt_charcls()],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "wrap",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [$rt_floatcls()],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "wrap",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [$rt_doublecls()],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "wrap",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [$rt_booleancls()],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "wrap",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "unwrapByte",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [otj_JSObject],
            returnType : $rt_bytecls(),
            callable : null
        }, {
            name : "unwrapCharacter",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [otj_JSObject],
            returnType : $rt_charcls(),
            callable : null
        }, {
            name : "unwrapShort",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [otj_JSObject],
            returnType : $rt_shortcls(),
            callable : null
        }, {
            name : "unwrapInt",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [otj_JSObject],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "unwrapFloat",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [otj_JSObject],
            returnType : $rt_floatcls(),
            callable : null
        }, {
            name : "unwrapDouble",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [otj_JSObject],
            returnType : $rt_doublecls(),
            callable : null
        }, {
            name : "unwrapBoolean",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [otj_JSObject],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "unwrapString",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [otj_JSObject],
            returnType : jl_String,
            callable : null
        }, {
            name : "wrap",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls(otj_JSObject)],
            returnType : otjc_JSArray,
            callable : null
        }, {
            name : "arrayWrapper",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [],
            returnType : juf_Function,
            callable : null
        }, {
            name : "map",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls(jl_Object), juf_Function],
            returnType : otjc_JSArray,
            callable : null
        }, {
            name : "arrayMapper",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [juf_Function],
            returnType : juf_Function,
            callable : null
        }, {
            name : "wrap",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_booleancls())],
            returnType : otjc_JSArray,
            callable : null
        }, {
            name : "booleanArrayWrapper",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [],
            returnType : juf_Function,
            callable : null
        }, {
            name : "wrap",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls())],
            returnType : otjc_JSArray,
            callable : null
        }, {
            name : "byteArrayWrapper",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [],
            returnType : juf_Function,
            callable : null
        }, {
            name : "wrap",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_shortcls())],
            returnType : otjc_JSArray,
            callable : null
        }, {
            name : "shortArrayWrapper",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [],
            returnType : juf_Function,
            callable : null
        }, {
            name : "wrap",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_charcls())],
            returnType : otjc_JSArray,
            callable : null
        }, {
            name : "charArrayWrapper",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [],
            returnType : juf_Function,
            callable : null
        }, {
            name : "wrap",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_intcls())],
            returnType : otjc_JSArray,
            callable : null
        }, {
            name : "intArrayWrapper",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [],
            returnType : juf_Function,
            callable : null
        }, {
            name : "wrap",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls(jl_String)],
            returnType : otjc_JSArray,
            callable : null
        }, {
            name : "stringArrayWrapper",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [],
            returnType : juf_Function,
            callable : null
        }, {
            name : "wrap",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_floatcls())],
            returnType : otjc_JSArray,
            callable : null
        }, {
            name : "floatArrayWrapper",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [],
            returnType : juf_Function,
            callable : null
        }, {
            name : "wrap",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_doublecls())],
            returnType : otjc_JSArray,
            callable : null
        }, {
            name : "doubleArrayWrapper",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [],
            returnType : juf_Function,
            callable : null
        }, {
            name : "unwrapArray",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [jl_Class, otjc_JSArrayReader],
            returnType : $rt_arraycls(otj_JSObject),
            callable : null
        }, {
            name : "arrayUnwrapper",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [jl_Class],
            returnType : juf_Function,
            callable : null
        }, {
            name : "unmapArray",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [jl_Class, otjc_JSArrayReader, juf_Function],
            returnType : $rt_arraycls(jl_Object),
            callable : null
        }, {
            name : "arrayUnmapper",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [jl_Class, juf_Function],
            returnType : juf_Function,
            callable : null
        }, {
            name : "unwrapBooleanArray",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [otjc_JSArrayReader],
            returnType : $rt_arraycls($rt_booleancls()),
            callable : null
        }, {
            name : "booleanArrayUnwrapper",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [],
            returnType : juf_Function,
            callable : null
        }, {
            name : "unwrapByteArray",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [otjc_JSArrayReader],
            returnType : $rt_arraycls($rt_bytecls()),
            callable : null
        }, {
            name : "byteArrayUnwrapper",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [],
            returnType : juf_Function,
            callable : null
        }, {
            name : "unwrapShortArray",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [otjc_JSArrayReader],
            returnType : $rt_arraycls($rt_shortcls()),
            callable : null
        }, {
            name : "shortArrayUnwrapper",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [],
            returnType : juf_Function,
            callable : null
        }, {
            name : "unwrapIntArray",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [otjc_JSArrayReader],
            returnType : $rt_arraycls($rt_intcls()),
            callable : null
        }, {
            name : "intArrayUnwrapper",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [],
            returnType : juf_Function,
            callable : null
        }, {
            name : "unwrapCharArray",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [otjc_JSArrayReader],
            returnType : $rt_arraycls($rt_charcls()),
            callable : null
        }, {
            name : "charArrayUnwrapper",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [],
            returnType : juf_Function,
            callable : null
        }, {
            name : "unwrapFloatArray",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [otjc_JSArrayReader],
            returnType : $rt_arraycls($rt_floatcls()),
            callable : null
        }, {
            name : "floatArrayUnwrapper",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [],
            returnType : juf_Function,
            callable : null
        }, {
            name : "unwrapDoubleArray",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [otjc_JSArrayReader],
            returnType : $rt_arraycls($rt_doublecls()),
            callable : null
        }, {
            name : "doubleArrayUnwrapper",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [],
            returnType : juf_Function,
            callable : null
        }, {
            name : "unwrapStringArray",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [otjc_JSArrayReader],
            returnType : $rt_arraycls(jl_String),
            callable : null
        }, {
            name : "stringArrayUnwrapper",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [],
            returnType : juf_Function,
            callable : null
        }, {
            name : "invoke",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [otj_JSObject, otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "invoke",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [otj_JSObject, otj_JSObject, otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "invoke",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "invoke",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "invoke",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "invoke",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "invoke",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "invoke",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "invoke",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "invoke",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "invoke",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "invoke",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "invoke",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "invoke",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "get",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [otj_JSObject, otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "set",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [otj_JSObject, otj_JSObject, otj_JSObject],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "function",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [otj_JSObject, otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "functionAsObject",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [otj_JSObject, otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "lambda$arrayUnmapper$2",
            modifiers : 544,
            accessLevel : 1,
            parameterTypes : [jl_Class, juf_Function, otjc_JSArray],
            returnType : $rt_arraycls(jl_Object),
            callable : null
        }, {
            name : "lambda$arrayUnwrapper$1",
            modifiers : 544,
            accessLevel : 1,
            parameterTypes : [jl_Class, otjc_JSArrayReader],
            returnType : $rt_arraycls(otj_JSObject),
            callable : null
        }, {
            name : "lambda$arrayMapper$0",
            modifiers : 544,
            accessLevel : 1,
            parameterTypes : [juf_Function, $rt_arraycls(jl_Object)],
            returnType : otjc_JSArray,
            callable : null
        }, {
            name : "get$js_body$_79",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [otj_JSObject, otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "set$js_body$_80",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [otj_JSObject, otj_JSObject, otj_JSObject],
            returnType : $rt_voidcls(),
            callable : null
        }];
    otp_Platform.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getPlatformObject",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : otp_PlatformObject,
            callable : null
        }, {
            name : "clone",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : jl_Object,
            callable : null
        }, {
            name : "isInstance",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [otp_PlatformObject, otp_PlatformClass],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "isInstanceLowLevel",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [otr_RuntimeClass, otr_RuntimeObject],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "isUndefined",
            modifiers : 768,
            accessLevel : 1,
            parameterTypes : [otj_JSObject],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "isAssignable",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [otp_PlatformClass, otp_PlatformClass],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "isAssignableLowLevel",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [otr_RuntimeClass, otr_RuntimeClass],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "asJavaClass",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [otp_PlatformObject],
            returnType : jl_Class,
            callable : null
        }, {
            name : "nextObjectId",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "newInstance",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [otp_PlatformClass],
            returnType : jl_Object,
            callable : null
        }, {
            name : "prepareNewInstance",
            modifiers : 768,
            accessLevel : 1,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "newInstanceImpl",
            modifiers : 768,
            accessLevel : 1,
            parameterTypes : [otp_PlatformClass],
            returnType : jl_Object,
            callable : null
        }, {
            name : "lookupClass",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : otp_PlatformClass,
            callable : null
        }, {
            name : "initClass",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [otp_PlatformClass],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "initClassLowLevel",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [otr_RuntimeClass],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "objectFromResource",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [otpm_StaticFieldResource],
            returnType : jl_Object,
            callable : null
        }, {
            name : "getEnumConstants",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [otp_PlatformClass],
            returnType : $rt_arraycls(jl_Enum),
            callable : null
        }, {
            name : "getEnumConstantsLowLevel",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [otp_PlatformClass],
            returnType : $rt_arraycls(jl_Enum),
            callable : null
        }, {
            name : "getEnumConstantsSize",
            modifiers : 768,
            accessLevel : 1,
            parameterTypes : [otp_PlatformClass],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getEnumConstantsSizeImpl",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [otr_RuntimeClass],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "fillEnumConstants",
            modifiers : 768,
            accessLevel : 1,
            parameterTypes : [otp_PlatformClass, $rt_arraycls(jl_Enum)],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "fillEnumConstantsImpl",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [otr_RuntimeClass, $rt_arraycls(oti_Address)],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getAnnotations",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [otp_PlatformClass],
            returnType : $rt_arraycls(jla_Annotation),
            callable : null
        }, {
            name : "startThread",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [otp_PlatformRunnable],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "launchThread",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [otp_PlatformRunnable],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "postpone",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [otp_PlatformRunnable],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "schedule",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [otp_PlatformRunnable, $rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "killSchedule",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "createQueue",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [],
            returnType : otp_PlatformQueue,
            callable : null
        }, {
            name : "createQueueJs",
            modifiers : 768,
            accessLevel : 1,
            parameterTypes : [],
            returnType : otp_PlatformQueue,
            callable : null
        }, {
            name : "stringFromCharCode",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : otp_PlatformString,
            callable : null
        }, {
            name : "isPrimitive",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [otp_PlatformClass],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "isPrimitiveLowLevel",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [otr_RuntimeClass],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "isEnum",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [otp_PlatformClass],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "isEnumLowLevel",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [otr_RuntimeClass],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "getArrayItem",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [otp_PlatformClass],
            returnType : otp_PlatformClass,
            callable : null
        }, {
            name : "getName",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [otp_PlatformClass],
            returnType : jl_String,
            callable : null
        }, {
            name : "isLowLevel",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "isUndefined$js_body$_5",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "nextObjectId$js_body$_9",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "createQueueJs$js_body$_30",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [],
            returnType : otj_JSObject,
            callable : null
        }];
    jl_Integer.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "toString",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : jl_String,
            callable : null
        }, {
            name : "toHexString",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : jl_String,
            callable : null
        }, {
            name : "toOctalString",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : jl_String,
            callable : null
        }, {
            name : "toBinaryString",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : jl_String,
            callable : null
        }, {
            name : "toString",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : jl_String,
            callable : null
        }, {
            name : "parseInt",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [jl_String, $rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "parseInt",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "valueOf",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [jl_String, $rt_intcls()],
            returnType : jl_Integer,
            callable : null
        }, {
            name : "valueOf",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : jl_Integer,
            callable : null
        }, {
            name : "valueOf",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : jl_Integer,
            callable : null
        }, {
            name : "ensureIntegerCache",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "intValue",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "longValue",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_longcls(),
            callable : null
        }, {
            name : "floatValue",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_floatcls(),
            callable : null
        }, {
            name : "doubleValue",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_doublecls(),
            callable : null
        }, {
            name : "toString",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "hashCode",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "equals",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "getInteger",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : jl_Integer,
            callable : null
        }, {
            name : "getInteger",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [jl_String, $rt_intcls()],
            returnType : jl_Integer,
            callable : null
        }, {
            name : "getInteger",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [jl_String, jl_Integer],
            returnType : jl_Integer,
            callable : null
        }, {
            name : "decode",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : jl_Integer,
            callable : null
        }, {
            name : "decodeDigit",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [$rt_charcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "compareTo",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Integer],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "compare",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "numberOfLeadingZeros",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "numberOfTrailingZeros",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "highestOneBit",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "lowestOneBit",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "bitCount",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "rotateLeft",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "rotateRight",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "reverse",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "reverseBytes",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "signum",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "divideUnsigned",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "remainderUnsigned",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "compareTo",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "<clinit>",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }];
    jl_Number.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "intValue",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "longValue",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_longcls(),
            callable : null
        }, {
            name : "floatValue",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_floatcls(),
            callable : null
        }, {
            name : "doubleValue",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_doublecls(),
            callable : null
        }, {
            name : "byteValue",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_bytecls(),
            callable : null
        }, {
            name : "shortValue",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_shortcls(),
            callable : null
        }];
    otjc_JSString.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "stringValue",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "stringValue",
            modifiers : 768,
            accessLevel : 1,
            parameterTypes : [otjc_JSString],
            returnType : jl_String,
            callable : null
        }, {
            name : "valueOf",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : otjc_JSString,
            callable : null
        }, {
            name : "fromCharCode",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : otjc_JSString,
            callable : null
        }, {
            name : "getLength",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "charAt",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : otjc_JSString,
            callable : null
        }, {
            name : "charCodeAt",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "concat",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [otjc_JSString],
            returnType : otjc_JSString,
            callable : null
        }, {
            name : "concat",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [otjc_JSString, otjc_JSString],
            returnType : otjc_JSString,
            callable : null
        }, {
            name : "concat",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [otjc_JSString, otjc_JSString, otjc_JSString],
            returnType : otjc_JSString,
            callable : null
        }, {
            name : "indexOf",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [otjc_JSString],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "lastIndexOf",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [otjc_JSString],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "match",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [otjc_JSRegExp],
            returnType : otjc_JSArray,
            callable : null
        }, {
            name : "match",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [otjc_JSString],
            returnType : otjc_JSArray,
            callable : null
        }, {
            name : "replace",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [otjc_JSRegExp, otjc_JSString],
            returnType : otjc_JSString,
            callable : null
        }, {
            name : "replace",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [otjc_JSRegExp, otjc_JSReplaceFunction],
            returnType : otjc_JSString,
            callable : null
        }, {
            name : "replace",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [otjc_JSString, otjc_JSString],
            returnType : otjc_JSString,
            callable : null
        }, {
            name : "replace",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [otjc_JSString, otjc_JSReplaceFunction],
            returnType : otjc_JSString,
            callable : null
        }, {
            name : "search",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [otjc_JSRegExp],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "search",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [otjc_JSString],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "slice",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : otjc_JSString,
            callable : null
        }, {
            name : "slice",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : otjc_JSString,
            callable : null
        }, {
            name : "split",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [otjc_JSRegExp],
            returnType : $rt_arraycls(otjc_JSString),
            callable : null
        }, {
            name : "split",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [otjc_JSString],
            returnType : $rt_arraycls(otjc_JSString),
            callable : null
        }, {
            name : "split",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [otjc_JSRegExp, $rt_intcls()],
            returnType : $rt_arraycls(otjc_JSString),
            callable : null
        }, {
            name : "split",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [otjc_JSString, $rt_intcls()],
            returnType : $rt_arraycls(otjc_JSString),
            callable : null
        }, {
            name : "substr",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : otjc_JSString,
            callable : null
        }, {
            name : "substr",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : otjc_JSString,
            callable : null
        }, {
            name : "substring",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : otjc_JSString,
            callable : null
        }, {
            name : "substring",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : otjc_JSString,
            callable : null
        }, {
            name : "toLowerCase",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : otjc_JSString,
            callable : null
        }, {
            name : "toUpperCase",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : otjc_JSString,
            callable : null
        }, {
            name : "trim",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : otjc_JSString,
            callable : null
        }, {
            name : "isInstance",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [otj_JSObject],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "<init>$static",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [otjc_JSString],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "stringValue$static",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [otjc_JSString],
            returnType : jl_String,
            callable : null
        }, {
            name : "stringValue$js_body$_2",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "valueOf$js_body$_3",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "fromCharCode$js_body$_4",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "isInstance$js_body$_34",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }];
    nlea_EaglerAdapterImpl2.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "startTitleMusic",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [$rt_floatcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "stopTitleMusic",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "volumeTitleMusic",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [$rt_floatcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "playingTitleMusic",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "_wisWebGL",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "_wisAnisotropicPatched",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "_wgetShaderHeader",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "getSelfProxy",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "getCustomProxyListString",
            modifiers : 768,
            accessLevel : 1,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "getCustomProxyList",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_arraycls(jl_String),
            callable : null
        }, {
            name : "getHostString",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "getLocationString",
            modifiers : 768,
            accessLevel : 1,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "isSSLPage",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "loadResource",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : ji_InputStream,
            callable : null
        }, {
            name : "loadResourceBytes",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_arraycls($rt_bytecls()),
            callable : null
        }, {
            name : "fileContents",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : jl_String,
            callable : null
        }, {
            name : "fileContentsLines",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_arraycls(jl_String),
            callable : null
        }, {
            name : "downloadAssetPack",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : jl_String,
            callable : null
        }, {
            name : "downloadAssetPack",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [jl_String, oti_AsyncCallback],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "setContextVar",
            modifiers : 768,
            accessLevel : 1,
            parameterTypes : [otj_JSObject],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "setDebugVar",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [jl_String, jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "hasBeenActive",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "getIdentifier",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_arraycls(jl_String),
            callable : null
        }, {
            name : "getString",
            modifiers : 768,
            accessLevel : 1,
            parameterTypes : [jl_String],
            returnType : jl_String,
            callable : null
        }, {
            name : "onWindowUnload",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getOffsetX",
            modifiers : 768,
            accessLevel : 1,
            parameterTypes : [otjde_MouseEvent],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getOffsetY",
            modifiers : 768,
            accessLevel : 1,
            parameterTypes : [otjde_MouseEvent],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getWhich",
            modifiers : 768,
            accessLevel : 1,
            parameterTypes : [otjde_KeyboardEvent],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "initializeContext",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [otjdh_HTMLElement, jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "destroyContext",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "removeEventHandlers",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "youEagler",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "_wglEnable",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "_wglClearDepth",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_floatcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "_wglDepthFunc",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "_wglCullFace",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "_wglViewport",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "_wglClear",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "_wglClearColor",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_floatcls(), $rt_floatcls(), $rt_floatcls(), $rt_floatcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "_wglDisable",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "_wglGetError",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "_wglFlush",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "_wglTexImage2D",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls(), jn_ByteBuffer],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "_wglBlendFunc",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "_wglDepthMask",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_booleancls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "_wglColorMask",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_booleancls(), $rt_booleancls(), $rt_booleancls(), $rt_booleancls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "_wglBindTexture",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), nlea_EaglerAdapterImpl2$TextureGL],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "_wglCopyTexSubImage2D",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "_wglTexParameteri",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "_wglTexParameterf",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls(), $rt_floatcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "_wglTexImage2D",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls(), jn_IntBuffer],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "_wglTexSubImage2D",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls(), jn_IntBuffer],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "_wglDeleteTextures",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [nlea_EaglerAdapterImpl2$TextureGL],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "_wglDrawArrays",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "_wglDrawElements",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "_wglGenTextures",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : nlea_EaglerAdapterImpl2$TextureGL,
            callable : null
        }, {
            name : "_wglTexSubImage2D",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls(), jn_ByteBuffer],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "_wglActiveTexture",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "_wglCreateProgram",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : nlea_EaglerAdapterImpl2$ProgramGL,
            callable : null
        }, {
            name : "_wglCreateShader",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : nlea_EaglerAdapterImpl2$ShaderGL,
            callable : null
        }, {
            name : "_wglAttachShader",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [nlea_EaglerAdapterImpl2$ProgramGL, nlea_EaglerAdapterImpl2$ShaderGL],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "_wglDetachShader",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [nlea_EaglerAdapterImpl2$ProgramGL, nlea_EaglerAdapterImpl2$ShaderGL],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "_wglCompileShader",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [nlea_EaglerAdapterImpl2$ShaderGL],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "_wglLinkProgram",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [nlea_EaglerAdapterImpl2$ProgramGL],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "_wglShaderSource",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [nlea_EaglerAdapterImpl2$ShaderGL, jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "_wglGetShaderInfoLog",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [nlea_EaglerAdapterImpl2$ShaderGL],
            returnType : jl_String,
            callable : null
        }, {
            name : "_wglGetProgramInfoLog",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [nlea_EaglerAdapterImpl2$ProgramGL],
            returnType : jl_String,
            callable : null
        }, {
            name : "_wglGetShaderCompiled",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [nlea_EaglerAdapterImpl2$ShaderGL],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "_wglGetProgramLinked",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [nlea_EaglerAdapterImpl2$ProgramGL],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "_wglDeleteShader",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [nlea_EaglerAdapterImpl2$ShaderGL],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "_wglDeleteProgram",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [nlea_EaglerAdapterImpl2$ProgramGL],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "_wglCreateBuffer",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : nlea_EaglerAdapterImpl2$BufferGL,
            callable : null
        }, {
            name : "_wglDeleteBuffer",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [nlea_EaglerAdapterImpl2$BufferGL],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "_wglBindBuffer",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), nlea_EaglerAdapterImpl2$BufferGL],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "_wglBufferData0",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jn_IntBuffer, $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "_wglBufferSubData0",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls(), jn_IntBuffer],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "_wglBufferData",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_Object, $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "_wglBufferSubData",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls(), jl_Object],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "_wglBindAttribLocation",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [nlea_EaglerAdapterImpl2$ProgramGL, $rt_intcls(), jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "_wglEnableVertexAttribArray",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "_wglDisableVertexAttribArray",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "_wglGetUniformLocation",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [nlea_EaglerAdapterImpl2$ProgramGL, jl_String],
            returnType : nlea_EaglerAdapterImpl2$UniformGL,
            callable : null
        }, {
            name : "_wglBindAttributeLocation",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [nlea_EaglerAdapterImpl2$ProgramGL, $rt_intcls(), jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "_wglUniform1f",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [nlea_EaglerAdapterImpl2$UniformGL, $rt_floatcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "_wglUniform2f",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [nlea_EaglerAdapterImpl2$UniformGL, $rt_floatcls(), $rt_floatcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "_wglUniform3f",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [nlea_EaglerAdapterImpl2$UniformGL, $rt_floatcls(), $rt_floatcls(), $rt_floatcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "_wglUniform4f",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [nlea_EaglerAdapterImpl2$UniformGL, $rt_floatcls(), $rt_floatcls(), $rt_floatcls(), $rt_floatcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "_wglUniform1i",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [nlea_EaglerAdapterImpl2$UniformGL, $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "_wglUniform2i",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [nlea_EaglerAdapterImpl2$UniformGL, $rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "_wglUniform3i",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [nlea_EaglerAdapterImpl2$UniformGL, $rt_intcls(), $rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "_wglUniform4i",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [nlea_EaglerAdapterImpl2$UniformGL, $rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "_wglUniformMat2fv",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [nlea_EaglerAdapterImpl2$UniformGL, $rt_arraycls($rt_floatcls())],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "_wglUniformMat3fv",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [nlea_EaglerAdapterImpl2$UniformGL, $rt_arraycls($rt_floatcls())],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "_wglUniformMat4fv",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [nlea_EaglerAdapterImpl2$UniformGL, $rt_arraycls($rt_floatcls())],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "_wglUseProgram",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [nlea_EaglerAdapterImpl2$ProgramGL],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "_wglGetParameter",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls(), $rt_arraycls($rt_intcls())],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "_wglPolygonOffset",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_floatcls(), $rt_floatcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "_wglVertexAttribPointer",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_booleancls(), $rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "_wglBindFramebuffer",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), nlea_EaglerAdapterImpl2$FramebufferGL],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "_wglCreateFramebuffer",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : nlea_EaglerAdapterImpl2$FramebufferGL,
            callable : null
        }, {
            name : "_wglDeleteFramebuffer",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [nlea_EaglerAdapterImpl2$FramebufferGL],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "_wglFramebufferTexture2D",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), nlea_EaglerAdapterImpl2$TextureGL],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "_wglCreateQuery",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : nlea_EaglerAdapterImpl2$QueryGL,
            callable : null
        }, {
            name : "_wglBeginQuery",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), nlea_EaglerAdapterImpl2$QueryGL],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "_wglEndQuery",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "_wglDeleteQuery",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [nlea_EaglerAdapterImpl2$QueryGL],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "_wglGetQueryObjecti",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [nlea_EaglerAdapterImpl2$QueryGL, $rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "_wglCreateVertexArray",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : nlea_EaglerAdapterImpl2$BufferArrayGL,
            callable : null
        }, {
            name : "_wglDeleteVertexArray",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [nlea_EaglerAdapterImpl2$BufferArrayGL],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "_wglBindVertexArray",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [nlea_EaglerAdapterImpl2$BufferArrayGL],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "_wglDrawBuffer",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "_wglCreateRenderBuffer",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : nlea_EaglerAdapterImpl2$RenderbufferGL,
            callable : null
        }, {
            name : "_wglBindRenderbuffer",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [nlea_EaglerAdapterImpl2$RenderbufferGL],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "_wglRenderbufferStorage",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "_wglFramebufferRenderbuffer",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), nlea_EaglerAdapterImpl2$RenderbufferGL],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "_wglDeleteRenderbuffer",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [nlea_EaglerAdapterImpl2$RenderbufferGL],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "_wglRenderbufferStorageMultisample",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "_wglBlitFramebuffer",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "_wglGetAttribLocation",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [nlea_EaglerAdapterImpl2$ProgramGL, jl_String],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "__wglGetTexParameteri",
            modifiers : 772,
            accessLevel : 1,
            parameterTypes : [nleat_WebGL2RenderingContext, $rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "_wglGetTexParameteri",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "__wglGetTexParameterf",
            modifiers : 772,
            accessLevel : 1,
            parameterTypes : [nleat_WebGL2RenderingContext, $rt_intcls()],
            returnType : $rt_floatcls(),
            callable : null
        }, {
            name : "_wglGetTexParameterf",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_floatcls(),
            callable : null
        }, {
            name : "isWindows",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "getDataURL",
            modifiers : 768,
            accessLevel : 1,
            parameterTypes : [otjt_ArrayBuffer, jl_String],
            returnType : jl_String,
            callable : null
        }, {
            name : "freeDataURL",
            modifiers : 768,
            accessLevel : 1,
            parameterTypes : [jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "loadPNG",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls())],
            returnType : nle_EaglerImage,
            callable : null
        }, {
            name : "loadPNG0",
            modifiers : 768,
            accessLevel : 1,
            parameterTypes : [otjt_ArrayBuffer],
            returnType : nle_EaglerImage,
            callable : null
        }, {
            name : "loadPNG0",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [otjt_ArrayBuffer, oti_AsyncCallback],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "isVideoSupported",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "loadVideo",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [jl_String, $rt_booleancls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "loadVideo",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [jl_String, $rt_booleancls(), jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "setVideoPointer",
            modifiers : 768,
            accessLevel : 1,
            parameterTypes : [jl_String, otjdh_HTMLVideoElement],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "callVideoLoadEvent",
            modifiers : 768,
            accessLevel : 1,
            parameterTypes : [jl_String, otjdh_HTMLVideoElement],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "loadVideo",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [jl_String, $rt_booleancls(), jl_String, jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "bufferVideo",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [jl_String, $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "unloadVideo",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "isVideoLoaded",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "isVideoPaused",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "setVideoPaused",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_booleancls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "setVideoLoop",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_booleancls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "setVideoVolume",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_floatcls(), $rt_floatcls(), $rt_floatcls(), $rt_floatcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "html5VideoTexImage2D",
            modifiers : 768,
            accessLevel : 1,
            parameterTypes : [nleat_WebGL2RenderingContext, $rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls(), otjdh_HTMLVideoElement],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "html5VideoTexSubImage2D",
            modifiers : 768,
            accessLevel : 1,
            parameterTypes : [nleat_WebGL2RenderingContext, $rt_intcls(), $rt_intcls(), $rt_intcls(), otjdh_HTMLVideoElement],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "updateVideoTexture",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "bindVideoTexture",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getVideoWidth",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getVideoHeight",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getVideoCurrentTime",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_floatcls(),
            callable : null
        }, {
            name : "setVideoCurrentTime",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_floatcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getVideoDuration",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_floatcls(),
            callable : null
        }, {
            name : "getVideoError",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "setVideoFrameRate",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_floatcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "isImageSupported",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "loadImage",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "loadImage",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [jl_String, jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "setImagePointer",
            modifiers : 768,
            accessLevel : 1,
            parameterTypes : [jl_String, otjdh_HTMLImageElement],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "callImageLoadEvent",
            modifiers : 768,
            accessLevel : 1,
            parameterTypes : [jl_String, otjdh_HTMLImageElement],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "loadImage",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [jl_String, jl_String, jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "bufferImage",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [jl_String, $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "unloadImage",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "isImageLoaded",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "html5ImageTexImage2D",
            modifiers : 768,
            accessLevel : 1,
            parameterTypes : [nleat_WebGL2RenderingContext, $rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls(), otjdh_HTMLImageElement],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "html5ImageTexSubImage2D",
            modifiers : 768,
            accessLevel : 1,
            parameterTypes : [nleat_WebGL2RenderingContext, $rt_intcls(), $rt_intcls(), $rt_intcls(), otjdh_HTMLImageElement],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "updateImageTexture",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "bindImageTexture",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getImageWidth",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getImageHeight",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "setImageFrameRate",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_floatcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "mouseNext",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "mouseGetEventButton",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "mouseGetEventButtonState",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "mouseIsButtonDown",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "mouseGetEventDWheel",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "mouseSetCursorPosition",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "mouseSetGrabbed",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_booleancls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "mouseGetDX",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "mouseGetDY",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "mouseGetX",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "mouseGetY",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "mouseGetEventX",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "mouseGetEventY",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "keysNext",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "getEventKey",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getEventChar",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_charcls(),
            callable : null
        }, {
            name : "getEventKeyState",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "isKeyDown",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "getKeyName",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : jl_String,
            callable : null
        }, {
            name : "setFullscreen",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_booleancls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "shouldShutdown",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "commitContext",
            modifiers : 768,
            accessLevel : 1,
            parameterTypes : [otj_JSObject],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "updateDisplay",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "setVSyncEnabled",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_booleancls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "enableRepeatEvents",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_booleancls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "isPointerLocked",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "isFocused",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "getScreenWidth",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getScreenHeight",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getCanvasWidth",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getCanvasHeight",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "setDisplaySize",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "syncDisplay",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "saveScreenshot",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "saveScreenshot",
            modifiers : 768,
            accessLevel : 1,
            parameterTypes : [jl_String, otjdh_HTMLCanvasElement],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getRateLimitStatus",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : nlea_EaglerAdapterImpl2$RateLimit,
            callable : null
        }, {
            name : "logRateLimit",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [jl_String, nlea_EaglerAdapterImpl2$RateLimit],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "checkRateLimitHistory",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : nlea_EaglerAdapterImpl2$RateLimit,
            callable : null
        }, {
            name : "connectWebSocket",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : jl_String,
            callable : null
        }, {
            name : "connectWebSocket",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [jl_String, oti_AsyncCallback],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "startConnection",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "endConnection",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "connectionOpen",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "nativeBinarySend",
            modifiers : 768,
            accessLevel : 1,
            parameterTypes : [otjw_WebSocket, otjt_ArrayBuffer],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "writePacket",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls())],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "readPacket",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_arraycls($rt_bytecls()),
            callable : null
        }, {
            name : "loadLocalStorage",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_arraycls($rt_bytecls()),
            callable : null
        }, {
            name : "saveLocalStorage",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [jl_String, $rt_arraycls($rt_bytecls())],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "openLink",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "redirectTo",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "execute",
            modifiers : 768,
            accessLevel : 1,
            parameterTypes : [jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "onBeforeCloseRegister",
            modifiers : 768,
            accessLevel : 1,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "openFileChooser",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [jl_String, jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getFileChooserResult",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_arraycls($rt_bytecls()),
            callable : null
        }, {
            name : "getFileChooserResult0",
            modifiers : 768,
            accessLevel : 1,
            parameterTypes : [],
            returnType : otjt_ArrayBuffer,
            callable : null
        }, {
            name : "getFileChooserResultName",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "setListenerPos",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_floatcls(), $rt_floatcls(), $rt_floatcls(), $rt_floatcls(), $rt_floatcls(), $rt_floatcls(), $rt_floatcls(), $rt_floatcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "setPlaybackOffsetDelay",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_floatcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "decodeAudioAsync",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [otjt_ArrayBuffer],
            returnType : otjw_AudioBuffer,
            callable : null
        }, {
            name : "decodeAudioAsync",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [otjt_ArrayBuffer, oti_AsyncCallback],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getBufferFor",
            modifiers : 516,
            accessLevel : 1,
            parameterTypes : [jl_String],
            returnType : otjw_AudioBuffer,
            callable : null
        }, {
            name : "beginPlayback",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [jl_String, $rt_floatcls(), $rt_floatcls(), $rt_floatcls(), $rt_floatcls(), $rt_floatcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "beginPlaybackStatic",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [jl_String, $rt_floatcls(), $rt_floatcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "setPitch",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_floatcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "setVolume",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_floatcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "moveSound",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_floatcls(), $rt_floatcls(), $rt_floatcls(), $rt_floatcls(), $rt_floatcls(), $rt_floatcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "endSound",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "isPlaying",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "openConsole",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "voiceConnect",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "voiceVolume",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_floatcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "voiceActive",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "voiceRelayed",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "voiceUsers",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_arraycls(jl_String),
            callable : null
        }, {
            name : "voiceUsersTalking",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_arraycls(jl_String),
            callable : null
        }, {
            name : "voiceEnd",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "doJavascriptCoroutines",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "maxMemory",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_longcls(),
            callable : null
        }, {
            name : "totalMemory",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_longcls(),
            callable : null
        }, {
            name : "freeMemory",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_longcls(),
            callable : null
        }, {
            name : "exit",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getUserAgent",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "_wArrayByteLength",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "_wCreateLowLevelIntBuffer",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : jl_Object,
            callable : null
        }, {
            name : "_wAppendLowLevelBuffer",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "_wGetLowLevelBuffersAppended",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_Object,
            callable : null
        }, {
            name : "remapKey",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getClipboard",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "getClipboard",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [oti_AsyncCallback],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getClipboard0",
            modifiers : 768,
            accessLevel : 1,
            parameterTypes : [nlea_EaglerAdapterImpl2$StupidFunctionResolveString],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "setClipboard",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "isString",
            modifiers : 768,
            accessLevel : 1,
            parameterTypes : [otj_JSObject],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "openQuery",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [jl_String, jl_String],
            returnType : nle_ServerQuery,
            callable : null
        }, {
            name : "setServerToJoinOnLaunch",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getServerToJoinOnLaunch",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "access$002",
            modifiers : 544,
            accessLevel : 0,
            parameterTypes : [$rt_arraycls($rt_bytecls())],
            returnType : $rt_arraycls($rt_bytecls()),
            callable : null
        }, {
            name : "access$000",
            modifiers : 544,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_arraycls($rt_bytecls()),
            callable : null
        }, {
            name : "access$100",
            modifiers : 544,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_arraycls($rt_booleancls()),
            callable : null
        }, {
            name : "access$200",
            modifiers : 544,
            accessLevel : 0,
            parameterTypes : [],
            returnType : ju_LinkedList,
            callable : null
        }, {
            name : "access$302",
            modifiers : 544,
            accessLevel : 0,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "access$400",
            modifiers : 544,
            accessLevel : 0,
            parameterTypes : [otjde_MouseEvent],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "access$502",
            modifiers : 544,
            accessLevel : 0,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "access$600",
            modifiers : 544,
            accessLevel : 0,
            parameterTypes : [otjde_MouseEvent],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "access$700",
            modifiers : 544,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_doublecls(),
            callable : null
        }, {
            name : "access$702",
            modifiers : 544,
            accessLevel : 0,
            parameterTypes : [$rt_doublecls()],
            returnType : $rt_doublecls(),
            callable : null
        }, {
            name : "access$800",
            modifiers : 544,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_doublecls(),
            callable : null
        }, {
            name : "access$802",
            modifiers : 544,
            accessLevel : 0,
            parameterTypes : [$rt_doublecls()],
            returnType : $rt_doublecls(),
            callable : null
        }, {
            name : "access$900",
            modifiers : 544,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_arraycls($rt_booleancls()),
            callable : null
        }, {
            name : "access$1000",
            modifiers : 544,
            accessLevel : 0,
            parameterTypes : [otjde_KeyboardEvent],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "access$1100",
            modifiers : 544,
            accessLevel : 0,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "access$1200",
            modifiers : 544,
            accessLevel : 0,
            parameterTypes : [],
            returnType : ju_LinkedList,
            callable : null
        }, {
            name : "access$1300",
            modifiers : 544,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "access$1402",
            modifiers : 544,
            accessLevel : 0,
            parameterTypes : [$rt_booleancls()],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "access$1500",
            modifiers : 544,
            accessLevel : 0,
            parameterTypes : [],
            returnType : ju_HashMap,
            callable : null
        }, {
            name : "access$1604",
            modifiers : 544,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "access$1700",
            modifiers : 544,
            accessLevel : 0,
            parameterTypes : [],
            returnType : otjdh_HTMLCanvasElement,
            callable : null
        }, {
            name : "access$1702",
            modifiers : 544,
            accessLevel : 0,
            parameterTypes : [otjdh_HTMLCanvasElement],
            returnType : otjdh_HTMLCanvasElement,
            callable : null
        }, {
            name : "access$1800",
            modifiers : 544,
            accessLevel : 0,
            parameterTypes : [],
            returnType : otjc_CanvasRenderingContext2D,
            callable : null
        }, {
            name : "access$1802",
            modifiers : 544,
            accessLevel : 0,
            parameterTypes : [otjc_CanvasRenderingContext2D],
            returnType : otjc_CanvasRenderingContext2D,
            callable : null
        }, {
            name : "access$1900",
            modifiers : 544,
            accessLevel : 0,
            parameterTypes : [jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "access$2002",
            modifiers : 544,
            accessLevel : 0,
            parameterTypes : [$rt_booleancls()],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "access$2100",
            modifiers : 544,
            accessLevel : 0,
            parameterTypes : [],
            returnType : otjdh_HTMLVideoElement,
            callable : null
        }, {
            name : "access$2200",
            modifiers : 544,
            accessLevel : 0,
            parameterTypes : [jl_String, otjdh_HTMLVideoElement],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "access$2302",
            modifiers : 544,
            accessLevel : 0,
            parameterTypes : [$rt_booleancls()],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "access$2400",
            modifiers : 544,
            accessLevel : 0,
            parameterTypes : [],
            returnType : otjdh_HTMLImageElement,
            callable : null
        }, {
            name : "access$2500",
            modifiers : 544,
            accessLevel : 0,
            parameterTypes : [jl_String, otjdh_HTMLImageElement],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "access$2602",
            modifiers : 544,
            accessLevel : 0,
            parameterTypes : [$rt_booleancls()],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "access$2702",
            modifiers : 544,
            accessLevel : 0,
            parameterTypes : [$rt_booleancls()],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "access$2802",
            modifiers : 544,
            accessLevel : 0,
            parameterTypes : [$rt_booleancls()],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "access$2900",
            modifiers : 544,
            accessLevel : 0,
            parameterTypes : [],
            returnType : ju_LinkedList,
            callable : null
        }, {
            name : "access$3002",
            modifiers : 544,
            accessLevel : 0,
            parameterTypes : [otjw_WebSocket],
            returnType : otjw_WebSocket,
            callable : null
        }, {
            name : "access$2600",
            modifiers : 544,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "access$3100",
            modifiers : 544,
            accessLevel : 0,
            parameterTypes : [],
            returnType : nlea_EaglerAdapterImpl2$RateLimit,
            callable : null
        }, {
            name : "access$3200",
            modifiers : 544,
            accessLevel : 0,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "access$3300",
            modifiers : 544,
            accessLevel : 0,
            parameterTypes : [],
            returnType : ju_Set,
            callable : null
        }, {
            name : "access$3102",
            modifiers : 544,
            accessLevel : 0,
            parameterTypes : [nlea_EaglerAdapterImpl2$RateLimit],
            returnType : nlea_EaglerAdapterImpl2$RateLimit,
            callable : null
        }, {
            name : "access$3400",
            modifiers : 544,
            accessLevel : 0,
            parameterTypes : [],
            returnType : ju_Set,
            callable : null
        }, {
            name : "access$2700",
            modifiers : 544,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "access$3500",
            modifiers : 544,
            accessLevel : 0,
            parameterTypes : [otj_JSObject],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "access$3000",
            modifiers : 544,
            accessLevel : 0,
            parameterTypes : [],
            returnType : otjw_WebSocket,
            callable : null
        }, {
            name : "access$3900",
            modifiers : 544,
            accessLevel : 0,
            parameterTypes : [],
            returnType : ju_HashMap,
            callable : null
        }, {
            name : "access$4302",
            modifiers : 544,
            accessLevel : 0,
            parameterTypes : [$rt_booleancls()],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "<clinit>",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "startTitleMusic$js_body$_1",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [otj_JSObject],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "stopTitleMusic$js_body$_2",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "volumeTitleMusic$js_body$_3",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [otj_JSObject],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "playingTitleMusic$js_body$_4",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "getSelfProxy$js_body$_8",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "getCustomProxyListString$js_body$_9",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "getHostString$js_body$_11",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "getLocationString$js_body$_12",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "setContextVar$js_body$_20",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "setDebugVar$js_body$_21",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [otj_JSObject, otj_JSObject],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "hasBeenActive$js_body$_22",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "getString$js_body$_24",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "getOffsetX$js_body$_26",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "getOffsetY$js_body$_27",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "getWhich$js_body$_28",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "youEagler$js_body$_32",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "__wglGetTexParameteri$js_body$_120",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [otj_JSObject, otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "__wglGetTexParameterf$js_body$_122",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [otj_JSObject, otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "getDataURL$js_body$_125",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [otj_JSObject, otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "freeDataURL$js_body$_126",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [otj_JSObject],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "setVideoPointer$js_body$_133",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [otj_JSObject, otj_JSObject],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "callVideoLoadEvent$js_body$_134",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [otj_JSObject, otj_JSObject],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "html5VideoTexImage2D$js_body$_143",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "html5VideoTexSubImage2D$js_body$_144",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "setImagePointer$js_body$_157",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [otj_JSObject, otj_JSObject],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "callImageLoadEvent$js_body$_158",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [otj_JSObject, otj_JSObject],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "html5ImageTexImage2D$js_body$_163",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "html5ImageTexSubImage2D$js_body$_164",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject, otj_JSObject],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "commitContext$js_body$_191",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "isPointerLocked$js_body$_195",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "saveScreenshot$js_body$_204",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [otj_JSObject, otj_JSObject],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "nativeBinarySend$js_body$_213",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [otj_JSObject, otj_JSObject],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "execute$js_body$_220",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [otj_JSObject],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "onBeforeCloseRegister$js_body$_221",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "onWindowUnload$jsocb$_1",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "openFileChooser$js_body$_222",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [otj_JSObject, otj_JSObject],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getFileChooserResult0$js_body$_224",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "getFileChooserResultName$js_body$_225",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "getUserAgent$js_body$_251",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "getClipboard0$js_body$_259",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [otj_JSObject],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "setClipboard$js_body$_260",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [otj_JSObject],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "isString$js_body$_261",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }];
    nlea_EaglerAdapterImpl2$2.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "handleEvent",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [otjde_MouseEvent],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "handleEvent",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [otjde_Event],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "handleEvent$exported$0",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }];
    otjde_EventListener.$meta.methods = [
        {
            name : "handleEvent",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [otjde_Event],
            returnType : $rt_voidcls(),
            callable : null
        }];
    nlea_EaglerAdapterImpl2$3.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "handleEvent",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [otjde_MouseEvent],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "handleEvent",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [otjde_Event],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "handleEvent$exported$0",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }];
    nlea_EaglerAdapterImpl2$4.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "handleEvent",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [otjde_MouseEvent],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "handleEvent",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [otjde_Event],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "handleEvent$exported$0",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }];
    nlea_EaglerAdapterImpl2$5.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "handleEvent",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [otjde_MouseEvent],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "handleEvent",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [otjde_Event],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "handleEvent$exported$0",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }];
    nlea_EaglerAdapterImpl2$6.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "handleEvent",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [otjde_KeyboardEvent],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "handleEvent",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [otjde_Event],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "handleEvent$exported$0",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }];
    nlea_EaglerAdapterImpl2$7.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "handleEvent",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [otjde_KeyboardEvent],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "handleEvent",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [otjde_Event],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "handleEvent$exported$0",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }];
    nlea_EaglerAdapterImpl2$8.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "handleEvent",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [otjde_KeyboardEvent],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "handleEvent",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [otjde_Event],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "handleEvent$exported$0",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }];
    nlea_EaglerAdapterImpl2$9.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "handleEvent",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [otjde_WheelEvent],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "handleEvent",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [otjde_Event],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "handleEvent$exported$0",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }];
    nlea_EaglerAdapterImpl2$10.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "handleEvent",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [otjde_WheelEvent],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "handleEvent",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [otjde_Event],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "handleEvent$exported$0",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }];
    nlea_EaglerAdapterImpl2$11.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "handleEvent",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [otjde_WheelEvent],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "handleEvent",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [otjde_Event],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "handleEvent$exported$0",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }];
    otpp_AsyncCallbackWrapper.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [oti_AsyncCallback],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "create",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [oti_AsyncCallback],
            returnType : otpp_AsyncCallbackWrapper,
            callable : null
        }, {
            name : "complete",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "error",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Throwable],
            returnType : $rt_voidcls(),
            callable : null
        }];
    oti_AsyncCallback.$meta.methods = [
        {
            name : "complete",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "error",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [jl_Throwable],
            returnType : $rt_voidcls(),
            callable : null
        }];
    ju_LinkedList.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [ju_Collection],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "size",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "clear",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "listIterator",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : ju_ListIterator,
            callable : null
        }, {
            name : "listIterator",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : ju_ListIterator,
            callable : null
        }, {
            name : "offer",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "remove",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_Object,
            callable : null
        }, {
            name : "poll",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_Object,
            callable : null
        }, {
            name : "element",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_Object,
            callable : null
        }, {
            name : "peek",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_Object,
            callable : null
        }, {
            name : "addFirst",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "addLast",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "offerFirst",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "offerLast",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "removeFirst",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_Object,
            callable : null
        }, {
            name : "removeLast",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_Object,
            callable : null
        }, {
            name : "pollFirst",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_Object,
            callable : null
        }, {
            name : "pollLast",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_Object,
            callable : null
        }, {
            name : "getFirst",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_Object,
            callable : null
        }, {
            name : "getLast",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_Object,
            callable : null
        }, {
            name : "peekFirst",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_Object,
            callable : null
        }, {
            name : "peekLast",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_Object,
            callable : null
        }, {
            name : "removeFirstOccurrence",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "removeLastOccurrence",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "push",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "pop",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_Object,
            callable : null
        }, {
            name : "descendingIterator",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : ju_Iterator,
            callable : null
        }, {
            name : "removeEntry",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [ju_LinkedList$Entry],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "access$100",
            modifiers : 544,
            accessLevel : 0,
            parameterTypes : [ju_LinkedList, ju_LinkedList$Entry],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "access$202",
            modifiers : 544,
            accessLevel : 0,
            parameterTypes : [ju_LinkedList, ju_LinkedList$Entry],
            returnType : ju_LinkedList$Entry,
            callable : null
        }, {
            name : "access$302",
            modifiers : 544,
            accessLevel : 0,
            parameterTypes : [ju_LinkedList, ju_LinkedList$Entry],
            returnType : ju_LinkedList$Entry,
            callable : null
        }, {
            name : "access$404",
            modifiers : 544,
            accessLevel : 0,
            parameterTypes : [ju_LinkedList],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "access$300",
            modifiers : 544,
            accessLevel : 0,
            parameterTypes : [ju_LinkedList],
            returnType : ju_LinkedList$Entry,
            callable : null
        }];
    ju_AbstractSequentialList.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "get",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : jl_Object,
            callable : null
        }, {
            name : "set",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_Object],
            returnType : jl_Object,
            callable : null
        }, {
            name : "add",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_Object],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "remove",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : jl_Object,
            callable : null
        }, {
            name : "addAll",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), ju_Collection],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "iterator",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : ju_Iterator,
            callable : null
        }, {
            name : "listIterator",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : ju_ListIterator,
            callable : null
        }];
    ju_AbstractList.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "add",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "iterator",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : ju_Iterator,
            callable : null
        }, {
            name : "addAll",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), ju_Collection],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "set",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_Object],
            returnType : jl_Object,
            callable : null
        }, {
            name : "add",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_Object],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "remove",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : jl_Object,
            callable : null
        }, {
            name : "indexOf",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "lastIndexOf",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "clear",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "listIterator",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : ju_ListIterator,
            callable : null
        }, {
            name : "listIterator",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : ju_ListIterator,
            callable : null
        }, {
            name : "subList",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : ju_List,
            callable : null
        }, {
            name : "removeRange",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "hashCode",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "equals",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_booleancls(),
            callable : null
        }];
    ju_AbstractCollection.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "isEmpty",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "contains",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "toArray",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_arraycls(jl_Object),
            callable : null
        }, {
            name : "toArray",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls(jl_Object)],
            returnType : $rt_arraycls(jl_Object),
            callable : null
        }, {
            name : "add",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "remove",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "containsAll",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [ju_Collection],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "addAll",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [ju_Collection],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "removeAll",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [ju_Collection],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "retainAll",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [ju_Collection],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "clear",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "toString",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }];
    ju_Collection.$meta.methods = [
        {
            name : "size",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "isEmpty",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "contains",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "toArray",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_arraycls(jl_Object),
            callable : null
        }, {
            name : "toArray",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls(jl_Object)],
            returnType : $rt_arraycls(jl_Object),
            callable : null
        }, {
            name : "add",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "remove",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "containsAll",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [ju_Collection],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "addAll",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [ju_Collection],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "removeAll",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [ju_Collection],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "retainAll",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [ju_Collection],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "clear",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "spliterator",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : ju_Spliterator,
            callable : null
        }, {
            name : "stream",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jus_Stream,
            callable : null
        }];
    jl_Iterable.$meta.methods = [
        {
            name : "iterator",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : ju_Iterator,
            callable : null
        }, {
            name : "forEach",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [juf_Consumer],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "spliterator",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : ju_Spliterator,
            callable : null
        }];
    ju_List.$meta.methods = [
        {
            name : "addAll",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), ju_Collection],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "get",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : jl_Object,
            callable : null
        }, {
            name : "set",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_Object],
            returnType : jl_Object,
            callable : null
        }, {
            name : "add",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_Object],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "remove",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : jl_Object,
            callable : null
        }, {
            name : "indexOf",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "lastIndexOf",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "listIterator",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : ju_ListIterator,
            callable : null
        }, {
            name : "listIterator",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : ju_ListIterator,
            callable : null
        }, {
            name : "subList",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : ju_List,
            callable : null
        }, {
            name : "replaceAll",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [juf_UnaryOperator],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "sort",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [ju_Comparator],
            returnType : $rt_voidcls(),
            callable : null
        }];
    ju_Deque.$meta.methods = [
        {
            name : "addFirst",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "addLast",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "offerFirst",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "offerLast",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "removeFirst",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_Object,
            callable : null
        }, {
            name : "removeLast",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_Object,
            callable : null
        }, {
            name : "pollFirst",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_Object,
            callable : null
        }, {
            name : "pollLast",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_Object,
            callable : null
        }, {
            name : "getFirst",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_Object,
            callable : null
        }, {
            name : "getLast",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_Object,
            callable : null
        }, {
            name : "peekFirst",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_Object,
            callable : null
        }, {
            name : "peekLast",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_Object,
            callable : null
        }, {
            name : "removeFirstOccurrence",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "removeLastOccurrence",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "push",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "pop",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_Object,
            callable : null
        }, {
            name : "descendingIterator",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : ju_Iterator,
            callable : null
        }];
    ju_Queue.$meta.methods = [
        {
            name : "offer",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "remove",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_Object,
            callable : null
        }, {
            name : "poll",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_Object,
            callable : null
        }, {
            name : "element",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_Object,
            callable : null
        }, {
            name : "peek",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_Object,
            callable : null
        }];
    otjw_AudioContext.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getDestination",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : otjw_AudioDestinationNode,
            callable : null
        }, {
            name : "getSampleRate",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_floatcls(),
            callable : null
        }, {
            name : "getCurrentTime",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_doublecls(),
            callable : null
        }, {
            name : "getListener",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : otjw_AudioListener,
            callable : null
        }, {
            name : "getState",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "setOnStateChange",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [otjde_EventListener],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getOnStateChange",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : otjde_EventListener,
            callable : null
        }, {
            name : "suspend",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "resume",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "close",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "createBuffer",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls(), $rt_floatcls()],
            returnType : otjw_AudioBuffer,
            callable : null
        }, {
            name : "decodeAudioData",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [otjt_ArrayBuffer, otjw_DecodeSuccessCallback, otjw_DecodeErrorCallback],
            returnType : otjw_AudioBuffer,
            callable : null
        }, {
            name : "decodeAudioData",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [otjt_ArrayBuffer, otjw_DecodeSuccessCallback],
            returnType : otjw_AudioBuffer,
            callable : null
        }, {
            name : "decodeAudioData",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [otjt_ArrayBuffer],
            returnType : otjw_AudioBuffer,
            callable : null
        }, {
            name : "createBufferSource",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : otjw_AudioBufferSourceNode,
            callable : null
        }, {
            name : "createMediaElementSource",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [otjdh_HTMLMediaElement],
            returnType : otjw_MediaElementAudioSourceNode,
            callable : null
        }, {
            name : "createMediaStreamSource",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [otjw_MediaStream],
            returnType : otjw_MediaStreamAudioSourceNode,
            callable : null
        }, {
            name : "createMediaStreamDestination",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : otjw_MediaStreamAudioDestinationNode,
            callable : null
        }, {
            name : "createAudioWorker",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : otjw_AudioWorker,
            callable : null
        }, {
            name : "createScriptProcessor",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls(), $rt_intcls()],
            returnType : otjw_ScriptProcessorNode,
            callable : null
        }, {
            name : "createScriptProcessor",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : otjw_ScriptProcessorNode,
            callable : null
        }, {
            name : "createScriptProcessor",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : otjw_ScriptProcessorNode,
            callable : null
        }, {
            name : "createScriptProcessor",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : otjw_ScriptProcessorNode,
            callable : null
        }, {
            name : "createAnalyser",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : otjw_AnalyserNode,
            callable : null
        }, {
            name : "createGain",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : otjw_GainNode,
            callable : null
        }, {
            name : "createDelay",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_doublecls()],
            returnType : otjw_DelayNode,
            callable : null
        }, {
            name : "createDelay",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : otjw_DelayNode,
            callable : null
        }, {
            name : "createBiquadFilter",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : otjw_BiquadFilterNode,
            callable : null
        }, {
            name : "createIIRFilter",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [otjt_Float32Array, otjt_Float32Array],
            returnType : otjw_IIRFilterNode,
            callable : null
        }, {
            name : "createWaveShaper",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : otjw_WaveShaperNode,
            callable : null
        }, {
            name : "createPanner",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : otjw_PannerNode,
            callable : null
        }, {
            name : "createStereoPanner",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : otjw_StereoPannerNode,
            callable : null
        }, {
            name : "createConvolver",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : otjw_ConvolverNode,
            callable : null
        }, {
            name : "createChannelSplitter",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : otjw_ChannelSplitterNode,
            callable : null
        }, {
            name : "createChannelSplitter",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : otjw_ChannelSplitterNode,
            callable : null
        }, {
            name : "createChannelMerger",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : otjw_ChannelMergerNode,
            callable : null
        }, {
            name : "createChannelMerger",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : otjw_ChannelMergerNode,
            callable : null
        }, {
            name : "createDynamicsCompressor",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : otjw_DynamicsCompressorNode,
            callable : null
        }, {
            name : "createOscillator",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : otjw_OscillatorNode,
            callable : null
        }, {
            name : "createPeriodicWave",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [otjt_Float32Array, otjt_Float32Array, otjw_PeriodicWaveConstraints],
            returnType : otjw_PeriodicWave,
            callable : null
        }, {
            name : "createPeriodicWave",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_floatcls()), $rt_arraycls($rt_floatcls()), otjw_PeriodicWaveConstraints],
            returnType : otjw_PeriodicWave,
            callable : null
        }, {
            name : "createPeriodicWave",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [otjt_Float32Array, otjt_Float32Array],
            returnType : otjw_PeriodicWave,
            callable : null
        }, {
            name : "createPeriodicWave",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_floatcls()), $rt_arraycls($rt_floatcls())],
            returnType : otjw_PeriodicWave,
            callable : null
        }, {
            name : "create",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [],
            returnType : otjw_AudioContext,
            callable : null
        }, {
            name : "<init>$static",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [otjw_AudioContext],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "create$js_body$_44",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [],
            returnType : otj_JSObject,
            callable : null
        }];
    nlea_EaglerAdapterImpl2$12.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "onTimer",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "onTimer$exported$0",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [],
            returnType : otj_JSObject,
            callable : null
        }];
    otjb_TimerHandler.$meta.methods = [
        {
            name : "onTimer",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }];
    ji_IOException.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String, jl_Throwable],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Throwable],
            returnType : $rt_voidcls(),
            callable : null
        }];
    nle_LocalStorageManager.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "loadStorage",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "saveStorageA",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "saveStorageG",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "saveStorageP",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "dumpConfiguration",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "hasMadeAchievement",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [nms_Achievement],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "<clinit>",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }];
    nms_NBTTagCompound.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "write",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [ji_DataOutput],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "load",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [ji_DataInput],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getTags",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : ju_Collection,
            callable : null
        }, {
            name : "getId",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_bytecls(),
            callable : null
        }, {
            name : "setTag",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String, nms_NBTBase],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "setByte",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String, $rt_bytecls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "setShort",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String, $rt_shortcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "setInteger",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String, $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "setLong",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String, $rt_longcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "setFloat",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String, $rt_floatcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "setDouble",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String, $rt_doublecls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "setString",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String, jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "setByteArray",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String, $rt_arraycls($rt_bytecls())],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "setIntArray",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String, $rt_arraycls($rt_intcls())],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "setCompoundTag",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String, nms_NBTTagCompound],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "setBoolean",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String, $rt_booleancls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getTag",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : nms_NBTBase,
            callable : null
        }, {
            name : "hasKey",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "getByte",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_bytecls(),
            callable : null
        }, {
            name : "getShort",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_shortcls(),
            callable : null
        }, {
            name : "getInteger",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getLong",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_longcls(),
            callable : null
        }, {
            name : "getFloat",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_floatcls(),
            callable : null
        }, {
            name : "getDouble",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_doublecls(),
            callable : null
        }, {
            name : "getString",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : jl_String,
            callable : null
        }, {
            name : "getByteArray",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_arraycls($rt_bytecls()),
            callable : null
        }, {
            name : "getIntArray",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_arraycls($rt_intcls()),
            callable : null
        }, {
            name : "getCompoundTag",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : nms_NBTTagCompound,
            callable : null
        }, {
            name : "getTagList",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : nms_NBTTagList,
            callable : null
        }, {
            name : "getBoolean",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "removeTag",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "toString",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "hasNoTags",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "copy",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : nms_NBTBase,
            callable : null
        }, {
            name : "equals",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "hashCode",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getTagMap",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [nms_NBTTagCompound],
            returnType : ju_Map,
            callable : null
        }, {
            name : "getStringOrNull",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : jl_String,
            callable : null
        }];
    nms_NBTBase.$meta.methods = [
        {
            name : "write",
            modifiers : 1,
            accessLevel : 0,
            parameterTypes : [ji_DataOutput],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "load",
            modifiers : 1,
            accessLevel : 0,
            parameterTypes : [ji_DataInput],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getId",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_bytecls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "setName",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : nms_NBTBase,
            callable : null
        }, {
            name : "getName",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "readNamedTag",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [ji_DataInput],
            returnType : nms_NBTBase,
            callable : null
        }, {
            name : "writeNamedTag",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [nms_NBTBase, ji_DataOutput],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "newTag",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_bytecls(), jl_String],
            returnType : nms_NBTBase,
            callable : null
        }, {
            name : "getTagName",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_bytecls()],
            returnType : jl_String,
            callable : null
        }, {
            name : "copy",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : nms_NBTBase,
            callable : null
        }, {
            name : "equals",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "hashCode",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "<clinit>",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }];
    nms_ServerList.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [nmc_Minecraft],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "loadDefaultServers",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "loadServerList",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "saveServerList",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getServerData",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : nms_ServerData,
            callable : null
        }, {
            name : "removeServerData",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "addServerData",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [nms_ServerData],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "countServers",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "swapServers",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "freeServerIcons",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "refreshServerPing",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "updateServerPing",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<clinit>",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }];
    nms_NBTTagList.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "write",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [ji_DataOutput],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "load",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [ji_DataInput],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getId",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_bytecls(),
            callable : null
        }, {
            name : "toString",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "appendTag",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [nms_NBTBase],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "removeTag",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : nms_NBTBase,
            callable : null
        }, {
            name : "tagAt",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : nms_NBTBase,
            callable : null
        }, {
            name : "tagCount",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "copy",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : nms_NBTBase,
            callable : null
        }, {
            name : "equals",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "hashCode",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }];
    ji_PrintStream.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [ji_OutputStream, $rt_booleancls(), jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [ji_OutputStream, $rt_booleancls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [ji_OutputStream],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "checkError",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "setError",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "clearError",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "write",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "write",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls()), $rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "close",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "flush",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "check",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "print",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_charcls())],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "print",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [$rt_arraycls($rt_charcls()), $rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "print",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_charcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "print",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "print",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_longcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "print",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_doublecls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "print",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "print",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "println",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "println",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_longcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "println",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_doublecls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "println",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "println",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "println",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "printSB",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }];
    ji_FilterOutputStream.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [ji_OutputStream],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "write",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "close",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "flush",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }];
    ji_OutputStream.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "write",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "write",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls())],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "write",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls()), $rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "close",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "flush",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }];
    ji_Closeable.$meta.methods = [
        {
            name : "close",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }];
    jl_AutoCloseable.$meta.methods = [
        {
            name : "close",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }];
    ji_Flushable.$meta.methods = [
        {
            name : "flush",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }];
    nmc_Minecraft.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "startTimerHackThread",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "setServer",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String, $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "startGame",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "showWarningText",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "showIntroAnimation",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "loadScreen",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "scaledTessellator",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getOs",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [],
            returnType : nms_EnumOS,
            callable : null
        }, {
            name : "displayGuiScreen",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [nms_GuiScreen],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "isChatOpen",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "getServerURI",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "checkGLError",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "shutdownMinecraftApplet",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "run",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "runGameLoop",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "func_90020_K",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "updateDebugProfilerName",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "displayDebugInfo",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [$rt_longcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "shutdown",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "setIngameFocus",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "setIngameNotInFocus",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "displayInGameMenu",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "sendClickBlockToController",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [$rt_intcls(), $rt_booleancls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "displayEaglercraftText",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "clickMouse",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "toggleFullscreen",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "resize",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "runTick",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "forceReload",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "loadWorld",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [nms_WorldClient],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "loadWorld",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [nms_WorldClient, jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "debugInfoRenders",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "getEntityDebug",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "getWorldProviderName",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "debugInfoEntities",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "setDimensionAndSpawnPlayer",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "setDemo",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [$rt_booleancls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "isDemo",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "getNetHandler",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : nms_NetClientHandler,
            callable : null
        }, {
            name : "isGuiEnabled",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "isFancyGraphicsEnabled",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "isAmbientOcclusionEnabled",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "handleClientCommand",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "clickMiddleMouseButton",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getMinecraft",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [],
            returnType : nmc_Minecraft,
            callable : null
        }, {
            name : "scheduleTexturePackRefresh",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "setServerData",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [nms_ServerData],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getServerData",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : nms_ServerData,
            callable : null
        }, {
            name : "isIntegratedServerRunning",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "isSingleplayer",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "getSystemTime",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_longcls(),
            callable : null
        }, {
            name : "isFullScreen",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "getGLMaximumTextureSize",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "<clinit>",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }];
    jl_Runnable.$meta.methods = [
        {
            name : "run",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }];
    jl_String$_clinit_$lambda$_81_0.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "compare",
            modifiers : 64,
            accessLevel : 3,
            parameterTypes : [jl_Object, jl_Object],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "compare",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String, jl_String],
            returnType : $rt_intcls(),
            callable : null
        }];
    ju_Comparator.$meta.methods = [
        {
            name : "compare",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [jl_Object, jl_Object],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "reversed",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : ju_Comparator,
            callable : null
        }, {
            name : "thenComparing",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [ju_Comparator],
            returnType : ju_Comparator,
            callable : null
        }, {
            name : "thenComparing",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [juf_Function, ju_Comparator],
            returnType : ju_Comparator,
            callable : null
        }, {
            name : "thenComparing",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [juf_Function],
            returnType : ju_Comparator,
            callable : null
        }, {
            name : "thenComparingInt",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [juf_ToIntFunction],
            returnType : ju_Comparator,
            callable : null
        }, {
            name : "thenComparingLong",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [juf_ToLongFunction],
            returnType : ju_Comparator,
            callable : null
        }, {
            name : "thenComparingDouble",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [juf_ToDoubleFunction],
            returnType : ju_Comparator,
            callable : null
        }, {
            name : "comparing",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [juf_Function, ju_Comparator],
            returnType : ju_Comparator,
            callable : null
        }, {
            name : "comparing",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [juf_Function],
            returnType : ju_Comparator,
            callable : null
        }, {
            name : "naturalOrder",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [],
            returnType : ju_Comparator,
            callable : null
        }, {
            name : "reverseOrder",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [],
            returnType : ju_Comparator,
            callable : null
        }, {
            name : "nullsFirst",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [ju_Comparator],
            returnType : ju_Comparator,
            callable : null
        }, {
            name : "nullsLast",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [ju_Comparator],
            returnType : ju_Comparator,
            callable : null
        }, {
            name : "comparingInt",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [juf_ToIntFunction],
            returnType : ju_Comparator,
            callable : null
        }, {
            name : "comparingLong",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [juf_ToLongFunction],
            returnType : ju_Comparator,
            callable : null
        }, {
            name : "comparingDouble",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [juf_ToDoubleFunction],
            returnType : ju_Comparator,
            callable : null
        }, {
            name : "lambda$comparingDouble$14",
            modifiers : 544,
            accessLevel : 1,
            parameterTypes : [juf_ToDoubleFunction, jl_Object, jl_Object],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "lambda$comparingLong$13",
            modifiers : 544,
            accessLevel : 1,
            parameterTypes : [juf_ToLongFunction, jl_Object, jl_Object],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "lambda$comparingInt$12",
            modifiers : 544,
            accessLevel : 1,
            parameterTypes : [juf_ToIntFunction, jl_Object, jl_Object],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "lambda$nullsLast$11",
            modifiers : 544,
            accessLevel : 1,
            parameterTypes : [ju_Comparator, jl_Object, jl_Object],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "lambda$nullsFirst$10",
            modifiers : 544,
            accessLevel : 1,
            parameterTypes : [ju_Comparator, jl_Object, jl_Object],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "lambda$reverseOrder$9",
            modifiers : 544,
            accessLevel : 1,
            parameterTypes : [jl_Comparable, jl_Comparable],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "lambda$naturalOrder$8",
            modifiers : 544,
            accessLevel : 1,
            parameterTypes : [jl_Comparable, jl_Comparable],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "lambda$comparing$7",
            modifiers : 544,
            accessLevel : 1,
            parameterTypes : [juf_Function, jl_Object, jl_Object],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "lambda$comparing$6",
            modifiers : 544,
            accessLevel : 1,
            parameterTypes : [ju_Comparator, juf_Function, jl_Object, jl_Object],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "lambda$thenComparingDouble$5",
            modifiers : 32,
            accessLevel : 1,
            parameterTypes : [juf_ToDoubleFunction, jl_Object, jl_Object],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "lambda$thenComparingLong$4",
            modifiers : 32,
            accessLevel : 1,
            parameterTypes : [juf_ToLongFunction, jl_Object, jl_Object],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "lambda$thenComparingInt$3",
            modifiers : 32,
            accessLevel : 1,
            parameterTypes : [juf_ToIntFunction, jl_Object, jl_Object],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "lambda$thenComparing$2",
            modifiers : 32,
            accessLevel : 1,
            parameterTypes : [juf_Function, jl_Object, jl_Object],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "lambda$thenComparing$1",
            modifiers : 32,
            accessLevel : 1,
            parameterTypes : [ju_Comparator, jl_Object, jl_Object],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "lambda$reversed$0",
            modifiers : 32,
            accessLevel : 1,
            parameterTypes : [jl_Object, jl_Object],
            returnType : $rt_intcls(),
            callable : null
        }];
    otci_IntegerUtil.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "toUnsignedLogRadixString",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : jl_String,
            callable : null
        }, {
            name : "toUnsignedLogRadixString",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_longcls(), $rt_intcls()],
            returnType : jl_String,
            callable : null
        }];
    otjt_ArrayBuffer.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getByteLength",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "slice",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : otjt_ArrayBuffer,
            callable : null
        }, {
            name : "create",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : otjt_ArrayBuffer,
            callable : null
        }, {
            name : "<init>$static",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [otjt_ArrayBuffer],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "create$js_body$_3",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }];
    otjt_Uint8Array.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "get",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_shortcls(),
            callable : null
        }, {
            name : "set",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_shortcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "create",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : otjt_Uint8Array,
            callable : null
        }, {
            name : "create",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [otjt_ArrayBuffer],
            returnType : otjt_Uint8Array,
            callable : null
        }, {
            name : "create",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [otjt_ArrayBufferView],
            returnType : otjt_Uint8Array,
            callable : null
        }, {
            name : "create",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [otjt_ArrayBuffer, $rt_intcls(), $rt_intcls()],
            returnType : otjt_Uint8Array,
            callable : null
        }, {
            name : "create",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [otjt_ArrayBuffer, $rt_intcls()],
            returnType : otjt_Uint8Array,
            callable : null
        }, {
            name : "<init>$static",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [otjt_Uint8Array],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "create$js_body$_3",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "create$js_body$_4",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "create$js_body$_5",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "create$js_body$_6",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [otj_JSObject, otj_JSObject, otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "create$js_body$_7",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [otj_JSObject, otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }];
    otjt_ArrayBufferView.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getLength",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getByteLength",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getByteOffset",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getBuffer",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : otjt_ArrayBuffer,
            callable : null
        }, {
            name : "set",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [otjt_ArrayBufferView, $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "set",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [otjt_ArrayBufferView],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "set",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [otjc_JSArrayReader, $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "set",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [otjc_JSArrayReader],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "set",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls()), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "set",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls())],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "set",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_shortcls()), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "set",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_shortcls())],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "set",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_intcls()), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "set",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_intcls())],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "set",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_floatcls()), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "set",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_floatcls())],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "set",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_doublecls()), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "set",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_doublecls())],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>$static",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [otjt_ArrayBufferView],
            returnType : $rt_voidcls(),
            callable : null
        }];
    otjt_Float32Array.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "get",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_floatcls(),
            callable : null
        }, {
            name : "set",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_floatcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "create",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : otjt_Float32Array,
            callable : null
        }, {
            name : "create",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [otjt_ArrayBuffer],
            returnType : otjt_Float32Array,
            callable : null
        }, {
            name : "create",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [otjt_ArrayBufferView],
            returnType : otjt_Float32Array,
            callable : null
        }, {
            name : "create",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [otjt_ArrayBuffer, $rt_intcls(), $rt_intcls()],
            returnType : otjt_Float32Array,
            callable : null
        }, {
            name : "create",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [otjt_ArrayBuffer, $rt_intcls()],
            returnType : otjt_Float32Array,
            callable : null
        }, {
            name : "<init>$static",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [otjt_Float32Array],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "create$js_body$_3",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "create$js_body$_4",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "create$js_body$_5",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "create$js_body$_6",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [otj_JSObject, otj_JSObject, otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "create$js_body$_7",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [otj_JSObject, otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }];
    ju_HashMap.$meta.methods = [
        {
            name : "newElementArray",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_arraycls(ju_HashMap$HashEntry),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "calculateCapacity",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_floatcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [ju_Map],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "clear",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "clone",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_Object,
            callable : null
        }, {
            name : "computeThreshold",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "containsKey",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "containsValue",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "entrySet",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : ju_Set,
            callable : null
        }, {
            name : "get",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : jl_Object,
            callable : null
        }, {
            name : "getEntry",
            modifiers : 4,
            accessLevel : 0,
            parameterTypes : [jl_Object],
            returnType : ju_HashMap$HashEntry,
            callable : null
        }, {
            name : "findNonNullKeyEntry",
            modifiers : 4,
            accessLevel : 0,
            parameterTypes : [jl_Object, $rt_intcls(), $rt_intcls()],
            returnType : ju_HashMap$HashEntry,
            callable : null
        }, {
            name : "findNullKeyEntry",
            modifiers : 4,
            accessLevel : 0,
            parameterTypes : [],
            returnType : ju_HashMap$HashEntry,
            callable : null
        }, {
            name : "isEmpty",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "keySet",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : ju_Set,
            callable : null
        }, {
            name : "put",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Object, jl_Object],
            returnType : jl_Object,
            callable : null
        }, {
            name : "putImpl",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [jl_Object, jl_Object],
            returnType : jl_Object,
            callable : null
        }, {
            name : "createEntry",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [jl_Object, $rt_intcls(), jl_Object],
            returnType : ju_HashMap$HashEntry,
            callable : null
        }, {
            name : "createHashedEntry",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [jl_Object, $rt_intcls(), $rt_intcls()],
            returnType : ju_HashMap$HashEntry,
            callable : null
        }, {
            name : "putAll",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [ju_Map],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "putAllImpl",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [ju_Map],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "rehash",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "rehash",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "remove",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : jl_Object,
            callable : null
        }, {
            name : "removeEntry",
            modifiers : 4,
            accessLevel : 0,
            parameterTypes : [ju_HashMap$HashEntry],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "removeEntry",
            modifiers : 4,
            accessLevel : 0,
            parameterTypes : [jl_Object],
            returnType : ju_HashMap$HashEntry,
            callable : null
        }, {
            name : "size",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "values",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : ju_Collection,
            callable : null
        }, {
            name : "computeHashCode",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [jl_Object],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "areEqualKeys",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [jl_Object, jl_Object],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "areEqualValues",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [jl_Object, jl_Object],
            returnType : $rt_booleancls(),
            callable : null
        }];
    ju_AbstractMap.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "size",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "isEmpty",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "containsValue",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "containsKey",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "get",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : jl_Object,
            callable : null
        }, {
            name : "put",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Object, jl_Object],
            returnType : jl_Object,
            callable : null
        }, {
            name : "putAll",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [ju_Map],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "remove",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : jl_Object,
            callable : null
        }, {
            name : "entrySet",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : ju_Set,
            callable : null
        }, {
            name : "clear",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "keySet",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : ju_Set,
            callable : null
        }, {
            name : "values",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : ju_Collection,
            callable : null
        }, {
            name : "equals",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "hashCode",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "clone",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [],
            returnType : jl_Object,
            callable : null
        }];
    ju_Map.$meta.methods = [
        {
            name : "size",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "isEmpty",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "containsKey",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "containsValue",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "get",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : jl_Object,
            callable : null
        }, {
            name : "getOrDefault",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Object, jl_Object],
            returnType : jl_Object,
            callable : null
        }, {
            name : "put",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [jl_Object, jl_Object],
            returnType : jl_Object,
            callable : null
        }, {
            name : "remove",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : jl_Object,
            callable : null
        }, {
            name : "putAll",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [ju_Map],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "clear",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "keySet",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : ju_Set,
            callable : null
        }, {
            name : "values",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : ju_Collection,
            callable : null
        }, {
            name : "entrySet",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : ju_Set,
            callable : null
        }, {
            name : "replace",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Object, jl_Object, jl_Object],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "replace",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Object, jl_Object],
            returnType : jl_Object,
            callable : null
        }, {
            name : "putIfAbsent",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Object, jl_Object],
            returnType : jl_Object,
            callable : null
        }, {
            name : "computeIfAbsent",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Object, juf_Function],
            returnType : jl_Object,
            callable : null
        }, {
            name : "computeIfPresent",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Object, juf_BiFunction],
            returnType : jl_Object,
            callable : null
        }, {
            name : "compute",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Object, juf_BiFunction],
            returnType : jl_Object,
            callable : null
        }, {
            name : "merge",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Object, jl_Object, juf_BiFunction],
            returnType : jl_Object,
            callable : null
        }];
    jl_Cloneable.$meta.methods = [];
    jt_SimpleDateFormat.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getDefaultPattern",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String, ju_Locale],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String, jt_DateFormatSymbols],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "format",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [ju_Date, jl_StringBuffer, jt_FieldPosition],
            returnType : jl_StringBuffer,
            callable : null
        }, {
            name : "applyPattern",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "reparsePattern",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "parse",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String, jt_ParsePosition],
            returnType : ju_Date,
            callable : null
        }, {
            name : "clone",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_Object,
            callable : null
        }, {
            name : "getDateFormatSymbols",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jt_DateFormatSymbols,
            callable : null
        }, {
            name : "setDateFormatSymbols",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jt_DateFormatSymbols],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "toPattern",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "equals",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "hashCode",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }];
    jt_DateFormat.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "clone",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_Object,
            callable : null
        }, {
            name : "equals",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "format",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [jl_Object, jl_StringBuffer, jt_FieldPosition],
            returnType : jl_StringBuffer,
            callable : null
        }, {
            name : "format",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [ju_Date],
            returnType : jl_String,
            callable : null
        }, {
            name : "format",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [ju_Date, jl_StringBuffer, jt_FieldPosition],
            returnType : jl_StringBuffer,
            callable : null
        }, {
            name : "getAvailableLocales",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_arraycls(ju_Locale),
            callable : null
        }, {
            name : "getCalendar",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : ju_Calendar,
            callable : null
        }, {
            name : "getTimeZone",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : ju_TimeZone,
            callable : null
        }, {
            name : "setTimeZone",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [ju_TimeZone],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getDateInstance",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jt_DateFormat,
            callable : null
        }, {
            name : "getDateInstance",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : jt_DateFormat,
            callable : null
        }, {
            name : "getDateInstance",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), ju_Locale],
            returnType : jt_DateFormat,
            callable : null
        }, {
            name : "getDateFormatString",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [$rt_intcls(), ju_Locale],
            returnType : jl_String,
            callable : null
        }, {
            name : "getDateTimeInstance",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jt_DateFormat,
            callable : null
        }, {
            name : "getDateTimeInstance",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : jt_DateFormat,
            callable : null
        }, {
            name : "getDateTimeInstance",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls(), ju_Locale],
            returnType : jt_DateFormat,
            callable : null
        }, {
            name : "getDateTimeFormatString",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), ju_Locale],
            returnType : jl_String,
            callable : null
        }, {
            name : "getInstance",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jt_DateFormat,
            callable : null
        }, {
            name : "getStyleName",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [$rt_intcls()],
            returnType : jl_String,
            callable : null
        }, {
            name : "getTimeInstance",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jt_DateFormat,
            callable : null
        }, {
            name : "getTimeInstance",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : jt_DateFormat,
            callable : null
        }, {
            name : "getTimeInstance",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), ju_Locale],
            returnType : jt_DateFormat,
            callable : null
        }, {
            name : "getTimeFormatString",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [$rt_intcls(), ju_Locale],
            returnType : jl_String,
            callable : null
        }, {
            name : "hashCode",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "isLenient",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "parse",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : ju_Date,
            callable : null
        }, {
            name : "parse",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [jl_String, jt_ParsePosition],
            returnType : ju_Date,
            callable : null
        }, {
            name : "parseObject",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String, jt_ParsePosition],
            returnType : jl_Object,
            callable : null
        }, {
            name : "setCalendar",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [ju_Calendar],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "setLenient",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_booleancls()],
            returnType : $rt_voidcls(),
            callable : null
        }];
    jt_Format.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "clone",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_Object,
            callable : null
        }, {
            name : "convertPattern",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [jl_String, jl_String, jl_String, $rt_booleancls()],
            returnType : jl_String,
            callable : null
        }, {
            name : "format",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : jl_String,
            callable : null
        }, {
            name : "format",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [jl_Object, jl_StringBuffer, jt_FieldPosition],
            returnType : jl_StringBuffer,
            callable : null
        }, {
            name : "formatToCharacterIterator",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : jt_AttributedCharacterIterator,
            callable : null
        }, {
            name : "parseObject",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : jl_Object,
            callable : null
        }, {
            name : "parseObject",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [jl_String, jt_ParsePosition],
            returnType : jl_Object,
            callable : null
        }, {
            name : "upTo",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [jl_String, jt_ParsePosition, jl_StringBuffer, $rt_charcls()],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "upToWithQuotes",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [jl_String, jt_ParsePosition, jl_StringBuffer, $rt_charcls(), $rt_charcls()],
            returnType : $rt_booleancls(),
            callable : null
        }];
    ju_HashSet.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_floatcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [ju_Collection],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [ju_HashMap],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "add",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "clear",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "clone",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_Object,
            callable : null
        }, {
            name : "contains",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "isEmpty",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "iterator",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : ju_Iterator,
            callable : null
        }, {
            name : "remove",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "size",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "createBackingMap",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [$rt_intcls(), $rt_floatcls()],
            returnType : ju_HashMap,
            callable : null
        }];
    ju_AbstractSet.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "removeAll",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [ju_Collection],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "equals",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "hashCode",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }];
    ju_Set.$meta.methods = [];
    otjt_Int32Array.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "get",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "set",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "set",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_intcls()), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "set",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_intcls())],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "create",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : otjt_Int32Array,
            callable : null
        }, {
            name : "create",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [otjt_ArrayBuffer],
            returnType : otjt_Int32Array,
            callable : null
        }, {
            name : "create",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [otjt_ArrayBufferView],
            returnType : otjt_Int32Array,
            callable : null
        }, {
            name : "create",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [otjt_ArrayBuffer, $rt_intcls(), $rt_intcls()],
            returnType : otjt_Int32Array,
            callable : null
        }, {
            name : "create",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [otjt_ArrayBuffer, $rt_intcls()],
            returnType : otjt_Int32Array,
            callable : null
        }, {
            name : "<init>$static",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [otjt_Int32Array],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "create$js_body$_5",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "create$js_body$_6",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "create$js_body$_7",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "create$js_body$_8",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [otj_JSObject, otj_JSObject, otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "create$js_body$_9",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [otj_JSObject, otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }];
    nle_EarlyLoadScreen.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "paintScreen",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "paintEnable",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<clinit>",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }];
    jn_IntBuffer.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [$rt_intcls(), $rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "allocate",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : jn_IntBuffer,
            callable : null
        }, {
            name : "wrap",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_intcls()), $rt_intcls(), $rt_intcls()],
            returnType : jn_IntBuffer,
            callable : null
        }, {
            name : "wrap",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_intcls())],
            returnType : jn_IntBuffer,
            callable : null
        }, {
            name : "slice",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jn_IntBuffer,
            callable : null
        }, {
            name : "duplicate",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jn_IntBuffer,
            callable : null
        }, {
            name : "asReadOnlyBuffer",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jn_IntBuffer,
            callable : null
        }, {
            name : "get",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "put",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : jn_IntBuffer,
            callable : null
        }, {
            name : "get",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "put",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : jn_IntBuffer,
            callable : null
        }, {
            name : "getElement",
            modifiers : 1,
            accessLevel : 0,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "putElement",
            modifiers : 1,
            accessLevel : 0,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "get",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_intcls()), $rt_intcls(), $rt_intcls()],
            returnType : jn_IntBuffer,
            callable : null
        }, {
            name : "get",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_intcls())],
            returnType : jn_IntBuffer,
            callable : null
        }, {
            name : "put",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jn_IntBuffer],
            returnType : jn_IntBuffer,
            callable : null
        }, {
            name : "put",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_intcls()), $rt_intcls(), $rt_intcls()],
            returnType : jn_IntBuffer,
            callable : null
        }, {
            name : "put",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_intcls())],
            returnType : jn_IntBuffer,
            callable : null
        }, {
            name : "hasArray",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "array",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_arraycls($rt_intcls()),
            callable : null
        }, {
            name : "arrayOffset",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "isArrayPresent",
            modifiers : 1,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "getArray",
            modifiers : 1,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_arraycls($rt_intcls()),
            callable : null
        }, {
            name : "getArrayOffset",
            modifiers : 1,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "compact",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jn_IntBuffer,
            callable : null
        }, {
            name : "isDirect",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "toString",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "hashCode",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "equals",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "compareTo",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jn_IntBuffer],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "order",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jn_ByteOrder,
            callable : null
        }, {
            name : "mark",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jn_IntBuffer,
            callable : null
        }, {
            name : "reset",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jn_IntBuffer,
            callable : null
        }, {
            name : "clear",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jn_IntBuffer,
            callable : null
        }, {
            name : "flip",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jn_IntBuffer,
            callable : null
        }, {
            name : "rewind",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jn_IntBuffer,
            callable : null
        }, {
            name : "limit",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : jn_IntBuffer,
            callable : null
        }, {
            name : "position",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : jn_IntBuffer,
            callable : null
        }, {
            name : "array",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_Object,
            callable : null
        }, {
            name : "rewind",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jn_Buffer,
            callable : null
        }, {
            name : "flip",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jn_Buffer,
            callable : null
        }, {
            name : "clear",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jn_Buffer,
            callable : null
        }, {
            name : "reset",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jn_Buffer,
            callable : null
        }, {
            name : "mark",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jn_Buffer,
            callable : null
        }, {
            name : "limit",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : jn_Buffer,
            callable : null
        }, {
            name : "position",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : jn_Buffer,
            callable : null
        }, {
            name : "compareTo",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_intcls(),
            callable : null
        }];
    jn_Buffer.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "capacity",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "position",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "position",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : jn_Buffer,
            callable : null
        }, {
            name : "limit",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "limit",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : jn_Buffer,
            callable : null
        }, {
            name : "mark",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jn_Buffer,
            callable : null
        }, {
            name : "reset",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jn_Buffer,
            callable : null
        }, {
            name : "clear",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jn_Buffer,
            callable : null
        }, {
            name : "flip",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jn_Buffer,
            callable : null
        }, {
            name : "rewind",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jn_Buffer,
            callable : null
        }, {
            name : "remaining",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "hasRemaining",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "isReadOnly",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "hasArray",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "array",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_Object,
            callable : null
        }, {
            name : "arrayOffset",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "isDirect",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }];
    jl_InterruptedException.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }];
    otja_XMLHttpRequest.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "open",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [jl_String, jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "open",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [jl_String, jl_String, $rt_booleancls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "open",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [jl_String, jl_String, $rt_booleancls(), jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "open",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [jl_String, jl_String, $rt_booleancls(), jl_String, jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "send",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "send",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "send",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [otj_JSObject],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "setRequestHeader",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [jl_String, jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getAllResponseHeaders",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "getResponseHeader",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : jl_String,
            callable : null
        }, {
            name : "setOnReadyStateChange",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [otja_ReadyStateChangeHandler],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "onComplete",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [jl_Runnable],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "overrideMimeType",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getReadyState",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getResponseText",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "getResponseXML",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : otjdx_Document,
            callable : null
        }, {
            name : "getResponse",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "getStatus",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getStatusText",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "setResponseType",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getResponseType",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "create",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [],
            returnType : otja_XMLHttpRequest,
            callable : null
        }, {
            name : "abort",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getResponseURL",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "lambda$onComplete$0",
            modifiers : 32,
            accessLevel : 1,
            parameterTypes : [jl_Runnable],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>$static",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [otja_XMLHttpRequest],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "onComplete$static",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [otja_XMLHttpRequest, jl_Runnable],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "lambda$onComplete$0$static",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [otja_XMLHttpRequest, jl_Runnable],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "create$js_body$_22",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [],
            returnType : otj_JSObject,
            callable : null
        }];
    nlea_EaglerAdapterImpl2$1.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [otja_XMLHttpRequest, oti_AsyncCallback],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "stateChanged",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "stateChanged$exported$0",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [],
            returnType : otj_JSObject,
            callable : null
        }];
    otja_ReadyStateChangeHandler.$meta.methods = [
        {
            name : "stateChanged",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }];
    jl_Thread.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Runnable],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Runnable, jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "start",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "runThread",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "setCurrentThread",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [jl_Thread],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getMainThread",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [],
            returnType : jl_Thread,
            callable : null
        }, {
            name : "run",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "currentThread",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_Thread,
            callable : null
        }, {
            name : "getName",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "isDaemon",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "setDaemon",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [$rt_booleancls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "join",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [$rt_longcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "join",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [$rt_longcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "join",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "yield",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "switchContext",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [jl_Thread],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "switchContext",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [jl_Thread, oti_AsyncCallback],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "interrupt",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "interrupted",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "isInterrupted",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "isAlive",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "activeCount",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getId",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_longcls(),
            callable : null
        }, {
            name : "holdsLock",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "sleep",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [$rt_longcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "sleep",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [$rt_longcls(), oti_AsyncCallback],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "setPriority",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getPriority",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getStackTrace",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_arraycls(jl_StackTraceElement),
            callable : null
        }, {
            name : "getContextClassLoader",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_ClassLoader,
            callable : null
        }, {
            name : "lambda$switchContext$2",
            modifiers : 544,
            accessLevel : 1,
            parameterTypes : [jl_Thread, oti_AsyncCallback],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "lambda$switchContext$1",
            modifiers : 544,
            accessLevel : 1,
            parameterTypes : [jl_Thread, oti_AsyncCallback],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "lambda$start$0",
            modifiers : 32,
            accessLevel : 1,
            parameterTypes : [$rt_booleancls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "access$002",
            modifiers : 544,
            accessLevel : 0,
            parameterTypes : [jl_Thread, $rt_booleancls()],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "<clinit>",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }];
    jl_Thread$SleepHandler.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [jl_Thread, oti_AsyncCallback],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "interrupted",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "run",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "lambda$interrupted$1",
            modifiers : 32,
            accessLevel : 1,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "lambda$interrupted$0",
            modifiers : 32,
            accessLevel : 1,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }];
    otp_PlatformRunnable.$meta.methods = [
        {
            name : "run",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }];
    otr_EventQueue$Event.$meta.methods = [
        {
            name : "run",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }];
    jl_ThreadInterruptHandler.$meta.methods = [
        {
            name : "interrupted",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }];
    nle_AssetRepository.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "install",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls())],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getResource",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_arraycls($rt_bytecls()),
            callable : null
        }, {
            name : "<clinit>",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }];
    ji_ByteArrayInputStream.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls()), $rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls())],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "read",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "read",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls()), $rt_intcls(), $rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "skip",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_longcls()],
            returnType : $rt_longcls(),
            callable : null
        }, {
            name : "available",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "markSupported",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "mark",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "reset",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "close",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }];
    ji_InputStream.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "read",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "read",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls())],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "read",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls()), $rt_intcls(), $rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "skip",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_longcls()],
            returnType : $rt_longcls(),
            callable : null
        }, {
            name : "skip",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "available",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "close",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "mark",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "reset",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "markSupported",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }];
    ji_DataInputStream.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [ji_InputStream],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "read",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls())],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "read",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls()), $rt_intcls(), $rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "readBoolean",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "readByte",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_bytecls(),
            callable : null
        }, {
            name : "readToBuff",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "readChar",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_charcls(),
            callable : null
        }, {
            name : "readDouble",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_doublecls(),
            callable : null
        }, {
            name : "readFloat",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_floatcls(),
            callable : null
        }, {
            name : "readFully",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls())],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "readFully",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls()), $rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "readInt",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "readLine",
            modifiers : 132,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "readLong",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_longcls(),
            callable : null
        }, {
            name : "readShort",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_shortcls(),
            callable : null
        }, {
            name : "readUnsignedByte",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "readUnsignedShort",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "readUTF",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "decodeUTF",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [$rt_intcls()],
            returnType : jl_String,
            callable : null
        }, {
            name : "decodeUTF",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [$rt_intcls(), ji_DataInput],
            returnType : jl_String,
            callable : null
        }, {
            name : "readUTF",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [ji_DataInput],
            returnType : jl_String,
            callable : null
        }, {
            name : "skipBytes",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "convertUTF8WithBuf",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [$rt_arraycls($rt_bytecls()), $rt_arraycls($rt_charcls()), $rt_intcls(), $rt_intcls()],
            returnType : jl_String,
            callable : null
        }];
    ji_FilterInputStream.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [ji_InputStream],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "available",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "close",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "mark",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "markSupported",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "read",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "read",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls())],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "read",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls()), $rt_intcls(), $rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "reset",
            modifiers : 2048,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "skip",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_longcls()],
            returnType : $rt_longcls(),
            callable : null
        }];
    ji_DataInput.$meta.methods = [
        {
            name : "readFully",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls())],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "readFully",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls()), $rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "skipBytes",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "readBoolean",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "readByte",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_bytecls(),
            callable : null
        }, {
            name : "readUnsignedByte",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "readShort",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_shortcls(),
            callable : null
        }, {
            name : "readUnsignedShort",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "readChar",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_charcls(),
            callable : null
        }, {
            name : "readInt",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "readLong",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_longcls(),
            callable : null
        }, {
            name : "readFloat",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_floatcls(),
            callable : null
        }, {
            name : "readDouble",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_doublecls(),
            callable : null
        }, {
            name : "readLine",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "readUTF",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }];
    cjj_InflaterInputStream.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [ji_InputStream],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [ji_InputStream, $rt_booleancls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [ji_InputStream, cjj_Inflater],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [ji_InputStream, cjj_Inflater, $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [ji_InputStream, cjj_Inflater, $rt_intcls(), $rt_booleancls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "read",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "read",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls()), $rt_intcls(), $rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "available",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "skip",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_longcls()],
            returnType : $rt_longcls(),
            callable : null
        }, {
            name : "close",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "fill",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "markSupported",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "mark",
            modifiers : 2048,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "reset",
            modifiers : 2048,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getTotalIn",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_longcls(),
            callable : null
        }, {
            name : "getTotalOut",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_longcls(),
            callable : null
        }, {
            name : "getAvailIn",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_arraycls($rt_bytecls()),
            callable : null
        }, {
            name : "readHeader",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getInflater",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : cjj_Inflater,
            callable : null
        }];
    nle_SHA1Digest.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [nle_SHA1Digest],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getAlgorithmName",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "getDigestSize",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "processWord",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [$rt_arraycls($rt_bytecls()), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "unpackWord",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [$rt_intcls(), $rt_arraycls($rt_bytecls()), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "processLength",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [$rt_longcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "doFinal",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls()), $rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "reset",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "f",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [$rt_intcls(), $rt_intcls(), $rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "h",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [$rt_intcls(), $rt_intcls(), $rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "g",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [$rt_intcls(), $rt_intcls(), $rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "rotateLeft",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "processBlock",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }];
    nle_GeneralDigest.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [nle_GeneralDigest],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "update",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_bytecls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "update",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls()), $rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "finish",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "reset",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "processWord",
            modifiers : 1,
            accessLevel : 2,
            parameterTypes : [$rt_arraycls($rt_bytecls()), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "processLength",
            modifiers : 1,
            accessLevel : 2,
            parameterTypes : [$rt_longcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "processBlock",
            modifiers : 1,
            accessLevel : 2,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }];
    nle_EaglerAdapter.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }];
    nleg_EaglerAdapterGL30.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "anisotropicPatch",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_booleancls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "glClearStack",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getDisplayListCount",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "glEnable",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "glShadeModel",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "glClearDepth",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_floatcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "glDepthFunc",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "glAlphaFunc",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_floatcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "glCullFace",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "glMatrixMode",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getMatrix",
            modifiers : 516,
            accessLevel : 1,
            parameterTypes : [],
            returnType : nlegv_Matrix4f,
            callable : null
        }, {
            name : "glLoadIdentity",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "glViewport",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "glClear",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "glOrtho",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_floatcls(), $rt_floatcls(), $rt_floatcls(), $rt_floatcls(), $rt_floatcls(), $rt_floatcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "glTranslatef",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_floatcls(), $rt_floatcls(), $rt_floatcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "glClearColor",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_floatcls(), $rt_floatcls(), $rt_floatcls(), $rt_floatcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "glDisable",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "glColor4f",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_floatcls(), $rt_floatcls(), $rt_floatcls(), $rt_floatcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "glGetError",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "glFlush",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "glLineWidth",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_floatcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "glTexImage2D",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls(), jn_ByteBuffer],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "glLight",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls(), jn_FloatBuffer],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "glLightModel",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jn_FloatBuffer],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "copyModelToLightMatrix",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "flipLightMatrix",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "revertLightMatrix",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "glPushMatrix",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "glRotatef",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_floatcls(), $rt_floatcls(), $rt_floatcls(), $rt_floatcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "glPopMatrix",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "glColorMaterial",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "glGetFloat",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jn_FloatBuffer],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "glGetInteger",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_arraycls($rt_intcls())],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "glScalef",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_floatcls(), $rt_floatcls(), $rt_floatcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "glBlendFunc",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "glDepthMask",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_booleancls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "glColorMask",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_booleancls(), $rt_booleancls(), $rt_booleancls(), $rt_booleancls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "updateAnisotropicPatch",
            modifiers : 516,
            accessLevel : 1,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "glBindTexture",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "glCopyTexSubImage2D",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "glTexParameteri",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "glTexParameterf",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls(), $rt_floatcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "glLogicOp",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "glNormal3f",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_floatcls(), $rt_floatcls(), $rt_floatcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "glGenLists",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "_wglBindVertexArray0",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [nlea_EaglerAdapterImpl2$BufferArrayGL],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "glCallList",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "glNewList",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "glEndList",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "glColor3f",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_floatcls(), $rt_floatcls(), $rt_floatcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "glTexGeni",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "glTexGen",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls(), jn_FloatBuffer],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "glTexImage2D",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls(), jn_IntBuffer],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "glTexImage2D_2",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls(), jn_IntBuffer],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "glTexSubImage2D",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls(), jn_IntBuffer],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "glDeleteTextures",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "glPolygonOffset",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_floatcls(), $rt_floatcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "glCallLists",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [jn_IntBuffer],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "glEnableVertexAttrib",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "glDisableVertexAttrib",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "hintAnisotropicFix",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_booleancls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getShaderModeFlag0",
            modifiers : 516,
            accessLevel : 1,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getShaderModeFlag1",
            modifiers : 516,
            accessLevel : 1,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getShaderModeFlag",
            modifiers : 516,
            accessLevel : 1,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "bindTheShader",
            modifiers : 516,
            accessLevel : 1,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "bindTheShader",
            modifiers : 516,
            accessLevel : 1,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "glDrawArrays",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls(), $rt_intcls(), jl_Object],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "_wglDrawQuadArrays",
            modifiers : 516,
            accessLevel : 1,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "initializeOcclusionObjects",
            modifiers : 516,
            accessLevel : 1,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "glCreateQuery",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "glBeginQuery",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "glDeleteQuery",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "glBindOcclusionBB",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "glEndOcclusionBB",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "glDrawOcclusionBB",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_floatcls(), $rt_floatcls(), $rt_floatcls(), $rt_floatcls(), $rt_floatcls(), $rt_floatcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "glEndQuery",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "glGetQueryResult",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "glGetQueryResultAvailable",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "glGenTextures",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "glTexSubImage2D",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls(), jn_ByteBuffer],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "glFogi",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "glFogf",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_floatcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "glFog",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jn_FloatBuffer],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "glDeleteLists",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "glActiveTexture",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "glClientActiveTexture",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "glMultiTexCoord2f",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_floatcls(), $rt_floatcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "gluUnProject",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_floatcls(), $rt_floatcls(), $rt_floatcls(), jn_FloatBuffer, jn_FloatBuffer, $rt_arraycls($rt_intcls()), jn_FloatBuffer],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "gluPerspective",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_floatcls(), $rt_floatcls(), $rt_floatcls(), $rt_floatcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "gluPerspectiveFlat",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_floatcls(), $rt_floatcls(), $rt_floatcls(), $rt_floatcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "gluErrorString",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : jl_String,
            callable : null
        }, {
            name : "getBitsPerSecond",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getVertexesPerSecond",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getTrianglesPerSecond",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "<clinit>",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }];
    nms_CompressedStreamTools.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "readCompressed",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [ji_InputStream],
            returnType : nms_NBTTagCompound,
            callable : null
        }, {
            name : "writeCompressed",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [nms_NBTTagCompound, ji_OutputStream],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "decompress",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls())],
            returnType : nms_NBTTagCompound,
            callable : null
        }, {
            name : "compress",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [nms_NBTTagCompound],
            returnType : $rt_arraycls($rt_bytecls()),
            callable : null
        }, {
            name : "readUncompressed",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls())],
            returnType : nms_NBTTagCompound,
            callable : null
        }, {
            name : "writeUncompressed",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [nms_NBTTagCompound],
            returnType : $rt_arraycls($rt_bytecls()),
            callable : null
        }, {
            name : "read",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [ji_DataInput],
            returnType : nms_NBTTagCompound,
            callable : null
        }, {
            name : "write",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [nms_NBTTagCompound, ji_DataOutput],
            returnType : $rt_voidcls(),
            callable : null
        }];
    ji_BufferedInputStream.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [ji_InputStream],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [ji_InputStream, $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "available",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "close",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "fillbuf",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [ji_InputStream, $rt_arraycls($rt_bytecls())],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "mark",
            modifiers : 2048,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "markSupported",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "read",
            modifiers : 2048,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "read",
            modifiers : 2048,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls()), $rt_intcls(), $rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "reset",
            modifiers : 2048,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "skip",
            modifiers : 2048,
            accessLevel : 3,
            parameterTypes : [$rt_longcls()],
            returnType : $rt_longcls(),
            callable : null
        }];
    ju_ArrayList.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [ju_Collection],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "trimToSize",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "ensureCapacity",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "get",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : jl_Object,
            callable : null
        }, {
            name : "size",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "clone",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_Object,
            callable : null
        }, {
            name : "set",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_Object],
            returnType : jl_Object,
            callable : null
        }, {
            name : "add",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "add",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_Object],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "remove",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : jl_Object,
            callable : null
        }, {
            name : "remove",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "clear",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "addAll",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), ju_Collection],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "removeRange",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "checkIndex",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "checkIndexForAdd",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "replaceAll",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [juf_UnaryOperator],
            returnType : $rt_voidcls(),
            callable : null
        }];
    ju_RandomAccess.$meta.methods = [];
    nle_Base64.$meta.methods = [
        {
            name : "decodeBase64",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls())],
            returnType : $rt_arraycls($rt_bytecls()),
            callable : null
        }, {
            name : "decodeBase64",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_arraycls($rt_bytecls()),
            callable : null
        }, {
            name : "decodeInteger",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls())],
            returnType : jm_BigInteger,
            callable : null
        }, {
            name : "encodeBase64",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls())],
            returnType : $rt_arraycls($rt_bytecls()),
            callable : null
        }, {
            name : "encodeBase64",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls()), $rt_booleancls()],
            returnType : $rt_arraycls($rt_bytecls()),
            callable : null
        }, {
            name : "encodeBase64",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls()), $rt_booleancls(), $rt_booleancls()],
            returnType : $rt_arraycls($rt_bytecls()),
            callable : null
        }, {
            name : "encodeBase64",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls()), $rt_booleancls(), $rt_booleancls(), $rt_intcls()],
            returnType : $rt_arraycls($rt_bytecls()),
            callable : null
        }, {
            name : "encodeBase64Chunked",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls())],
            returnType : $rt_arraycls($rt_bytecls()),
            callable : null
        }, {
            name : "encodeBase64String",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls())],
            returnType : jl_String,
            callable : null
        }, {
            name : "encodeBase64URLSafe",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls())],
            returnType : $rt_arraycls($rt_bytecls()),
            callable : null
        }, {
            name : "encodeBase64URLSafeString",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls())],
            returnType : jl_String,
            callable : null
        }, {
            name : "encodeInteger",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [jm_BigInteger],
            returnType : $rt_arraycls($rt_bytecls()),
            callable : null
        }, {
            name : "isArrayByteBase64",
            modifiers : 640,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls())],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "isBase64",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_bytecls()],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "isBase64",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls())],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "isBase64",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "toIntegerBytes",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [jm_BigInteger],
            returnType : $rt_arraycls($rt_bytecls()),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_booleancls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_arraycls($rt_bytecls())],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_arraycls($rt_bytecls()), $rt_booleancls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_arraycls($rt_bytecls()), $rt_booleancls(), nle_BaseNCodec$CodecPolicy],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "decode",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [$rt_arraycls($rt_bytecls()), $rt_intcls(), $rt_intcls(), nle_BaseNCodec$Context],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "encode",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [$rt_arraycls($rt_bytecls()), $rt_intcls(), $rt_intcls(), nle_BaseNCodec$Context],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "isInAlphabet",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [$rt_bytecls()],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "isUrlSafe",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "validateCharacter",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [$rt_intcls(), nle_BaseNCodec$Context],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "validateTrailingCharacter",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<clinit>",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }];
    nle_BaseNCodec.$meta.methods = [
        {
            name : "compareUnsigned",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "createPositiveCapacity",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getChunkSeparator",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_arraycls($rt_bytecls()),
            callable : null
        }, {
            name : "isWhiteSpace",
            modifiers : 512,
            accessLevel : 2,
            parameterTypes : [$rt_bytecls()],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "resizeBuffer",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [nle_BaseNCodec$Context, $rt_intcls()],
            returnType : $rt_arraycls($rt_bytecls()),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [$rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [$rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_bytecls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [$rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_bytecls(), nle_BaseNCodec$CodecPolicy],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "available",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [nle_BaseNCodec$Context],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "containsAlphabetOrPad",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [$rt_arraycls($rt_bytecls())],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "decode",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls())],
            returnType : $rt_arraycls($rt_bytecls()),
            callable : null
        }, {
            name : "decode",
            modifiers : 1,
            accessLevel : 0,
            parameterTypes : [$rt_arraycls($rt_bytecls()), $rt_intcls(), $rt_intcls(), nle_BaseNCodec$Context],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "decode",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : jl_Object,
            callable : null
        }, {
            name : "decode",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_arraycls($rt_bytecls()),
            callable : null
        }, {
            name : "encode",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls())],
            returnType : $rt_arraycls($rt_bytecls()),
            callable : null
        }, {
            name : "encode",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls()), $rt_intcls(), $rt_intcls()],
            returnType : $rt_arraycls($rt_bytecls()),
            callable : null
        }, {
            name : "encode",
            modifiers : 1,
            accessLevel : 0,
            parameterTypes : [$rt_arraycls($rt_bytecls()), $rt_intcls(), $rt_intcls(), nle_BaseNCodec$Context],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "encode",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : jl_Object,
            callable : null
        }, {
            name : "encodeAsString",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls())],
            returnType : jl_String,
            callable : null
        }, {
            name : "encodeToString",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls())],
            returnType : jl_String,
            callable : null
        }, {
            name : "ensureBufferSize",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [$rt_intcls(), nle_BaseNCodec$Context],
            returnType : $rt_arraycls($rt_bytecls()),
            callable : null
        }, {
            name : "getCodecPolicy",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : nle_BaseNCodec$CodecPolicy,
            callable : null
        }, {
            name : "getDefaultBufferSize",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getEncodedLength",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls())],
            returnType : $rt_longcls(),
            callable : null
        }, {
            name : "hasData",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [nle_BaseNCodec$Context],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "isInAlphabet",
            modifiers : 1,
            accessLevel : 2,
            parameterTypes : [$rt_bytecls()],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "isInAlphabet",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls()), $rt_booleancls()],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "isInAlphabet",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "isStrictDecoding",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "readResults",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [$rt_arraycls($rt_bytecls()), $rt_intcls(), $rt_intcls(), nle_BaseNCodec$Context],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "<clinit>",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }];
    nle_ConfigConstants.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<clinit>",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }];
    nms_ServerData.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String, jl_String, $rt_booleancls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "hashCode",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "equals",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "getNBTCompound",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : nms_NBTTagCompound,
            callable : null
        }, {
            name : "getAcceptsTextures",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "func_78840_c",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "setAcceptsTextures",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_booleancls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "isHidingAddress",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "setHideAddress",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_booleancls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getServerDataFromNBTCompound",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [nms_NBTTagCompound],
            returnType : nms_ServerData,
            callable : null
        }, {
            name : "setMOTDFromQuery",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [nle_ServerQuery$QueryResponse],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "setRateLimitError",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_booleancls(), $rt_booleancls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "refreshIcon",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "freeIcon",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<clinit>",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }];
    jl_System.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "out",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [],
            returnType : ji_PrintStream,
            callable : null
        }, {
            name : "err",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [],
            returnType : ji_PrintStream,
            callable : null
        }, {
            name : "in",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [],
            returnType : ji_InputStream,
            callable : null
        }, {
            name : "console",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [],
            returnType : ji_Console,
            callable : null
        }, {
            name : "arraycopy",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [jl_Object, $rt_intcls(), jl_Object, $rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "doArrayCopy",
            modifiers : 768,
            accessLevel : 1,
            parameterTypes : [jl_Object, $rt_intcls(), jl_Object, $rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "doArrayCopyLowLevel",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [otr_RuntimeArray, $rt_intcls(), otr_RuntimeArray, $rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "currentTimeMillis",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_longcls(),
            callable : null
        }, {
            name : "currentTimeMillisLowLevel",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [],
            returnType : $rt_longcls(),
            callable : null
        }, {
            name : "currentTimeMillisWasm",
            modifiers : 768,
            accessLevel : 1,
            parameterTypes : [],
            returnType : $rt_doublecls(),
            callable : null
        }, {
            name : "currentTimeMillisC",
            modifiers : 768,
            accessLevel : 1,
            parameterTypes : [],
            returnType : $rt_longcls(),
            callable : null
        }, {
            name : "initPropertiesIfNeeded",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getTempDir",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "getHomeDir",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "toJavaString",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [oti_Address, $rt_intcls()],
            returnType : jl_String,
            callable : null
        }, {
            name : "getProperty",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : jl_String,
            callable : null
        }, {
            name : "getProperty",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [jl_String, jl_String],
            returnType : jl_String,
            callable : null
        }, {
            name : "getProperties",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [],
            returnType : ju_Properties,
            callable : null
        }, {
            name : "setProperties",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [ju_Properties],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "copyProperties",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [ju_Properties, ju_Properties],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "setProperty",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [jl_String, jl_String],
            returnType : jl_String,
            callable : null
        }, {
            name : "clearProperty",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : jl_String,
            callable : null
        }, {
            name : "setErr",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [ji_PrintStream],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "setOut",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [ji_PrintStream],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "gc",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "gcLowLevel",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "runFinalization",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "nanoTime",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_longcls(),
            callable : null
        }, {
            name : "nanoTimeLowLevel",
            modifiers : 768,
            accessLevel : 1,
            parameterTypes : [],
            returnType : $rt_longcls(),
            callable : null
        }, {
            name : "identityHashCode",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "lineSeparator",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }];
    jl_ConsoleOutputStreamStdout.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "write",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "writeJs",
            modifiers : 768,
            accessLevel : 1,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "writeLowLevel",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "writeJs$js_body$_2",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [otj_JSObject],
            returnType : $rt_voidcls(),
            callable : null
        }];
    nms_Timer.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_floatcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "updateTimer",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }];
    nms_SoundManager.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "loadSoundSettings",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [nms_GameSettings],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "onSoundOptionsChanged",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "closeMinecraft",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "playRandomMusicIfReady",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "setListener",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [nms_EntityLiving, $rt_floatcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "stopAllSounds",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "playStreaming",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String, $rt_floatcls(), $rt_floatcls(), $rt_floatcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "updateSoundLocation",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [nms_Entity],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "updateSoundLocation",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [nms_Entity, nms_Entity],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "isEntitySoundPlaying",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [nms_Entity],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "stopEntitySound",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [nms_Entity],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "setEntitySoundVolume",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [nms_Entity, $rt_floatcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "setEntitySoundPitch",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [nms_Entity, $rt_floatcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "playEntitySound",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String, nms_Entity, $rt_floatcls(), $rt_floatcls(), $rt_booleancls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "playSound",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String, $rt_floatcls(), $rt_floatcls(), $rt_floatcls(), $rt_floatcls(), $rt_floatcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "playSoundFX",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String, $rt_floatcls(), $rt_floatcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "pauseAllSounds",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "resumeAllSounds",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "func_92071_g",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "func_92070_a",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String, $rt_floatcls(), $rt_floatcls(), $rt_floatcls(), $rt_floatcls(), $rt_floatcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "playTheTitleMusic",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "stopTheTitleMusic",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }];
    nms_Profiler.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "clearProfiling",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "startSection",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "endSection",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getProfilingData",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : ju_List,
            callable : null
        }, {
            name : "endStartSection",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getNameOfLastSection",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }];
    jl_Character.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_charcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "charValue",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_charcls(),
            callable : null
        }, {
            name : "valueOf",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_charcls()],
            returnType : jl_Character,
            callable : null
        }, {
            name : "toString",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "equals",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "hashCode",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "toString",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_charcls()],
            returnType : jl_String,
            callable : null
        }, {
            name : "isValidCodePoint",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "isBmpCodePoint",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "isSupplementaryCodePoint",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "isHighSurrogate",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_charcls()],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "isLowSurrogate",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_charcls()],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "isSurrogate",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_charcls()],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "isSurrogatePair",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_charcls(), $rt_charcls()],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "charCount",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "toCodePoint",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_charcls(), $rt_charcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "codePointAt",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [jl_CharSequence, $rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "codePointAt",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_charcls()), $rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "codePointAt",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_charcls()), $rt_intcls(), $rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "codePointBefore",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [jl_CharSequence, $rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "codePointBefore",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_charcls()), $rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "codePointBefore",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_charcls()), $rt_intcls(), $rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "highSurrogate",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_charcls(),
            callable : null
        }, {
            name : "lowSurrogate",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_charcls(),
            callable : null
        }, {
            name : "toLowerCase",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_charcls()],
            returnType : $rt_charcls(),
            callable : null
        }, {
            name : "toLowerCase",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "toLowerCaseLowLevel",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "toLowerCaseSystem",
            modifiers : 768,
            accessLevel : 1,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "toUpperCase",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_charcls()],
            returnType : $rt_charcls(),
            callable : null
        }, {
            name : "toUpperCase",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "toUpperCaseLowLevel",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "toUpperCaseSystem",
            modifiers : 768,
            accessLevel : 1,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "digit",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_charcls(), $rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "digit",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getNumericValue",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_charcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getNumericValue",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "forDigit",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : $rt_charcls(),
            callable : null
        }, {
            name : "isDigit",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_charcls()],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "isDigit",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "getDigitMapping",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [],
            returnType : $rt_arraycls($rt_intcls()),
            callable : null
        }, {
            name : "obtainDigitMapping",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [],
            returnType : otpm_StringResource,
            callable : null
        }, {
            name : "getClasses",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [],
            returnType : $rt_arraycls(otciu_UnicodeHelper$Range),
            callable : null
        }, {
            name : "obtainClasses",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [],
            returnType : otpm_StringResource,
            callable : null
        }, {
            name : "toChars",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_arraycls($rt_charcls()), $rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "toChars",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_arraycls($rt_charcls()),
            callable : null
        }, {
            name : "codePointCount",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [jl_CharSequence, $rt_intcls(), $rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "codePointCount",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_charcls()), $rt_intcls(), $rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "offsetByCodePoints",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [jl_CharSequence, $rt_intcls(), $rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "offsetByCodePoints",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_charcls()), $rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "isISOControl",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_charcls()],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "isISOControl",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "getType",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_charcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getType",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "isLowerCase",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_charcls()],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "isLowerCase",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "isUpperCase",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_charcls()],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "isUpperCase",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "isTitleCase",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_charcls()],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "isTitleCase",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "isDefined",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_charcls()],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "isDefined",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "isLetter",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_charcls()],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "isLetter",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "isLetterOrDigit",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_charcls()],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "isLetterOrDigit",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "isJavaLetter",
            modifiers : 640,
            accessLevel : 3,
            parameterTypes : [$rt_charcls()],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "isJavaIdentifierStart",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_charcls()],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "isJavaIdentifierStart",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "isJavaLetterOrDigit",
            modifiers : 640,
            accessLevel : 3,
            parameterTypes : [$rt_charcls()],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "isJavaIdentifierPart",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_charcls()],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "isJavaIdentifierPart",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "isAlphabetic",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "isUnicodeIdentifierStart",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_charcls()],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "isUnicodeIdentifierStart",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "isUnicodeIdentifierPart",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_charcls()],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "isUnicodeIdentifierPart",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "isIdentifierIgnorable",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_charcls()],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "isIdentifierIgnorable",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "isSpace",
            modifiers : 640,
            accessLevel : 3,
            parameterTypes : [$rt_charcls()],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "isSpaceChar",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_charcls()],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "isSpaceChar",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "isWhitespace",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_charcls()],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "isWhitespace",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "compareTo",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Character],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "compare",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_charcls(), $rt_charcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "reverseBytes",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_charcls()],
            returnType : $rt_charcls(),
            callable : null
        }, {
            name : "compareTo",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "<clinit>",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "obtainDigitMapping$$create",
            modifiers : 768,
            accessLevel : 1,
            parameterTypes : [],
            returnType : otpm_StringResource,
            callable : null
        }, {
            name : "obtainClasses$$create",
            modifiers : 768,
            accessLevel : 1,
            parameterTypes : [],
            returnType : otpm_StringResource,
            callable : null
        }];
    nlea_EaglerAdapterImpl2$TextureGL.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [otjw_WebGLTexture],
            returnType : $rt_voidcls(),
            callable : null
        }];
    nms_GLAllocation.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "generateDisplayLists",
            modifiers : 2560,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "generateTextureNames",
            modifiers : 2560,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "deleteDisplayLists",
            modifiers : 2560,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "func_98302_b",
            modifiers : 2560,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "deleteTexturesAndDisplayLists",
            modifiers : 2560,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "createDirectByteBuffer",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : jn_ByteBuffer,
            callable : null
        }, {
            name : "createDirectIntBuffer",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : jn_IntBuffer,
            callable : null
        }, {
            name : "createDirectFloatBuffer",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : jn_FloatBuffer,
            callable : null
        }, {
            name : "<clinit>",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }];
    jn_ByteBuffer.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [$rt_intcls(), $rt_intcls(), $rt_arraycls($rt_bytecls()), $rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "allocateDirect",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : jn_ByteBuffer,
            callable : null
        }, {
            name : "allocate",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : jn_ByteBuffer,
            callable : null
        }, {
            name : "wrap",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls()), $rt_intcls(), $rt_intcls()],
            returnType : jn_ByteBuffer,
            callable : null
        }, {
            name : "wrap",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls())],
            returnType : jn_ByteBuffer,
            callable : null
        }, {
            name : "slice",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jn_ByteBuffer,
            callable : null
        }, {
            name : "duplicate",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jn_ByteBuffer,
            callable : null
        }, {
            name : "asReadOnlyBuffer",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jn_ByteBuffer,
            callable : null
        }, {
            name : "get",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_bytecls(),
            callable : null
        }, {
            name : "put",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_bytecls()],
            returnType : jn_ByteBuffer,
            callable : null
        }, {
            name : "get",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_bytecls(),
            callable : null
        }, {
            name : "put",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_bytecls()],
            returnType : jn_ByteBuffer,
            callable : null
        }, {
            name : "get",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls()), $rt_intcls(), $rt_intcls()],
            returnType : jn_ByteBuffer,
            callable : null
        }, {
            name : "get",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls())],
            returnType : jn_ByteBuffer,
            callable : null
        }, {
            name : "put",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jn_ByteBuffer],
            returnType : jn_ByteBuffer,
            callable : null
        }, {
            name : "put",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls()), $rt_intcls(), $rt_intcls()],
            returnType : jn_ByteBuffer,
            callable : null
        }, {
            name : "put",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls())],
            returnType : jn_ByteBuffer,
            callable : null
        }, {
            name : "hasArray",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "array",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_arraycls($rt_bytecls()),
            callable : null
        }, {
            name : "arrayOffset",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "compact",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jn_ByteBuffer,
            callable : null
        }, {
            name : "isDirect",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "toString",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "hashCode",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "equals",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "compareTo",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jn_ByteBuffer],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "order",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jn_ByteOrder,
            callable : null
        }, {
            name : "order",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [jn_ByteOrder],
            returnType : jn_ByteBuffer,
            callable : null
        }, {
            name : "getChar",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_charcls(),
            callable : null
        }, {
            name : "putChar",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_charcls()],
            returnType : jn_ByteBuffer,
            callable : null
        }, {
            name : "getChar",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_charcls(),
            callable : null
        }, {
            name : "putChar",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_charcls()],
            returnType : jn_ByteBuffer,
            callable : null
        }, {
            name : "asCharBuffer",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jn_CharBuffer,
            callable : null
        }, {
            name : "getShort",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_shortcls(),
            callable : null
        }, {
            name : "putShort",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_shortcls()],
            returnType : jn_ByteBuffer,
            callable : null
        }, {
            name : "getShort",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_shortcls(),
            callable : null
        }, {
            name : "putShort",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_shortcls()],
            returnType : jn_ByteBuffer,
            callable : null
        }, {
            name : "asShortBuffer",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jn_ShortBuffer,
            callable : null
        }, {
            name : "getInt",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "putInt",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : jn_ByteBuffer,
            callable : null
        }, {
            name : "getInt",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "putInt",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : jn_ByteBuffer,
            callable : null
        }, {
            name : "asIntBuffer",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jn_IntBuffer,
            callable : null
        }, {
            name : "getLong",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_longcls(),
            callable : null
        }, {
            name : "putLong",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_longcls()],
            returnType : jn_ByteBuffer,
            callable : null
        }, {
            name : "getLong",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_longcls(),
            callable : null
        }, {
            name : "putLong",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_longcls()],
            returnType : jn_ByteBuffer,
            callable : null
        }, {
            name : "asLongBuffer",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jn_LongBuffer,
            callable : null
        }, {
            name : "asFloatBuffer",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jn_FloatBuffer,
            callable : null
        }, {
            name : "asDoubleBuffer",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jn_DoubleBuffer,
            callable : null
        }, {
            name : "mark",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jn_ByteBuffer,
            callable : null
        }, {
            name : "reset",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jn_ByteBuffer,
            callable : null
        }, {
            name : "clear",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jn_ByteBuffer,
            callable : null
        }, {
            name : "flip",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jn_ByteBuffer,
            callable : null
        }, {
            name : "rewind",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jn_ByteBuffer,
            callable : null
        }, {
            name : "limit",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : jn_ByteBuffer,
            callable : null
        }, {
            name : "position",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : jn_ByteBuffer,
            callable : null
        }, {
            name : "array",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_Object,
            callable : null
        }, {
            name : "rewind",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jn_Buffer,
            callable : null
        }, {
            name : "flip",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jn_Buffer,
            callable : null
        }, {
            name : "clear",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jn_Buffer,
            callable : null
        }, {
            name : "reset",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jn_Buffer,
            callable : null
        }, {
            name : "mark",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jn_Buffer,
            callable : null
        }, {
            name : "limit",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : jn_Buffer,
            callable : null
        }, {
            name : "position",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : jn_Buffer,
            callable : null
        }, {
            name : "compareTo",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_intcls(),
            callable : null
        }];
    nle_EaglerImage.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls(), $rt_booleancls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_intcls()), $rt_intcls(), $rt_intcls(), $rt_booleancls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "loadImage",
            modifiers : 516,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls())],
            returnType : nle_EaglerImage,
            callable : null
        }, {
            name : "getSubImage",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls()],
            returnType : nle_EaglerImage,
            callable : null
        }];
    jl_Float.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_floatcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_doublecls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "intValue",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "longValue",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_longcls(),
            callable : null
        }, {
            name : "floatValue",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_floatcls(),
            callable : null
        }, {
            name : "doubleValue",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_doublecls(),
            callable : null
        }, {
            name : "valueOf",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_floatcls()],
            returnType : jl_Float,
            callable : null
        }, {
            name : "toString",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_floatcls()],
            returnType : jl_String,
            callable : null
        }, {
            name : "toString",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "equals",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "hashCode",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "hashCode",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_floatcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "isNaN",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [$rt_floatcls()],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "isInfinite",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [$rt_floatcls()],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "isFinite",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [$rt_floatcls()],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "getNaN",
            modifiers : 768,
            accessLevel : 1,
            parameterTypes : [],
            returnType : $rt_floatcls(),
            callable : null
        }, {
            name : "parseFloat",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_floatcls(),
            callable : null
        }, {
            name : "decimalExponent",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_floatcls(),
            callable : null
        }, {
            name : "valueOf",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : jl_Float,
            callable : null
        }, {
            name : "isNaN",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "isInfinite",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "compare",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_floatcls(), $rt_floatcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "compareTo",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Float],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "floatToRawIntBits",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_floatcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "floatToIntBits",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [$rt_floatcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "intBitsToFloat",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_floatcls(),
            callable : null
        }, {
            name : "toHexString",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_floatcls()],
            returnType : jl_String,
            callable : null
        }, {
            name : "compareTo",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "<clinit>",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "isNaN$js_body$_13",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "isInfinite$js_body$_14",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "isFinite$js_body$_15",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "getNaN$js_body$_16",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "floatToIntBits$js_body$_25",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "intBitsToFloat$js_body$_26",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }];
    nlea_EaglerAdapterImpl2$BufferGL.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [otjw_WebGLBuffer],
            returnType : $rt_voidcls(),
            callable : null
        }];
    nlea_EaglerAdapterImpl2$ShaderGL.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [otjw_WebGLShader],
            returnType : $rt_voidcls(),
            callable : null
        }];
    nlea_EaglerAdapterImpl2$ProgramGL.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [otjw_WebGLProgram],
            returnType : $rt_voidcls(),
            callable : null
        }];
    nlea_EaglerAdapterImpl2$UniformGL.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [otjw_WebGLUniformLocation],
            returnType : $rt_voidcls(),
            callable : null
        }];
    nlea_EaglerAdapterImpl2$BufferArrayGL.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [nleat_WebGLVertexArray],
            returnType : $rt_voidcls(),
            callable : null
        }];
    jnc_Charset.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [jl_String, $rt_arraycls(jl_String)],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "checkCanonicalName",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "isValidCharsetStart",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [$rt_charcls()],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "forName",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : jnc_Charset,
            callable : null
        }, {
            name : "defaultCharset",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jnc_Charset,
            callable : null
        }, {
            name : "name",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "aliases",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [],
            returnType : ju_Set,
            callable : null
        }, {
            name : "displayName",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "contains",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [jnc_Charset],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "newDecoder",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jnc_CharsetDecoder,
            callable : null
        }, {
            name : "newEncoder",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jnc_CharsetEncoder,
            callable : null
        }, {
            name : "canEncode",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "decode",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [jn_ByteBuffer],
            returnType : jn_CharBuffer,
            callable : null
        }, {
            name : "encode",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [jn_CharBuffer],
            returnType : jn_ByteBuffer,
            callable : null
        }, {
            name : "encode",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : jn_ByteBuffer,
            callable : null
        }, {
            name : "compareTo",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [jnc_Charset],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "compareTo",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_intcls(),
            callable : null
        }];
    jl_IllegalArgumentException.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String, jl_Throwable],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Throwable],
            returnType : $rt_voidcls(),
            callable : null
        }];
    jnc_UnsupportedCharsetException.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getCharsetName",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }];
    ju_Arrays.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "copyOf",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_charcls()), $rt_intcls()],
            returnType : $rt_arraycls($rt_charcls()),
            callable : null
        }, {
            name : "copyOf",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls()), $rt_intcls()],
            returnType : $rt_arraycls($rt_bytecls()),
            callable : null
        }, {
            name : "copyOf",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_shortcls()), $rt_intcls()],
            returnType : $rt_arraycls($rt_shortcls()),
            callable : null
        }, {
            name : "copyOf",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_intcls()), $rt_intcls()],
            returnType : $rt_arraycls($rt_intcls()),
            callable : null
        }, {
            name : "copyOf",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_longcls()), $rt_intcls()],
            returnType : $rt_arraycls($rt_longcls()),
            callable : null
        }, {
            name : "copyOf",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_floatcls()), $rt_intcls()],
            returnType : $rt_arraycls($rt_floatcls()),
            callable : null
        }, {
            name : "copyOf",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_doublecls()), $rt_intcls()],
            returnType : $rt_arraycls($rt_doublecls()),
            callable : null
        }, {
            name : "copyOf",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_booleancls()), $rt_intcls()],
            returnType : $rt_arraycls($rt_booleancls()),
            callable : null
        }, {
            name : "copyOf",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls(jl_Object), $rt_intcls()],
            returnType : $rt_arraycls(jl_Object),
            callable : null
        }, {
            name : "copyOf",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls(jl_Object), $rt_intcls(), jl_Class],
            returnType : $rt_arraycls(jl_Object),
            callable : null
        }, {
            name : "copyOfRange",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_booleancls()), $rt_intcls(), $rt_intcls()],
            returnType : $rt_arraycls($rt_booleancls()),
            callable : null
        }, {
            name : "copyOfRange",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls()), $rt_intcls(), $rt_intcls()],
            returnType : $rt_arraycls($rt_bytecls()),
            callable : null
        }, {
            name : "copyOfRange",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_charcls()), $rt_intcls(), $rt_intcls()],
            returnType : $rt_arraycls($rt_charcls()),
            callable : null
        }, {
            name : "copyOfRange",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_shortcls()), $rt_intcls(), $rt_intcls()],
            returnType : $rt_arraycls($rt_shortcls()),
            callable : null
        }, {
            name : "copyOfRange",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_intcls()), $rt_intcls(), $rt_intcls()],
            returnType : $rt_arraycls($rt_intcls()),
            callable : null
        }, {
            name : "copyOfRange",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_longcls()), $rt_intcls(), $rt_intcls()],
            returnType : $rt_arraycls($rt_longcls()),
            callable : null
        }, {
            name : "copyOfRange",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_floatcls()), $rt_intcls(), $rt_intcls()],
            returnType : $rt_arraycls($rt_floatcls()),
            callable : null
        }, {
            name : "copyOfRange",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_doublecls()), $rt_intcls(), $rt_intcls()],
            returnType : $rt_arraycls($rt_doublecls()),
            callable : null
        }, {
            name : "copyOfRange",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls(jl_Object), $rt_intcls(), $rt_intcls()],
            returnType : $rt_arraycls(jl_Object),
            callable : null
        }, {
            name : "copyOfRange",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls(jl_Object), $rt_intcls(), $rt_intcls(), jl_Class],
            returnType : $rt_arraycls(jl_Object),
            callable : null
        }, {
            name : "toString",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls(jl_Object)],
            returnType : jl_String,
            callable : null
        }, {
            name : "toString",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_booleancls())],
            returnType : jl_String,
            callable : null
        }, {
            name : "toString",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls())],
            returnType : jl_String,
            callable : null
        }, {
            name : "toString",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_shortcls())],
            returnType : jl_String,
            callable : null
        }, {
            name : "toString",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_charcls())],
            returnType : jl_String,
            callable : null
        }, {
            name : "toString",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_intcls())],
            returnType : jl_String,
            callable : null
        }, {
            name : "toString",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_longcls())],
            returnType : jl_String,
            callable : null
        }, {
            name : "toString",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_floatcls())],
            returnType : jl_String,
            callable : null
        }, {
            name : "toString",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_doublecls())],
            returnType : jl_String,
            callable : null
        }, {
            name : "fill",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_longcls()), $rt_intcls(), $rt_intcls(), $rt_longcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "fill",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_longcls()), $rt_longcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "fill",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_intcls()), $rt_intcls(), $rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "fill",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_intcls()), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "fill",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_shortcls()), $rt_intcls(), $rt_intcls(), $rt_shortcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "fill",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_shortcls()), $rt_shortcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "fill",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_charcls()), $rt_intcls(), $rt_intcls(), $rt_charcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "fill",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_charcls()), $rt_charcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "fill",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls()), $rt_intcls(), $rt_intcls(), $rt_bytecls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "fill",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls()), $rt_bytecls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "fill",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_booleancls()), $rt_intcls(), $rt_intcls(), $rt_booleancls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "fill",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_booleancls()), $rt_booleancls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "fill",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_floatcls()), $rt_intcls(), $rt_intcls(), $rt_floatcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "fill",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_floatcls()), $rt_floatcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "fill",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_doublecls()), $rt_intcls(), $rt_intcls(), $rt_doublecls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "fill",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_doublecls()), $rt_doublecls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "fill",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls(jl_Object), $rt_intcls(), $rt_intcls(), jl_Object],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "fill",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls(jl_Object), jl_Object],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "sort",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_intcls()), $rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "sort",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_intcls())],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "merge",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [$rt_arraycls($rt_intcls()), $rt_arraycls($rt_intcls()), $rt_intcls(), $rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "sort",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_longcls()), $rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "sort",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_longcls())],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "merge",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [$rt_arraycls($rt_longcls()), $rt_arraycls($rt_longcls()), $rt_intcls(), $rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "sort",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_shortcls()), $rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "sort",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_shortcls())],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "merge",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [$rt_arraycls($rt_shortcls()), $rt_arraycls($rt_shortcls()), $rt_intcls(), $rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "sort",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_charcls()), $rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "sort",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_charcls())],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "merge",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [$rt_arraycls($rt_charcls()), $rt_arraycls($rt_charcls()), $rt_intcls(), $rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "sort",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls()), $rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "sort",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls())],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "merge",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [$rt_arraycls($rt_bytecls()), $rt_arraycls($rt_bytecls()), $rt_intcls(), $rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "sort",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_floatcls()), $rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "sort",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_floatcls())],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "merge",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [$rt_arraycls($rt_floatcls()), $rt_arraycls($rt_floatcls()), $rt_intcls(), $rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "sort",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_doublecls()), $rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "sort",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_doublecls())],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "merge",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [$rt_arraycls($rt_doublecls()), $rt_arraycls($rt_doublecls()), $rt_intcls(), $rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "sort",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls(jl_Object)],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "sort",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls(jl_Object), $rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "sort",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls(jl_Object), $rt_intcls(), $rt_intcls(), ju_Comparator],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "sort",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls(jl_Object), ju_Comparator],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "merge",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [$rt_arraycls(jl_Object), $rt_arraycls(jl_Object), $rt_intcls(), $rt_intcls(), $rt_intcls(), ju_Comparator],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "binarySearch",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_intcls()), $rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "binarySearch",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_intcls()), $rt_intcls(), $rt_intcls(), $rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "binarySearch",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_longcls()), $rt_longcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "binarySearch",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_longcls()), $rt_intcls(), $rt_intcls(), $rt_longcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "binarySearch",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_shortcls()), $rt_shortcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "binarySearch",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_shortcls()), $rt_intcls(), $rt_intcls(), $rt_shortcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "binarySearch",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_charcls()), $rt_charcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "binarySearch",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_charcls()), $rt_intcls(), $rt_intcls(), $rt_charcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "binarySearch",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls()), $rt_bytecls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "binarySearch",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls()), $rt_intcls(), $rt_intcls(), $rt_bytecls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "binarySearch",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_doublecls()), $rt_doublecls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "binarySearch",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_doublecls()), $rt_intcls(), $rt_intcls(), $rt_doublecls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "binarySearch",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_floatcls()), $rt_floatcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "binarySearch",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_floatcls()), $rt_intcls(), $rt_intcls(), $rt_floatcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "binarySearch",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls(jl_Object), jl_Object],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "binarySearch",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls(jl_Object), $rt_intcls(), $rt_intcls(), jl_Object],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "binarySearch",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls(jl_Object), jl_Object, ju_Comparator],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "binarySearch",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls(jl_Object), $rt_intcls(), $rt_intcls(), jl_Object, ju_Comparator],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "equals",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_longcls()), $rt_arraycls($rt_longcls())],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "equals",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_intcls()), $rt_arraycls($rt_intcls())],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "equals",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_shortcls()), $rt_arraycls($rt_shortcls())],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "equals",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_charcls()), $rt_arraycls($rt_charcls())],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "equals",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls()), $rt_arraycls($rt_bytecls())],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "equals",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_floatcls()), $rt_arraycls($rt_floatcls())],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "equals",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_doublecls()), $rt_arraycls($rt_doublecls())],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "equals",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_booleancls()), $rt_arraycls($rt_booleancls())],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "equals",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls(jl_Object), $rt_arraycls(jl_Object)],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "hashCode",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_booleancls())],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "hashCode",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_longcls())],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "hashCode",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_intcls())],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "hashCode",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls())],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "hashCode",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_shortcls())],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "hashCode",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_charcls())],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "hashCode",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_floatcls())],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "hashCode",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_doublecls())],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "hashCode",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls(jl_Object)],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "deepHashCode",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls(jl_Object)],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "deepEquals",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls(jl_Object), $rt_arraycls(jl_Object)],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "asList",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls(jl_Object)],
            returnType : ju_List,
            callable : null
        }, {
            name : "deepToString",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls(jl_Object)],
            returnType : jl_String,
            callable : null
        }, {
            name : "deepToString",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [$rt_arraycls(jl_Object), jl_StringBuilder, ju_List],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "deepToString",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [jl_Object, jl_StringBuilder, ju_List],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "stream",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls(jl_Object)],
            returnType : jus_Stream,
            callable : null
        }, {
            name : "stream",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls(jl_Object), $rt_intcls(), $rt_intcls()],
            returnType : jus_Stream,
            callable : null
        }, {
            name : "stream",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_intcls())],
            returnType : jus_IntStream,
            callable : null
        }, {
            name : "stream",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_intcls()), $rt_intcls(), $rt_intcls()],
            returnType : jus_IntStream,
            callable : null
        }, {
            name : "stream",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_longcls())],
            returnType : jus_LongStream,
            callable : null
        }, {
            name : "stream",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_longcls()), $rt_intcls(), $rt_intcls()],
            returnType : jus_LongStream,
            callable : null
        }, {
            name : "stream",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_doublecls())],
            returnType : jus_DoubleStream,
            callable : null
        }, {
            name : "stream",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_doublecls()), $rt_intcls(), $rt_intcls()],
            returnType : jus_DoubleStream,
            callable : null
        }, {
            name : "setAll",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls(jl_Object), juf_IntFunction],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "setAll",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_intcls()), juf_IntUnaryOperator],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "setAll",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_longcls()), juf_IntToLongFunction],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "setAll",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_doublecls()), juf_IntToDoubleFunction],
            returnType : $rt_voidcls(),
            callable : null
        }];
    jnci_UTF8Charset.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "contains",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jnc_Charset],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "newDecoder",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jnc_CharsetDecoder,
            callable : null
        }, {
            name : "newEncoder",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jnc_CharsetEncoder,
            callable : null
        }];
    nle_EaglercraftRandom.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_longcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "setSeed",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_longcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "next",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "nextBytes",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls())],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "nextInt",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "nextInt",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "nextLong",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_longcls(),
            callable : null
        }, {
            name : "nextBoolean",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "nextFloat",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_floatcls(),
            callable : null
        }, {
            name : "nextDouble",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_doublecls(),
            callable : null
        }, {
            name : "nextGaussian",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_doublecls(),
            callable : null
        }];
    nms_Packet3Chat.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String, $rt_booleancls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "readPacketData",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [ji_DataInputStream],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "writePacketData",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [ji_DataOutputStream],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "processPacket",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [nms_NetHandler],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getPacketSize",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getIsServer",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "canProcessAsync",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "<clinit>",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }];
    nms_Packet.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "addIdClassMapping",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [$rt_intcls(), $rt_booleancls(), $rt_booleancls(), jl_Class],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getNewPacket",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : nms_Packet,
            callable : null
        }, {
            name : "writeByteArray",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [ji_DataOutputStream, $rt_arraycls($rt_bytecls())],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "readBytesFromStream",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [ji_DataInputStream],
            returnType : $rt_arraycls($rt_bytecls()),
            callable : null
        }, {
            name : "getPacketId",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "readPacket",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [ji_DataInputStream, $rt_booleancls()],
            returnType : nms_Packet,
            callable : null
        }, {
            name : "writePacket",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [nms_Packet, ji_DataOutputStream],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "writeString",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [jl_String, ji_DataOutputStream],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "readString",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [ji_DataInputStream, $rt_intcls()],
            returnType : jl_String,
            callable : null
        }, {
            name : "readPacketData",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [ji_DataInputStream],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "writePacketData",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [ji_DataOutputStream],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "processPacket",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [nms_NetHandler],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getPacketSize",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "isRealPacket",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "containsSameEntityIDAs",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [nms_Packet],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "canProcessAsync",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "toString",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "readItemStack",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [ji_DataInputStream],
            returnType : nms_ItemStack,
            callable : null
        }, {
            name : "writeItemStack",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [nms_ItemStack, ji_DataOutputStream],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "readNBTTagCompound",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [ji_DataInputStream],
            returnType : nms_NBTTagCompound,
            callable : null
        }, {
            name : "writeNBTTagCompound",
            modifiers : 512,
            accessLevel : 2,
            parameterTypes : [nms_NBTTagCompound, ji_DataOutputStream],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<clinit>",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }];
    nle_EaglerProfile.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getSkinSize",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getSkinPacket",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_arraycls($rt_bytecls()),
            callable : null
        }, {
            name : "concatArrays",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls(jl_String), $rt_arraycls(jl_String)],
            returnType : $rt_arraycls(jl_String),
            callable : null
        }, {
            name : "addSkin",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [jl_String, $rt_arraycls($rt_bytecls()), $rt_booleancls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "loadFromStorage",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<clinit>",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }];
    ju_Locale.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String, jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String, jl_String, jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "clone",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_Object,
            callable : null
        }, {
            name : "equals",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "getAvailableLocales",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_arraycls(ju_Locale),
            callable : null
        }, {
            name : "getCountry",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "getDefault",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [],
            returnType : ju_Locale,
            callable : null
        }, {
            name : "getDisplayCountry",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "getDisplayCountry",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [ju_Locale],
            returnType : jl_String,
            callable : null
        }, {
            name : "getDisplayCountry",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [jl_String, jl_String],
            returnType : jl_String,
            callable : null
        }, {
            name : "getDisplayLanguage",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "getDisplayLanguage",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [ju_Locale],
            returnType : jl_String,
            callable : null
        }, {
            name : "getDisplayLanguage",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [jl_String, jl_String],
            returnType : jl_String,
            callable : null
        }, {
            name : "getDisplayName",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "getDisplayName",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [ju_Locale],
            returnType : jl_String,
            callable : null
        }, {
            name : "getDisplayVariant",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "getDisplayVariant",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [ju_Locale],
            returnType : jl_String,
            callable : null
        }, {
            name : "getLanguage",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "getVariant",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "hashCode",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "setDefault",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [ju_Locale],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "toString",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "<clinit>",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }];
    jt_DateFormatSymbols.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [ju_Locale],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "clone",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_Object,
            callable : null
        }, {
            name : "equals",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "getAmPmStrings",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_arraycls(jl_String),
            callable : null
        }, {
            name : "getEras",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_arraycls(jl_String),
            callable : null
        }, {
            name : "getLocalPatternChars",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "getMonths",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_arraycls(jl_String),
            callable : null
        }, {
            name : "getShortMonths",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_arraycls(jl_String),
            callable : null
        }, {
            name : "getShortWeekdays",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_arraycls(jl_String),
            callable : null
        }, {
            name : "getWeekdays",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_arraycls(jl_String),
            callable : null
        }, {
            name : "getZoneStrings",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_arraycls($rt_arraycls(jl_String)),
            callable : null
        }, {
            name : "hashCode",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "setAmPmStrings",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls(jl_String)],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "setEras",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls(jl_String)],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "setLocalPatternChars",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "setMonths",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls(jl_String)],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "setShortMonths",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls(jl_String)],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "setShortWeekdays",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls(jl_String)],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "setWeekdays",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls(jl_String)],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "setZoneStrings",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_arraycls(jl_String))],
            returnType : $rt_voidcls(),
            callable : null
        }];
    nlea_EaglerAdapterImpl2$13.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [otjdh_HTMLImageElement, oti_AsyncCallback],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "handleEvent",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [otjde_Event],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "handleEvent$exported$0",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }];
    nlea_EaglerAdapterImpl2$14.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [otjdh_HTMLImageElement, oti_AsyncCallback],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "handleEvent",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [otjde_Event],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "handleEvent$exported$0",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [otj_JSObject],
            returnType : otj_JSObject,
            callable : null
        }];
    jnc_IllegalCharsetNameException.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getCharsetName",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }];
    jnc_Charset$Charsets.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "access$000",
            modifiers : 544,
            accessLevel : 0,
            parameterTypes : [],
            returnType : ju_Map,
            callable : null
        }, {
            name : "<clinit>",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }];
    cjj_Inflater.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [cjj_JZlib$WrapperType],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), cjj_JZlib$WrapperType],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_booleancls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_booleancls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "init",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "init",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [cjj_JZlib$WrapperType],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "init",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), cjj_JZlib$WrapperType],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "init",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_booleancls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "init",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "init",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_booleancls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "inflate",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "end",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "sync",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "syncPoint",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "setDictionary",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls()), $rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "finished",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }];
    cjj_ZStream.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [cjj_Checksum],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "inflateInit",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "inflateInit",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_booleancls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "inflateInit",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "inflateInit",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [cjj_JZlib$WrapperType],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "inflateInit",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), cjj_JZlib$WrapperType],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "inflateInit",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_booleancls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "inflate",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "inflateEnd",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "inflateSync",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "inflateSyncPoint",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "inflateSetDictionary",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls()), $rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "inflateFinished",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "deflateInit",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "deflateInit",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_booleancls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "deflateInit",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "deflateInit",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls(), $rt_intcls(), cjj_JZlib$WrapperType],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "deflateInit",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls(), $rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "deflateInit",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls(), $rt_booleancls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "deflate",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "deflateEnd",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "deflateParams",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "deflateSetDictionary",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls()), $rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "flush_pending",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "read_buf",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [$rt_arraycls($rt_bytecls()), $rt_intcls(), $rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getAdler",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_longcls(),
            callable : null
        }, {
            name : "free",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "setOutput",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls())],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "setOutput",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls()), $rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "setInput",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls())],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "setInput",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls()), $rt_booleancls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "setInput",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls()), $rt_intcls(), $rt_intcls(), $rt_booleancls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getNextIn",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_arraycls($rt_bytecls()),
            callable : null
        }, {
            name : "setNextIn",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls())],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getNextInIndex",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "setNextInIndex",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getAvailIn",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "setAvailIn",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getNextOut",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_arraycls($rt_bytecls()),
            callable : null
        }, {
            name : "setNextOut",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls())],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getNextOutIndex",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "setNextOutIndex",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getAvailOut",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "setAvailOut",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getTotalOut",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_longcls(),
            callable : null
        }, {
            name : "getTotalIn",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_longcls(),
            callable : null
        }, {
            name : "getMessage",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "end",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "finished",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }];
    nms_NBTTagEnd.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "load",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [ji_DataInput],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "write",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [ji_DataOutput],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getId",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_bytecls(),
            callable : null
        }, {
            name : "toString",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "copy",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : nms_NBTBase,
            callable : null
        }];
    jur_Pattern.$meta.methods = [
        {
            name : "matcher",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_CharSequence],
            returnType : jur_Matcher,
            callable : null
        }, {
            name : "split",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_CharSequence, $rt_intcls()],
            returnType : $rt_arraycls(jl_String),
            callable : null
        }, {
            name : "split",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_CharSequence],
            returnType : $rt_arraycls(jl_String),
            callable : null
        }, {
            name : "pattern",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "toString",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "flags",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "compile",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [jl_String, $rt_intcls()],
            returnType : jur_Pattern,
            callable : null
        }, {
            name : "compileImpl",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [jl_String, $rt_intcls()],
            returnType : jur_Pattern,
            callable : null
        }, {
            name : "processAlternations",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [jur_AbstractSet],
            returnType : jur_AbstractSet,
            callable : null
        }, {
            name : "processExpression",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [$rt_intcls(), $rt_intcls(), jur_AbstractSet],
            returnType : jur_AbstractSet,
            callable : null
        }, {
            name : "processSequence",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [],
            returnType : jur_AbstractSet,
            callable : null
        }, {
            name : "processDecomposedChar",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [],
            returnType : jur_AbstractSet,
            callable : null
        }, {
            name : "processSubExpression",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [jur_AbstractSet],
            returnType : jur_AbstractSet,
            callable : null
        }, {
            name : "processQuantifier",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [jur_AbstractSet, jur_AbstractSet],
            returnType : jur_AbstractSet,
            callable : null
        }, {
            name : "processTerminal",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [jur_AbstractSet],
            returnType : jur_AbstractSet,
            callable : null
        }, {
            name : "processRange",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [$rt_booleancls(), jur_AbstractSet],
            returnType : jur_AbstractSet,
            callable : null
        }, {
            name : "processRangeExpression",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [$rt_booleancls()],
            returnType : jur_CharClass,
            callable : null
        }, {
            name : "processCharSet",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [$rt_intcls()],
            returnType : jur_AbstractSet,
            callable : null
        }, {
            name : "processRangeSet",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [jur_AbstractCharClass],
            returnType : jur_AbstractSet,
            callable : null
        }, {
            name : "compile",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : jur_Pattern,
            callable : null
        }, {
            name : "finalizeCompile",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "matches",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [jl_String, jl_CharSequence],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "quote",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : jl_String,
            callable : null
        }, {
            name : "groupCount",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "compCount",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "consCount",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getSupplement",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [$rt_charcls()],
            returnType : $rt_charcls(),
            callable : null
        }, {
            name : "hasFlag",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }];
    ji_ByteArrayOutputStream.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "write",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "write",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls()), $rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "ensureCapacity",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "toByteArray",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_arraycls($rt_bytecls()),
            callable : null
        }, {
            name : "toString",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "toString",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : jl_String,
            callable : null
        }, {
            name : "writeTo",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [ji_OutputStream],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "reset",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "size",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }];
    ji_DataOutputStream.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [ji_OutputStream],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "flush",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "size",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "write",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls()), $rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "write",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "writeBoolean",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [$rt_booleancls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "writeByte",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "writeBytes",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "writeChar",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "writeChars",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "writeDouble",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [$rt_doublecls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "writeFloat",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [$rt_floatcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "writeInt",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "writeLong",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [$rt_longcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "writeLongToBuffer",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [$rt_longcls(), $rt_arraycls($rt_bytecls()), $rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "writeShort",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "writeShortToBuffer",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [$rt_intcls(), $rt_arraycls($rt_bytecls()), $rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "writeUTF",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "countUTFBytes",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [jl_String],
            returnType : $rt_longcls(),
            callable : null
        }, {
            name : "writeUTFBytesToBuffer",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [jl_String, $rt_arraycls($rt_bytecls()), $rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }];
    ji_DataOutput.$meta.methods = [
        {
            name : "write",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "write",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls())],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "write",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls()), $rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "writeBoolean",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_booleancls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "writeByte",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "writeShort",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "writeChar",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "writeInt",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "writeLong",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_longcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "writeFloat",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_floatcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "writeDouble",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_doublecls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "writeBytes",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "writeChars",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "writeUTF",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }];
    nleg_GLObjectMap.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "register",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "free",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : jl_Object,
            callable : null
        }, {
            name : "get",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : jl_Object,
            callable : null
        }, {
            name : "resize",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }];
    nlegv_Matrix4f.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [nlegv_Matrix4f],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "toString",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "setIdentity",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : nlegv_Matrix,
            callable : null
        }, {
            name : "setIdentity",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [nlegv_Matrix4f],
            returnType : nlegv_Matrix4f,
            callable : null
        }, {
            name : "setZero",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : nlegv_Matrix,
            callable : null
        }, {
            name : "setZero",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [nlegv_Matrix4f],
            returnType : nlegv_Matrix4f,
            callable : null
        }, {
            name : "load",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [nlegv_Matrix4f],
            returnType : nlegv_Matrix4f,
            callable : null
        }, {
            name : "load",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [nlegv_Matrix4f, nlegv_Matrix4f],
            returnType : nlegv_Matrix4f,
            callable : null
        }, {
            name : "load",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jn_FloatBuffer],
            returnType : nlegv_Matrix,
            callable : null
        }, {
            name : "loadTranspose",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jn_FloatBuffer],
            returnType : nlegv_Matrix,
            callable : null
        }, {
            name : "store",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jn_FloatBuffer],
            returnType : nlegv_Matrix,
            callable : null
        }, {
            name : "store",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_floatcls())],
            returnType : nlegv_Matrix,
            callable : null
        }, {
            name : "storeTranspose",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jn_FloatBuffer],
            returnType : nlegv_Matrix,
            callable : null
        }, {
            name : "store3f",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jn_FloatBuffer],
            returnType : nlegv_Matrix,
            callable : null
        }, {
            name : "add",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [nlegv_Matrix4f, nlegv_Matrix4f, nlegv_Matrix4f],
            returnType : nlegv_Matrix4f,
            callable : null
        }, {
            name : "sub",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [nlegv_Matrix4f, nlegv_Matrix4f, nlegv_Matrix4f],
            returnType : nlegv_Matrix4f,
            callable : null
        }, {
            name : "mul",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [nlegv_Matrix4f, nlegv_Matrix4f, nlegv_Matrix4f],
            returnType : nlegv_Matrix4f,
            callable : null
        }, {
            name : "transform",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [nlegv_Matrix4f, nlegv_Vector4f, nlegv_Vector4f],
            returnType : nlegv_Vector4f,
            callable : null
        }, {
            name : "transpose",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : nlegv_Matrix,
            callable : null
        }, {
            name : "translate",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [nlegv_Vector2f],
            returnType : nlegv_Matrix4f,
            callable : null
        }, {
            name : "translate",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [nlegv_Vector3f],
            returnType : nlegv_Matrix4f,
            callable : null
        }, {
            name : "scale",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [nlegv_Vector3f],
            returnType : nlegv_Matrix4f,
            callable : null
        }, {
            name : "scale",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [nlegv_Vector3f, nlegv_Matrix4f, nlegv_Matrix4f],
            returnType : nlegv_Matrix4f,
            callable : null
        }, {
            name : "rotate",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_floatcls(), nlegv_Vector3f],
            returnType : nlegv_Matrix4f,
            callable : null
        }, {
            name : "rotate",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_floatcls(), nlegv_Vector3f, nlegv_Matrix4f],
            returnType : nlegv_Matrix4f,
            callable : null
        }, {
            name : "rotate",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_floatcls(), nlegv_Vector3f, nlegv_Matrix4f, nlegv_Matrix4f],
            returnType : nlegv_Matrix4f,
            callable : null
        }, {
            name : "translate",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [nlegv_Vector3f, nlegv_Matrix4f],
            returnType : nlegv_Matrix4f,
            callable : null
        }, {
            name : "translate",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [nlegv_Vector3f, nlegv_Matrix4f, nlegv_Matrix4f],
            returnType : nlegv_Matrix4f,
            callable : null
        }, {
            name : "translate",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [nlegv_Vector2f, nlegv_Matrix4f],
            returnType : nlegv_Matrix4f,
            callable : null
        }, {
            name : "translate",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [nlegv_Vector2f, nlegv_Matrix4f, nlegv_Matrix4f],
            returnType : nlegv_Matrix4f,
            callable : null
        }, {
            name : "transpose",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [nlegv_Matrix4f],
            returnType : nlegv_Matrix4f,
            callable : null
        }, {
            name : "transpose",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [nlegv_Matrix4f, nlegv_Matrix4f],
            returnType : nlegv_Matrix4f,
            callable : null
        }, {
            name : "determinant",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_floatcls(),
            callable : null
        }, {
            name : "determinant3x3",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [$rt_floatcls(), $rt_floatcls(), $rt_floatcls(), $rt_floatcls(), $rt_floatcls(), $rt_floatcls(), $rt_floatcls(), $rt_floatcls(), $rt_floatcls()],
            returnType : $rt_floatcls(),
            callable : null
        }, {
            name : "invert",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : nlegv_Matrix,
            callable : null
        }, {
            name : "invert",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [nlegv_Matrix4f, nlegv_Matrix4f],
            returnType : nlegv_Matrix4f,
            callable : null
        }, {
            name : "negate",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : nlegv_Matrix,
            callable : null
        }, {
            name : "negate",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [nlegv_Matrix4f],
            returnType : nlegv_Matrix4f,
            callable : null
        }, {
            name : "negate",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [nlegv_Matrix4f, nlegv_Matrix4f],
            returnType : nlegv_Matrix4f,
            callable : null
        }, {
            name : "equals",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "equal",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [nlegv_Matrix4f, nlegv_Matrix4f],
            returnType : $rt_booleancls(),
            callable : null
        }];
    nlegv_Matrix.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "setIdentity",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : nlegv_Matrix,
            callable : null
        }, {
            name : "invert",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : nlegv_Matrix,
            callable : null
        }, {
            name : "load",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [jn_FloatBuffer],
            returnType : nlegv_Matrix,
            callable : null
        }, {
            name : "loadTranspose",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [jn_FloatBuffer],
            returnType : nlegv_Matrix,
            callable : null
        }, {
            name : "negate",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : nlegv_Matrix,
            callable : null
        }, {
            name : "store",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [jn_FloatBuffer],
            returnType : nlegv_Matrix,
            callable : null
        }, {
            name : "storeTranspose",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [jn_FloatBuffer],
            returnType : nlegv_Matrix,
            callable : null
        }, {
            name : "transpose",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : nlegv_Matrix,
            callable : null
        }, {
            name : "setZero",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : nlegv_Matrix,
            callable : null
        }, {
            name : "determinant",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_floatcls(),
            callable : null
        }];
    nlegv_Vector3f.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [nlegv_ReadableVector3f],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_floatcls(), $rt_floatcls(), $rt_floatcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "set",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_floatcls(), $rt_floatcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "set",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_floatcls(), $rt_floatcls(), $rt_floatcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "set",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [nlegv_ReadableVector3f],
            returnType : nlegv_Vector3f,
            callable : null
        }, {
            name : "lengthSquared",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_floatcls(),
            callable : null
        }, {
            name : "translate",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_floatcls(), $rt_floatcls(), $rt_floatcls()],
            returnType : nlegv_Vector3f,
            callable : null
        }, {
            name : "add",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [nlegv_Vector3f, nlegv_Vector3f, nlegv_Vector3f],
            returnType : nlegv_Vector3f,
            callable : null
        }, {
            name : "sub",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [nlegv_Vector3f, nlegv_Vector3f, nlegv_Vector3f],
            returnType : nlegv_Vector3f,
            callable : null
        }, {
            name : "cross",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [nlegv_Vector3f, nlegv_Vector3f, nlegv_Vector3f],
            returnType : nlegv_Vector3f,
            callable : null
        }, {
            name : "negate",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : nlegv_Vector,
            callable : null
        }, {
            name : "negate",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [nlegv_Vector3f],
            returnType : nlegv_Vector3f,
            callable : null
        }, {
            name : "normalise",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [nlegv_Vector3f],
            returnType : nlegv_Vector3f,
            callable : null
        }, {
            name : "dot",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [nlegv_Vector3f, nlegv_Vector3f],
            returnType : $rt_floatcls(),
            callable : null
        }, {
            name : "angle",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [nlegv_Vector3f, nlegv_Vector3f],
            returnType : $rt_floatcls(),
            callable : null
        }, {
            name : "load",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jn_FloatBuffer],
            returnType : nlegv_Vector,
            callable : null
        }, {
            name : "scale",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_floatcls()],
            returnType : nlegv_Vector,
            callable : null
        }, {
            name : "store",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jn_FloatBuffer],
            returnType : nlegv_Vector,
            callable : null
        }, {
            name : "toString",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "getX",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_floatcls(),
            callable : null
        }, {
            name : "getY",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_floatcls(),
            callable : null
        }, {
            name : "setX",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [$rt_floatcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "setY",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [$rt_floatcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "setZ",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_floatcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getZ",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_floatcls(),
            callable : null
        }, {
            name : "equals",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_booleancls(),
            callable : null
        }];
    nlegv_Vector.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "length",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_floatcls(),
            callable : null
        }, {
            name : "lengthSquared",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_floatcls(),
            callable : null
        }, {
            name : "load",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [jn_FloatBuffer],
            returnType : nlegv_Vector,
            callable : null
        }, {
            name : "negate",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : nlegv_Vector,
            callable : null
        }, {
            name : "normalise",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [],
            returnType : nlegv_Vector,
            callable : null
        }, {
            name : "store",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [jn_FloatBuffer],
            returnType : nlegv_Vector,
            callable : null
        }, {
            name : "scale",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_floatcls()],
            returnType : nlegv_Vector,
            callable : null
        }];
    nlegv_ReadableVector.$meta.methods = [
        {
            name : "length",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_floatcls(),
            callable : null
        }, {
            name : "lengthSquared",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_floatcls(),
            callable : null
        }, {
            name : "store",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [jn_FloatBuffer],
            returnType : nlegv_Vector,
            callable : null
        }];
    nlegv_ReadableVector3f.$meta.methods = [
        {
            name : "getZ",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_floatcls(),
            callable : null
        }];
    nlegv_ReadableVector2f.$meta.methods = [
        {
            name : "getX",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_floatcls(),
            callable : null
        }, {
            name : "getY",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_floatcls(),
            callable : null
        }];
    nlegv_WritableVector3f.$meta.methods = [
        {
            name : "setZ",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_floatcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "set",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_floatcls(), $rt_floatcls(), $rt_floatcls()],
            returnType : $rt_voidcls(),
            callable : null
        }];
    nlegv_WritableVector2f.$meta.methods = [
        {
            name : "setX",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_floatcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "setY",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_floatcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "set",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_floatcls(), $rt_floatcls()],
            returnType : $rt_voidcls(),
            callable : null
        }];
    nlegv_Vector4f.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [nlegv_ReadableVector4f],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_floatcls(), $rt_floatcls(), $rt_floatcls(), $rt_floatcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "set",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_floatcls(), $rt_floatcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "set",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_floatcls(), $rt_floatcls(), $rt_floatcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "set",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_floatcls(), $rt_floatcls(), $rt_floatcls(), $rt_floatcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "set",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [nlegv_ReadableVector4f],
            returnType : nlegv_Vector4f,
            callable : null
        }, {
            name : "lengthSquared",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_floatcls(),
            callable : null
        }, {
            name : "translate",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_floatcls(), $rt_floatcls(), $rt_floatcls(), $rt_floatcls()],
            returnType : nlegv_Vector4f,
            callable : null
        }, {
            name : "add",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [nlegv_Vector4f, nlegv_Vector4f, nlegv_Vector4f],
            returnType : nlegv_Vector4f,
            callable : null
        }, {
            name : "sub",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [nlegv_Vector4f, nlegv_Vector4f, nlegv_Vector4f],
            returnType : nlegv_Vector4f,
            callable : null
        }, {
            name : "negate",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : nlegv_Vector,
            callable : null
        }, {
            name : "negate",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [nlegv_Vector4f],
            returnType : nlegv_Vector4f,
            callable : null
        }, {
            name : "normalise",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [nlegv_Vector4f],
            returnType : nlegv_Vector4f,
            callable : null
        }, {
            name : "dot",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [nlegv_Vector4f, nlegv_Vector4f],
            returnType : $rt_floatcls(),
            callable : null
        }, {
            name : "angle",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [nlegv_Vector4f, nlegv_Vector4f],
            returnType : $rt_floatcls(),
            callable : null
        }, {
            name : "load",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jn_FloatBuffer],
            returnType : nlegv_Vector,
            callable : null
        }, {
            name : "scale",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_floatcls()],
            returnType : nlegv_Vector,
            callable : null
        }, {
            name : "store",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jn_FloatBuffer],
            returnType : nlegv_Vector,
            callable : null
        }, {
            name : "toString",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "getX",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_floatcls(),
            callable : null
        }, {
            name : "getY",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_floatcls(),
            callable : null
        }, {
            name : "setX",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [$rt_floatcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "setY",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [$rt_floatcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "setZ",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_floatcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getZ",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_floatcls(),
            callable : null
        }, {
            name : "setW",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_floatcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getW",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_floatcls(),
            callable : null
        }, {
            name : "equals",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_booleancls(),
            callable : null
        }];
    nlegv_ReadableVector4f.$meta.methods = [
        {
            name : "getW",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_floatcls(),
            callable : null
        }];
    nlegv_WritableVector4f.$meta.methods = [
        {
            name : "setW",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_floatcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "set",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_floatcls(), $rt_floatcls(), $rt_floatcls(), $rt_floatcls()],
            returnType : $rt_voidcls(),
            callable : null
        }];
    jn_ByteBufferImpl.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_booleancls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls(), $rt_arraycls($rt_bytecls()), $rt_intcls(), $rt_intcls(), $rt_booleancls(), $rt_booleancls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "slice",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jn_ByteBuffer,
            callable : null
        }, {
            name : "duplicate",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jn_ByteBuffer,
            callable : null
        }, {
            name : "asReadOnlyBuffer",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jn_ByteBuffer,
            callable : null
        }, {
            name : "get",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_bytecls(),
            callable : null
        }, {
            name : "put",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_bytecls()],
            returnType : jn_ByteBuffer,
            callable : null
        }, {
            name : "get",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_bytecls(),
            callable : null
        }, {
            name : "put",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_bytecls()],
            returnType : jn_ByteBuffer,
            callable : null
        }, {
            name : "compact",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jn_ByteBuffer,
            callable : null
        }, {
            name : "isDirect",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "isReadOnly",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "getChar",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_charcls(),
            callable : null
        }, {
            name : "putChar",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_charcls()],
            returnType : jn_ByteBuffer,
            callable : null
        }, {
            name : "getChar",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_charcls(),
            callable : null
        }, {
            name : "putChar",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_charcls()],
            returnType : jn_ByteBuffer,
            callable : null
        }, {
            name : "asCharBuffer",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jn_CharBuffer,
            callable : null
        }, {
            name : "getShort",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_shortcls(),
            callable : null
        }, {
            name : "putShort",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_shortcls()],
            returnType : jn_ByteBuffer,
            callable : null
        }, {
            name : "getShort",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_shortcls(),
            callable : null
        }, {
            name : "putShort",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_shortcls()],
            returnType : jn_ByteBuffer,
            callable : null
        }, {
            name : "asShortBuffer",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jn_ShortBuffer,
            callable : null
        }, {
            name : "getInt",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "putInt",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : jn_ByteBuffer,
            callable : null
        }, {
            name : "getInt",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "putInt",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : jn_ByteBuffer,
            callable : null
        }, {
            name : "asIntBuffer",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jn_IntBuffer,
            callable : null
        }, {
            name : "getLong",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_longcls(),
            callable : null
        }, {
            name : "putLong",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_longcls()],
            returnType : jn_ByteBuffer,
            callable : null
        }, {
            name : "getLong",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_longcls(),
            callable : null
        }, {
            name : "putLong",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_longcls()],
            returnType : jn_ByteBuffer,
            callable : null
        }, {
            name : "asLongBuffer",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jn_LongBuffer,
            callable : null
        }, {
            name : "asFloatBuffer",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jn_FloatBuffer,
            callable : null
        }, {
            name : "asDoubleBuffer",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jn_DoubleBuffer,
            callable : null
        }];
    jn_ByteOrder.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "nativeOrder",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jn_ByteOrder,
            callable : null
        }, {
            name : "toString",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "<clinit>",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }];
    jn_IntBufferOverArray.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls(), $rt_arraycls($rt_intcls()), $rt_intcls(), $rt_intcls(), $rt_booleancls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "duplicate",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [$rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_booleancls()],
            returnType : jn_IntBuffer,
            callable : null
        }, {
            name : "getElement",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "putElement",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "isArrayPresent",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "getArray",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_arraycls($rt_intcls()),
            callable : null
        }, {
            name : "getArrayOffset",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "readOnly",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "order",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jn_ByteOrder,
            callable : null
        }];
    jn_IntBufferImpl.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "slice",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jn_IntBuffer,
            callable : null
        }, {
            name : "duplicate",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jn_IntBuffer,
            callable : null
        }, {
            name : "asReadOnlyBuffer",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jn_IntBuffer,
            callable : null
        }, {
            name : "duplicate",
            modifiers : 1,
            accessLevel : 0,
            parameterTypes : [$rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_booleancls()],
            returnType : jn_IntBuffer,
            callable : null
        }, {
            name : "get",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "put",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : jn_IntBuffer,
            callable : null
        }, {
            name : "get",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "put",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : jn_IntBuffer,
            callable : null
        }, {
            name : "compact",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jn_IntBuffer,
            callable : null
        }, {
            name : "isDirect",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "isReadOnly",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "readOnly",
            modifiers : 1,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }];
    jn_CharBuffer.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [$rt_intcls(), $rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getChar",
            modifiers : 1,
            accessLevel : 0,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_charcls(),
            callable : null
        }, {
            name : "putChar",
            modifiers : 1,
            accessLevel : 0,
            parameterTypes : [$rt_intcls(), $rt_charcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "allocate",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : jn_CharBuffer,
            callable : null
        }, {
            name : "wrap",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_charcls()), $rt_intcls(), $rt_intcls()],
            returnType : jn_CharBuffer,
            callable : null
        }, {
            name : "wrap",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_charcls())],
            returnType : jn_CharBuffer,
            callable : null
        }, {
            name : "read",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jn_CharBuffer],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "wrap",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [jl_CharSequence, $rt_intcls(), $rt_intcls()],
            returnType : jn_CharBuffer,
            callable : null
        }, {
            name : "wrap",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [jl_CharSequence],
            returnType : jn_CharBuffer,
            callable : null
        }, {
            name : "slice",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jn_CharBuffer,
            callable : null
        }, {
            name : "duplicate",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jn_CharBuffer,
            callable : null
        }, {
            name : "asReadOnlyBuffer",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jn_CharBuffer,
            callable : null
        }, {
            name : "get",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_charcls(),
            callable : null
        }, {
            name : "put",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_charcls()],
            returnType : jn_CharBuffer,
            callable : null
        }, {
            name : "get",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_charcls(),
            callable : null
        }, {
            name : "put",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_charcls()],
            returnType : jn_CharBuffer,
            callable : null
        }, {
            name : "get",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_charcls()), $rt_intcls(), $rt_intcls()],
            returnType : jn_CharBuffer,
            callable : null
        }, {
            name : "get",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_charcls())],
            returnType : jn_CharBuffer,
            callable : null
        }, {
            name : "put",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jn_CharBuffer],
            returnType : jn_CharBuffer,
            callable : null
        }, {
            name : "put",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_charcls()), $rt_intcls(), $rt_intcls()],
            returnType : jn_CharBuffer,
            callable : null
        }, {
            name : "put",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_charcls())],
            returnType : jn_CharBuffer,
            callable : null
        }, {
            name : "put",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String, $rt_intcls(), $rt_intcls()],
            returnType : jn_CharBuffer,
            callable : null
        }, {
            name : "put",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : jn_CharBuffer,
            callable : null
        }, {
            name : "hasArray",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "array",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_arraycls($rt_charcls()),
            callable : null
        }, {
            name : "arrayOffset",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "isArrayPresent",
            modifiers : 1,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "getArray",
            modifiers : 1,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_arraycls($rt_charcls()),
            callable : null
        }, {
            name : "getArrayOffset",
            modifiers : 1,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "compact",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jn_CharBuffer,
            callable : null
        }, {
            name : "isDirect",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "hashCode",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "equals",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "compareTo",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jn_CharBuffer],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "toString",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "length",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "charAt",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_charcls(),
            callable : null
        }, {
            name : "subSequence",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : jn_CharBuffer,
            callable : null
        }, {
            name : "append",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_CharSequence],
            returnType : jn_CharBuffer,
            callable : null
        }, {
            name : "append",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_CharSequence, $rt_intcls(), $rt_intcls()],
            returnType : jn_CharBuffer,
            callable : null
        }, {
            name : "append",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_charcls()],
            returnType : jn_CharBuffer,
            callable : null
        }, {
            name : "order",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jn_ByteOrder,
            callable : null
        }, {
            name : "mark",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jn_CharBuffer,
            callable : null
        }, {
            name : "reset",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jn_CharBuffer,
            callable : null
        }, {
            name : "clear",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jn_CharBuffer,
            callable : null
        }, {
            name : "flip",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jn_CharBuffer,
            callable : null
        }, {
            name : "rewind",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jn_CharBuffer,
            callable : null
        }, {
            name : "limit",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : jn_CharBuffer,
            callable : null
        }, {
            name : "position",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : jn_CharBuffer,
            callable : null
        }, {
            name : "array",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_Object,
            callable : null
        }, {
            name : "rewind",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jn_Buffer,
            callable : null
        }, {
            name : "flip",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jn_Buffer,
            callable : null
        }, {
            name : "clear",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jn_Buffer,
            callable : null
        }, {
            name : "reset",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jn_Buffer,
            callable : null
        }, {
            name : "mark",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jn_Buffer,
            callable : null
        }, {
            name : "limit",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : jn_Buffer,
            callable : null
        }, {
            name : "position",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : jn_Buffer,
            callable : null
        }, {
            name : "compareTo",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "append",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [$rt_charcls()],
            returnType : jl_Appendable,
            callable : null
        }, {
            name : "append",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [jl_CharSequence, $rt_intcls(), $rt_intcls()],
            returnType : jl_Appendable,
            callable : null
        }, {
            name : "append",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [jl_CharSequence],
            returnType : jl_Appendable,
            callable : null
        }, {
            name : "subSequence",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : jl_CharSequence,
            callable : null
        }];
    jl_Readable.$meta.methods = [
        {
            name : "read",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [jn_CharBuffer],
            returnType : $rt_intcls(),
            callable : null
        }];
    nms_NBTTagByte.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String, $rt_bytecls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "write",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [ji_DataOutput],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "load",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [ji_DataInput],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getId",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_bytecls(),
            callable : null
        }, {
            name : "toString",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "copy",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : nms_NBTBase,
            callable : null
        }, {
            name : "equals",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "hashCode",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }];
    nms_NBTTagShort.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String, $rt_shortcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "write",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [ji_DataOutput],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "load",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [ji_DataInput],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getId",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_bytecls(),
            callable : null
        }, {
            name : "toString",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "copy",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : nms_NBTBase,
            callable : null
        }, {
            name : "equals",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "hashCode",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }];
    nms_NBTTagInt.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String, $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "write",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [ji_DataOutput],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "load",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [ji_DataInput],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getId",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_bytecls(),
            callable : null
        }, {
            name : "toString",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "copy",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : nms_NBTBase,
            callable : null
        }, {
            name : "equals",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "hashCode",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }];
    nms_NBTTagLong.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String, $rt_longcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "write",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [ji_DataOutput],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "load",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [ji_DataInput],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getId",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_bytecls(),
            callable : null
        }, {
            name : "toString",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "copy",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : nms_NBTBase,
            callable : null
        }, {
            name : "equals",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "hashCode",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }];
    nms_NBTTagFloat.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String, $rt_floatcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "write",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [ji_DataOutput],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "load",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [ji_DataInput],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getId",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_bytecls(),
            callable : null
        }, {
            name : "toString",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "copy",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : nms_NBTBase,
            callable : null
        }, {
            name : "equals",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "hashCode",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }];
    nms_NBTTagDouble.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String, $rt_doublecls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "write",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [ji_DataOutput],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "load",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [ji_DataInput],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getId",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_bytecls(),
            callable : null
        }, {
            name : "toString",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "copy",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : nms_NBTBase,
            callable : null
        }, {
            name : "equals",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "hashCode",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }];
    nms_NBTTagByteArray.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String, $rt_arraycls($rt_bytecls())],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "write",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [ji_DataOutput],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "load",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [ji_DataInput],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getId",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_bytecls(),
            callable : null
        }, {
            name : "toString",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "copy",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : nms_NBTBase,
            callable : null
        }, {
            name : "equals",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "hashCode",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }];
    nms_NBTTagString.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String, jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "write",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [ji_DataOutput],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "load",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [ji_DataInput],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getId",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_bytecls(),
            callable : null
        }, {
            name : "toString",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "copy",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : nms_NBTBase,
            callable : null
        }, {
            name : "equals",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "hashCode",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }];
    nms_NBTTagIntArray.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String, $rt_arraycls($rt_intcls())],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "write",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [ji_DataOutput],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "load",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [ji_DataInput],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getId",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_bytecls(),
            callable : null
        }, {
            name : "toString",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "copy",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : nms_NBTBase,
            callable : null
        }, {
            name : "equals",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "hashCode",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }];
    jl_NullPointerException.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }];
    otjb_Performance.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "now",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_doublecls(),
            callable : null
        }, {
            name : "isSupported",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "now$js_body$_1",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [],
            returnType : otj_JSObject,
            callable : null
        }, {
            name : "isSupported$js_body$_2",
            modifiers : 768,
            accessLevel : 0,
            parameterTypes : [],
            returnType : otj_JSObject,
            callable : null
        }];
    nle_GuiScreenEditProfile.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [nms_GuiScreen],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "reconcatDD",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "initGui",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "drawScreen",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls(), $rt_floatcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "handleMouseInput",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "save",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "actionPerformed",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [nms_GuiButton],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "updateScreen",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "onGuiClosed",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "keyTyped",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [$rt_charcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "mouseClicked",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [$rt_intcls(), $rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<clinit>",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }];
    nms_GuiScreen.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "drawScreen",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls(), $rt_floatcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "keyTyped",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [$rt_charcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getClipboardString",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "setClipboardString",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "mouseClicked",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [$rt_intcls(), $rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "mouseMovedOrUp",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [$rt_intcls(), $rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "func_85041_a",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [$rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_longcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "actionPerformed",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [nms_GuiButton],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "setWorldAndResolution",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [nmc_Minecraft, $rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "initGui",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "handleInput",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "handleMouseInput",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "handleKeyboardInput",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "updateScreen",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "onGuiClosed",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "drawDefaultBackground",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "drawWorldBackground",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "drawBackground",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "doesGuiPauseGame",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "confirmClicked",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_booleancls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "isCtrlKeyDown",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "isShiftKeyDown",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "<clinit>",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }];
    nms_Gui.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "drawHorizontalLine",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [$rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "drawVerticalLine",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [$rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "drawRect",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "drawGradientRect",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "drawCenteredString",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [nms_FontRenderer, jl_String, $rt_intcls(), $rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "drawString",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [nms_FontRenderer, jl_String, $rt_intcls(), $rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "drawTexturedModalRect",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "static_drawTexturedModalRect",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "drawTexturedModelRectFromIcon",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls(), nms_Icon, $rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }];
    otciu_CLDRHelper.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getCode",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [jl_String, jl_String],
            returnType : jl_String,
            callable : null
        }, {
            name : "getLikelySubtags",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : jl_String,
            callable : null
        }, {
            name : "resolveCountry",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [jl_String, jl_String],
            returnType : jl_String,
            callable : null
        }, {
            name : "getLikelySubtagsMap",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [],
            returnType : otpm_ResourceMap,
            callable : null
        }, {
            name : "resolveEras",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [jl_String, jl_String],
            returnType : $rt_arraycls(jl_String),
            callable : null
        }, {
            name : "getErasMap",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [],
            returnType : otpm_ResourceMap,
            callable : null
        }, {
            name : "resolveAmPm",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [jl_String, jl_String],
            returnType : $rt_arraycls(jl_String),
            callable : null
        }, {
            name : "getAmPmMap",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [],
            returnType : otpm_ResourceMap,
            callable : null
        }, {
            name : "resolveMonths",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [jl_String, jl_String],
            returnType : $rt_arraycls(jl_String),
            callable : null
        }, {
            name : "getMonthMap",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [],
            returnType : otpm_ResourceMap,
            callable : null
        }, {
            name : "resolveShortMonths",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [jl_String, jl_String],
            returnType : $rt_arraycls(jl_String),
            callable : null
        }, {
            name : "getShortMonthMap",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [],
            returnType : otpm_ResourceMap,
            callable : null
        }, {
            name : "resolveWeekdays",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [jl_String, jl_String],
            returnType : $rt_arraycls(jl_String),
            callable : null
        }, {
            name : "getWeekdayMap",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [],
            returnType : otpm_ResourceMap,
            callable : null
        }, {
            name : "resolveShortWeekdays",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [jl_String, jl_String],
            returnType : $rt_arraycls(jl_String),
            callable : null
        }, {
            name : "getShortWeekdayMap",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [],
            returnType : otpm_ResourceMap,
            callable : null
        }, {
            name : "resolveDateFormatSymbols",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [otpm_ResourceMap, jl_String, jl_String],
            returnType : $rt_arraycls(jl_String),
            callable : null
        }, {
            name : "getTimeZoneName",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [jl_String, jl_String, jl_String],
            returnType : jl_String,
            callable : null
        }, {
            name : "getTimeZoneLocalizationMap",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [],
            returnType : otpm_ResourceMap,
            callable : null
        }, {
            name : "getLanguagesMap",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [],
            returnType : otpm_ResourceMap,
            callable : null
        }, {
            name : "getCountriesMap",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [],
            returnType : otpm_ResourceMap,
            callable : null
        }, {
            name : "getDefaultLocale",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [],
            returnType : otpm_StringResource,
            callable : null
        }, {
            name : "getAvailableLocales",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [],
            returnType : otpm_ResourceArray,
            callable : null
        }, {
            name : "getMinimalDaysInFirstWeek",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [],
            returnType : otpm_ResourceMap,
            callable : null
        }, {
            name : "getFirstDayOfWeek",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [],
            returnType : otpm_ResourceMap,
            callable : null
        }, {
            name : "resolveDateFormats",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [jl_String, jl_String],
            returnType : otciu_DateFormatCollection,
            callable : null
        }, {
            name : "getDateFormatMap",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [],
            returnType : otpm_ResourceMap,
            callable : null
        }, {
            name : "resolveTimeFormats",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [jl_String, jl_String],
            returnType : otciu_DateFormatCollection,
            callable : null
        }, {
            name : "getTimeFormatMap",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [],
            returnType : otpm_ResourceMap,
            callable : null
        }, {
            name : "resolveDateTimeFormats",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [jl_String, jl_String],
            returnType : otciu_DateFormatCollection,
            callable : null
        }, {
            name : "getDateTimeFormatMap",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [],
            returnType : otpm_ResourceMap,
            callable : null
        }, {
            name : "resolveNumberFormat",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [jl_String, jl_String],
            returnType : jl_String,
            callable : null
        }, {
            name : "getNumberFormatMap",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [],
            returnType : otpm_ResourceMap,
            callable : null
        }, {
            name : "resolvePercentFormat",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [jl_String, jl_String],
            returnType : jl_String,
            callable : null
        }, {
            name : "getPercentFormatMap",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [],
            returnType : otpm_ResourceMap,
            callable : null
        }, {
            name : "resolveCurrencyFormat",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [jl_String, jl_String],
            returnType : jl_String,
            callable : null
        }, {
            name : "getCurrencyFormatMap",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [],
            returnType : otpm_ResourceMap,
            callable : null
        }, {
            name : "resolveDateFormats",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [otpm_ResourceMap, jl_String, jl_String],
            returnType : otciu_DateFormatCollection,
            callable : null
        }, {
            name : "resolveFormatSymbols",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [otpm_ResourceMap, jl_String, jl_String],
            returnType : jl_String,
            callable : null
        }, {
            name : "resolveDecimalData",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [jl_String, jl_String],
            returnType : otciu_DecimalData,
            callable : null
        }, {
            name : "getDecimalDataMap",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [],
            returnType : otpm_ResourceMap,
            callable : null
        }, {
            name : "resolveCurrency",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [jl_String, jl_String, jl_String],
            returnType : otciu_CurrencyLocalization,
            callable : null
        }, {
            name : "getCurrencyMap",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [],
            returnType : otpm_ResourceMap,
            callable : null
        }, {
            name : "getLikelySubtagsMap$$create",
            modifiers : 768,
            accessLevel : 1,
            parameterTypes : [],
            returnType : otpm_ResourceMap,
            callable : null
        }, {
            name : "getErasMap$$create",
            modifiers : 768,
            accessLevel : 1,
            parameterTypes : [],
            returnType : otpm_ResourceMap,
            callable : null
        }, {
            name : "getAmPmMap$$create",
            modifiers : 768,
            accessLevel : 1,
            parameterTypes : [],
            returnType : otpm_ResourceMap,
            callable : null
        }, {
            name : "getMonthMap$$create",
            modifiers : 768,
            accessLevel : 1,
            parameterTypes : [],
            returnType : otpm_ResourceMap,
            callable : null
        }, {
            name : "getShortMonthMap$$create",
            modifiers : 768,
            accessLevel : 1,
            parameterTypes : [],
            returnType : otpm_ResourceMap,
            callable : null
        }, {
            name : "getWeekdayMap$$create",
            modifiers : 768,
            accessLevel : 1,
            parameterTypes : [],
            returnType : otpm_ResourceMap,
            callable : null
        }, {
            name : "getShortWeekdayMap$$create",
            modifiers : 768,
            accessLevel : 1,
            parameterTypes : [],
            returnType : otpm_ResourceMap,
            callable : null
        }, {
            name : "getTimeZoneLocalizationMap$$create",
            modifiers : 768,
            accessLevel : 1,
            parameterTypes : [],
            returnType : otpm_ResourceMap,
            callable : null
        }, {
            name : "getLanguagesMap$$create",
            modifiers : 768,
            accessLevel : 1,
            parameterTypes : [],
            returnType : otpm_ResourceMap,
            callable : null
        }, {
            name : "getCountriesMap$$create",
            modifiers : 768,
            accessLevel : 1,
            parameterTypes : [],
            returnType : otpm_ResourceMap,
            callable : null
        }, {
            name : "getDefaultLocale$$create",
            modifiers : 768,
            accessLevel : 1,
            parameterTypes : [],
            returnType : otpm_StringResource,
            callable : null
        }, {
            name : "getAvailableLocales$$create",
            modifiers : 768,
            accessLevel : 1,
            parameterTypes : [],
            returnType : otpm_ResourceArray,
            callable : null
        }, {
            name : "getMinimalDaysInFirstWeek$$create",
            modifiers : 768,
            accessLevel : 1,
            parameterTypes : [],
            returnType : otpm_ResourceMap,
            callable : null
        }, {
            name : "getFirstDayOfWeek$$create",
            modifiers : 768,
            accessLevel : 1,
            parameterTypes : [],
            returnType : otpm_ResourceMap,
            callable : null
        }, {
            name : "getDateFormatMap$$create",
            modifiers : 768,
            accessLevel : 1,
            parameterTypes : [],
            returnType : otpm_ResourceMap,
            callable : null
        }, {
            name : "getTimeFormatMap$$create",
            modifiers : 768,
            accessLevel : 1,
            parameterTypes : [],
            returnType : otpm_ResourceMap,
            callable : null
        }, {
            name : "getDateTimeFormatMap$$create",
            modifiers : 768,
            accessLevel : 1,
            parameterTypes : [],
            returnType : otpm_ResourceMap,
            callable : null
        }, {
            name : "getNumberFormatMap$$create",
            modifiers : 768,
            accessLevel : 1,
            parameterTypes : [],
            returnType : otpm_ResourceMap,
            callable : null
        }, {
            name : "getPercentFormatMap$$create",
            modifiers : 768,
            accessLevel : 1,
            parameterTypes : [],
            returnType : otpm_ResourceMap,
            callable : null
        }, {
            name : "getCurrencyFormatMap$$create",
            modifiers : 768,
            accessLevel : 1,
            parameterTypes : [],
            returnType : otpm_ResourceMap,
            callable : null
        }, {
            name : "getDecimalDataMap$$create",
            modifiers : 768,
            accessLevel : 1,
            parameterTypes : [],
            returnType : otpm_ResourceMap,
            callable : null
        }, {
            name : "getCurrencyMap$$create",
            modifiers : 768,
            accessLevel : 1,
            parameterTypes : [],
            returnType : otpm_ResourceMap,
            callable : null
        }];
    otpp_ResourceAccessor.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getProperty",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [jl_Object, jl_String],
            returnType : jl_Object,
            callable : null
        }, {
            name : "get",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [jl_Object, jl_String],
            returnType : otpm_Resource,
            callable : null
        }, {
            name : "keys",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : jl_Object,
            callable : null
        }, {
            name : "keysToStrings",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_arraycls(jl_String),
            callable : null
        }, {
            name : "put",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [jl_Object, jl_String, jl_Object],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "get",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [jl_Object, $rt_intcls()],
            returnType : otpm_Resource,
            callable : null
        }, {
            name : "add",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [jl_Object, otpm_Resource],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "has",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [jl_Object, jl_String],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "size",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "castToInt",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "castToShort",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_shortcls(),
            callable : null
        }, {
            name : "castToByte",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_bytecls(),
            callable : null
        }, {
            name : "castToBoolean",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "castToFloat",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_floatcls(),
            callable : null
        }, {
            name : "castToDouble",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_doublecls(),
            callable : null
        }, {
            name : "castToString",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : jl_String,
            callable : null
        }, {
            name : "castFromInt",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : jl_Object,
            callable : null
        }, {
            name : "castFromShort",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [$rt_shortcls()],
            returnType : jl_Object,
            callable : null
        }, {
            name : "castFromByte",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [$rt_bytecls()],
            returnType : jl_Object,
            callable : null
        }, {
            name : "castFromBoolean",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [$rt_booleancls()],
            returnType : jl_Object,
            callable : null
        }, {
            name : "castFromFloat",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [$rt_floatcls()],
            returnType : jl_Object,
            callable : null
        }, {
            name : "castFromDouble",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [$rt_doublecls()],
            returnType : jl_Object,
            callable : null
        }, {
            name : "castFromString",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : jl_Object,
            callable : null
        }];
    cjj_GZIPException.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }];
    jur_AbstractSet.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_AbstractSet],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "matches",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_CharSequence, jur_MatchResultImpl],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "find",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_CharSequence, jur_MatchResultImpl],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "findBack",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls(), jl_CharSequence, jur_MatchResultImpl],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "hasConsumed",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [jur_MatchResultImpl],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "getName",
            modifiers : 1,
            accessLevel : 2,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "setType",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getType",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getQualifiedName",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "toString",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "getNext",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jur_AbstractSet,
            callable : null
        }, {
            name : "setNext",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_AbstractSet],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "first",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_AbstractSet],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "processBackRefReplacement",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jur_JointSet,
            callable : null
        }, {
            name : "processSecondPass",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<clinit>",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }];
    jur_FSet.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "matches",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_CharSequence, jur_MatchResultImpl],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getGroupIndex",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getName",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "hasConsumed",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_MatchResultImpl],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "<clinit>",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }];
    jur_Lexer.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String, $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "peek",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "setMode",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "restoreFlags",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "peekSpecial",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jur_SpecialToken,
            callable : null
        }, {
            name : "isSpecial",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "isQuantifier",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "isNextSpecial",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "next",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "nextSpecial",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jur_SpecialToken,
            callable : null
        }, {
            name : "lookAhead",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "back",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "normalize",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [jl_String],
            returnType : jl_String,
            callable : null
        }, {
            name : "reread",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "movePointer",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "parseCharClassName",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "processQuantifier",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [$rt_intcls()],
            returnType : jur_Quantifier,
            callable : null
        }, {
            name : "toString",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "isEmpty",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "isLetter",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "isLetter",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "isHighSurrogate",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "isLowSurrogate",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "isHighSurrogate",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "isLowSurrogate",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "readHex",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "readOctals",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "readFlags",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "nextIndex",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "skipComments",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "isLineSeparator",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "getDecomposition",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_arraycls($rt_intcls()),
            callable : null
        }, {
            name : "getHangulDecomposition",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_arraycls($rt_intcls()),
            callable : null
        }, {
            name : "hasSingleCodepointDecomposition",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "hasDecompositionNonNullCanClass",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "nextCodePoint",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getIndex",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }];
    jur_PatternSyntaxException.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String, jl_String, $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getPattern",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "getMessage",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "getDescription",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "getIndex",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }];
    jl_CloneNotSupportedException.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }];
    nle_TextureLocation.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "freeTextures",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "bindTexture",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<clinit>",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }];
    ju_Calendar.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [ju_TimeZone],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [ju_TimeZone, ju_Locale],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "resolveFirstDayOfWeek",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [ju_Locale],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "resolveMinimalDaysInFirstWeek",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [ju_Locale],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "add",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "after",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "before",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "clear",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "clear",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "clone",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_Object,
            callable : null
        }, {
            name : "complete",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "computeFields",
            modifiers : 1,
            accessLevel : 2,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "computeTime",
            modifiers : 1,
            accessLevel : 2,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "equals",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "get",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getActualMaximum",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getActualMinimum",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getAvailableLocales",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_arraycls(ju_Locale),
            callable : null
        }, {
            name : "getFirstDayOfWeek",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getGreatestMinimum",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getInstance",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [],
            returnType : ju_Calendar,
            callable : null
        }, {
            name : "getInstance",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [ju_Locale],
            returnType : ju_Calendar,
            callable : null
        }, {
            name : "getInstance",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [ju_TimeZone, ju_Locale],
            returnType : ju_Calendar,
            callable : null
        }, {
            name : "getInstance",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [ju_TimeZone],
            returnType : ju_Calendar,
            callable : null
        }, {
            name : "getLeastMaximum",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getMaximum",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getMinimalDaysInFirstWeek",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getMinimum",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getTime",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [],
            returnType : ju_Date,
            callable : null
        }, {
            name : "getTimeInMillis",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_longcls(),
            callable : null
        }, {
            name : "getTimeZone",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : ju_TimeZone,
            callable : null
        }, {
            name : "setTimeZone",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [ju_TimeZone],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "hashCode",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "internalGet",
            modifiers : 4,
            accessLevel : 2,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "isLenient",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "isSet",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "roll",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "roll",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_booleancls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "set",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "set",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "set",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "set",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "setFirstDayOfWeek",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "setLenient",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_booleancls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "setMinimalDaysInFirstWeek",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "setTime",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [ju_Date],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "setTimeInMillis",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_longcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "toString",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "compareTo",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [ju_Calendar],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "compareTo",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "<clinit>",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }];
    ju_GregorianCalendar.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [$rt_longcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [ju_Locale],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [ju_TimeZone],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [ju_TimeZone, ju_Locale],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [$rt_booleancls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "add",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "clone",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_Object,
            callable : null
        }, {
            name : "fullFieldsCalc",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [$rt_longcls(), $rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "cachedFieldsCheckAndGet",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [$rt_longcls(), $rt_longcls(), $rt_longcls(), $rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getTimeZoneOffset",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [$rt_longcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "computeFields",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "computeTime",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "computeYearAndDay",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [$rt_longcls(), $rt_longcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "daysFromBaseYear",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_longcls(),
            callable : null
        }, {
            name : "daysInMonth",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "daysInMonth",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [$rt_booleancls(), $rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "daysInYear",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "daysInYear",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [$rt_booleancls(), $rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "equals",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "getActualMaximum",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getActualMinimum",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getGreatestMinimum",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getGregorianChange",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [],
            returnType : ju_Date,
            callable : null
        }, {
            name : "getLeastMaximum",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getMaximum",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getMinimum",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "hashCode",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "isLeapYear",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "julianError",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "mod",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "mod7",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [$rt_longcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "roll",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "roll",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_booleancls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "setGregorianChange",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [ju_Date],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "setFirstDayOfWeek",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "setMinimalDaysInFirstWeek",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<clinit>",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }];
    cjj_Adler32.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "reset",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_longcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "reset",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getValue",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_longcls(),
            callable : null
        }, {
            name : "update",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls()), $rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "copy",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : cjj_Adler32,
            callable : null
        }, {
            name : "combine",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [$rt_longcls(), $rt_longcls(), $rt_longcls()],
            returnType : $rt_longcls(),
            callable : null
        }, {
            name : "copy",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [],
            returnType : cjj_Checksum,
            callable : null
        }];
    cjj_Checksum.$meta.methods = [
        {
            name : "update",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls()), $rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "reset",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "reset",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_longcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getValue",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_longcls(),
            callable : null
        }, {
            name : "copy",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : cjj_Checksum,
            callable : null
        }];
    nle_BaseNCodec$CodecPolicy.$meta.methods = [
        {
            name : "values",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_arraycls(nle_BaseNCodec$CodecPolicy),
            callable : null
        }, {
            name : "valueOf",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : nle_BaseNCodec$CodecPolicy,
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [jl_String, $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<clinit>",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }];
    jl_Enum.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [jl_String, $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "name",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "ordinal",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "toString",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "equals",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "hashCode",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "clone",
            modifiers : 4,
            accessLevel : 2,
            parameterTypes : [],
            returnType : jl_Object,
            callable : null
        }, {
            name : "getDeclaringClass",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_Class,
            callable : null
        }, {
            name : "compareTo",
            modifiers : 4,
            accessLevel : 3,
            parameterTypes : [jl_Enum],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "valueOf",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [jl_Class, jl_String],
            returnType : jl_Enum,
            callable : null
        }, {
            name : "compareTo",
            modifiers : 96,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_intcls(),
            callable : null
        }];
    jur_NonCapFSet.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "matches",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_CharSequence, jur_MatchResultImpl],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getName",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "hasConsumed",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_MatchResultImpl],
            returnType : $rt_booleancls(),
            callable : null
        }];
    jur_AheadFSet.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "matches",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_CharSequence, jur_MatchResultImpl],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getName",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }];
    jur_BehindFSet.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "matches",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_CharSequence, jur_MatchResultImpl],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getName",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }];
    jur_AtomicFSet.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "matches",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_CharSequence, jur_MatchResultImpl],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getIndex",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getName",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "hasConsumed",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_MatchResultImpl],
            returnType : $rt_booleancls(),
            callable : null
        }];
    jur_FinalSet.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "matches",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_CharSequence, jur_MatchResultImpl],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getName",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }];
    jur_EmptySet.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_AbstractSet],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "accepts",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_CharSequence],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "find",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_CharSequence, jur_MatchResultImpl],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "findBack",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls(), jl_CharSequence, jur_MatchResultImpl],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getName",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "hasConsumed",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_MatchResultImpl],
            returnType : $rt_booleancls(),
            callable : null
        }];
    jur_LeafSet.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_AbstractSet],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "accepts",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_CharSequence],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "matches",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_CharSequence, jur_MatchResultImpl],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "charCount",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "hasConsumed",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_MatchResultImpl],
            returnType : $rt_booleancls(),
            callable : null
        }];
    jur_NonCapJointSet.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [ju_ArrayList, jur_FSet],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "matches",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_CharSequence, jur_MatchResultImpl],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getName",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "hasConsumed",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_MatchResultImpl],
            returnType : $rt_booleancls(),
            callable : null
        }];
    jur_JointSet.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [ju_ArrayList, jur_FSet],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "matches",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_CharSequence, jur_MatchResultImpl],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "setNext",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_AbstractSet],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getNext",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jur_AbstractSet,
            callable : null
        }, {
            name : "getName",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "getGroup",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "first",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_AbstractSet],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "hasConsumed",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_MatchResultImpl],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "processSecondPass",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }];
    jur_PositiveLookAhead.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [ju_ArrayList, jur_FSet],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "matches",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_CharSequence, jur_MatchResultImpl],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "hasConsumed",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_MatchResultImpl],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "getName",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }];
    jur_AtomicJointSet.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [ju_ArrayList, jur_FSet],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "matches",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_CharSequence, jur_MatchResultImpl],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "setNext",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_AbstractSet],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getNext",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jur_AbstractSet,
            callable : null
        }, {
            name : "getName",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }];
    jur_NegativeLookAhead.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [ju_ArrayList, jur_FSet],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "matches",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_CharSequence, jur_MatchResultImpl],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "hasConsumed",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_MatchResultImpl],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "getName",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }];
    jur_PositiveLookBehind.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [ju_ArrayList, jur_FSet],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "matches",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_CharSequence, jur_MatchResultImpl],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "hasConsumed",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_MatchResultImpl],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "getName",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }];
    jur_NegativeLookBehind.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [ju_ArrayList, jur_FSet],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "matches",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_CharSequence, jur_MatchResultImpl],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "hasConsumed",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_MatchResultImpl],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "getName",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }];
    jur_SingleSet.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_AbstractSet, jur_FSet],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "matches",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_CharSequence, jur_MatchResultImpl],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "find",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_CharSequence, jur_MatchResultImpl],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "findBack",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls(), jl_CharSequence, jur_MatchResultImpl],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "first",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_AbstractSet],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "processBackRefReplacement",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jur_JointSet,
            callable : null
        }, {
            name : "processSecondPass",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }];
    jl_IndexOutOfBoundsException.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }];
    jl_ArrayStoreException.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }];
    jur_CharClass.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_booleancls(), $rt_booleancls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_booleancls(), $rt_booleancls(), $rt_booleancls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "add",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : jur_CharClass,
            callable : null
        }, {
            name : "add",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_AbstractCharClass],
            returnType : jur_CharClass,
            callable : null
        }, {
            name : "add",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : jur_CharClass,
            callable : null
        }, {
            name : "union",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_AbstractCharClass],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "intersection",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_AbstractCharClass],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "contains",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "getBits",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [],
            returnType : ju_BitSet,
            callable : null
        }, {
            name : "getLowHighSurrogates",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [],
            returnType : ju_BitSet,
            callable : null
        }, {
            name : "getInstance",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jur_AbstractCharClass,
            callable : null
        }, {
            name : "toString",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "hasUCI",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }];
    jur_AbstractCharClass.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "contains",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "getBits",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [],
            returnType : ju_BitSet,
            callable : null
        }, {
            name : "getLowHighSurrogates",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [],
            returnType : ju_BitSet,
            callable : null
        }, {
            name : "hasLowHighSurrogates",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "mayContainSupplCodepoints",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "getType",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getInstance",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jur_AbstractCharClass,
            callable : null
        }, {
            name : "getSurrogates",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jur_AbstractCharClass,
            callable : null
        }, {
            name : "getWithoutSurrogates",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jur_AbstractCharClass,
            callable : null
        }, {
            name : "hasUCI",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "setNegative",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_booleancls()],
            returnType : jur_AbstractCharClass,
            callable : null
        }, {
            name : "isNegative",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "intersects",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "intersects",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [jur_AbstractCharClass, $rt_intcls()],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "intersects",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [jur_AbstractCharClass, jur_AbstractCharClass],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "getPredefinedClass",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [jl_String, $rt_booleancls()],
            returnType : jur_AbstractCharClass,
            callable : null
        }, {
            name : "<clinit>",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }];
    jur_SpecialToken.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getType",
            modifiers : 1,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }];
    jur_LeafQuantifierSet.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_LeafSet, jur_AbstractSet, $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "matches",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_CharSequence, jur_MatchResultImpl],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getName",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "setInnerSet",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_AbstractSet],
            returnType : $rt_voidcls(),
            callable : null
        }];
    jur_QuantifierSet.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_AbstractSet, jur_AbstractSet, $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getInnerSet",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jur_AbstractSet,
            callable : null
        }, {
            name : "setInnerSet",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_AbstractSet],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "first",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_AbstractSet],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "hasConsumed",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_MatchResultImpl],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "processSecondPass",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }];
    jur_UnifiedQuantifierSet.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_LeafSet, jur_AbstractSet, $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_LeafQuantifierSet],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "matches",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_CharSequence, jur_MatchResultImpl],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "find",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_CharSequence, jur_MatchResultImpl],
            returnType : $rt_intcls(),
            callable : null
        }];
    jlr_Array.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getLength",
            modifiers : 768,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getLengthLowLevel",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [otr_RuntimeObject],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "newInstance",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [jl_Class, $rt_intcls()],
            returnType : jl_Object,
            callable : null
        }, {
            name : "newInstanceImpl",
            modifiers : 768,
            accessLevel : 1,
            parameterTypes : [otp_PlatformClass, $rt_intcls()],
            returnType : jl_Object,
            callable : null
        }, {
            name : "newInstanceLowLevel",
            modifiers : 512,
            accessLevel : 1,
            parameterTypes : [otr_RuntimeClass, $rt_intcls()],
            returnType : otr_RuntimeObject,
            callable : null
        }, {
            name : "get",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [jl_Object, $rt_intcls()],
            returnType : jl_Object,
            callable : null
        }, {
            name : "set",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [jl_Object, $rt_intcls(), jl_Object],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getImpl",
            modifiers : 768,
            accessLevel : 1,
            parameterTypes : [jl_Object, $rt_intcls()],
            returnType : jl_Object,
            callable : null
        }, {
            name : "setImpl",
            modifiers : 768,
            accessLevel : 1,
            parameterTypes : [jl_Object, $rt_intcls(), jl_Object],
            returnType : $rt_voidcls(),
            callable : null
        }];
    jur_AbstractCharClass$PredefinedCharacterClasses.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getObject",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : jl_Object,
            callable : null
        }, {
            name : "<clinit>",
            modifiers : 512,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }];
    jur_AbstractCharClass$LazyCharClass.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getValue",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_booleancls()],
            returnType : jur_AbstractCharClass,
            callable : null
        }, {
            name : "computeValue",
            modifiers : 1,
            accessLevel : 2,
            parameterTypes : [],
            returnType : jur_AbstractCharClass,
            callable : null
        }];
    ju_MissingResourceException.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String, jl_String, jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getClassName",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "getKey",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }];
    jur_Quantifier.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "resetCounter",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getCounter",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "setCounter",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "min",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "max",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "toString",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "getType",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "clone",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_Object,
            callable : null
        }];
    jur_FSet$PossessiveFSet.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "matches",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_CharSequence, jur_MatchResultImpl],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getName",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "hasConsumed",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_MatchResultImpl],
            returnType : $rt_booleancls(),
            callable : null
        }];
    ju_BitSet.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [$rt_arraycls($rt_intcls())],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "valueOf",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_longcls())],
            returnType : ju_BitSet,
            callable : null
        }, {
            name : "valueOf",
            modifiers : 512,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_bytecls())],
            returnType : ju_BitSet,
            callable : null
        }, {
            name : "toByteArray",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_arraycls($rt_bytecls()),
            callable : null
        }, {
            name : "toLongArray",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_arraycls($rt_longcls()),
            callable : null
        }, {
            name : "flip",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "flip",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "set",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "set",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_booleancls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "set",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "trailingZeroBits",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "trailingOneBits",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "set",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls(), $rt_booleancls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "clear",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "clear",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "clear",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "get",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "get",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : ju_BitSet,
            callable : null
        }, {
            name : "nextSetBit",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "nextClearBit",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "previousSetBit",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "previousClearBit",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "ensureCapacity",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "recalculateLength",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "length",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "intersects",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [ju_BitSet],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "cardinality",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "and",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [ju_BitSet],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "andNot",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [ju_BitSet],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "or",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [ju_BitSet],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "xor",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [ju_BitSet],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "isEmpty",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "size",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "equals",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_Object],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "hashCode",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "toString",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "clone",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_Object,
            callable : null
        }];
    jur_LowHighSurrogateRangeSet.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_AbstractCharClass, jur_AbstractSet],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_AbstractCharClass],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getNext",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jur_AbstractSet,
            callable : null
        }, {
            name : "setNext",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_AbstractSet],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "matches",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_CharSequence, jur_MatchResultImpl],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getName",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "first",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_AbstractSet],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "getChars",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [],
            returnType : jur_AbstractCharClass,
            callable : null
        }, {
            name : "hasConsumed",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_MatchResultImpl],
            returnType : $rt_booleancls(),
            callable : null
        }];
    jur_CompositeRangeSet.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_AbstractSet, jur_AbstractSet, jur_AbstractSet],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_AbstractSet, jur_AbstractSet],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getNext",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jur_AbstractSet,
            callable : null
        }, {
            name : "matches",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_CharSequence, jur_MatchResultImpl],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "setNext",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_AbstractSet],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getSurrogates",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jur_AbstractSet,
            callable : null
        }, {
            name : "getWithoutSurrogates",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jur_AbstractSet,
            callable : null
        }, {
            name : "getName",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "hasConsumed",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_MatchResultImpl],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "first",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_AbstractSet],
            returnType : $rt_booleancls(),
            callable : null
        }];
    jur_UCISupplRangeSet.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_AbstractCharClass, jur_AbstractSet],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_AbstractCharClass],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "contains",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "getName",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }];
    jur_SupplRangeSet.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_AbstractCharClass, jur_AbstractSet],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_AbstractCharClass],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "matches",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_CharSequence, jur_MatchResultImpl],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getName",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "contains",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "first",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_AbstractSet],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "getChars",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [],
            returnType : jur_AbstractCharClass,
            callable : null
        }, {
            name : "getNext",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jur_AbstractSet,
            callable : null
        }, {
            name : "setNext",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_AbstractSet],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "hasConsumed",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_MatchResultImpl],
            returnType : $rt_booleancls(),
            callable : null
        }];
    jur_UCIRangeSet.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_AbstractCharClass, jur_AbstractSet],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_AbstractCharClass],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "accepts",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_CharSequence],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getName",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }];
    jur_RangeSet.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_AbstractCharClass, jur_AbstractSet],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_AbstractCharClass],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "accepts",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_CharSequence],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getName",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "first",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_AbstractSet],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "getChars",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [],
            returnType : jur_AbstractCharClass,
            callable : null
        }];
    jur_HangulDecomposedCharSet.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_charcls()), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getNext",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jur_AbstractSet,
            callable : null
        }, {
            name : "setNext",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_AbstractSet],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getDecomposedChar",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "getName",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "matches",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_CharSequence, jur_MatchResultImpl],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "first",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_AbstractSet],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "hasConsumed",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_MatchResultImpl],
            returnType : $rt_booleancls(),
            callable : null
        }];
    jur_CharSet.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_charcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "charCount",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "accepts",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_CharSequence],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "find",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_CharSequence, jur_MatchResultImpl],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "findBack",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls(), jl_CharSequence, jur_MatchResultImpl],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getName",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "getChar",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [],
            returnType : $rt_charcls(),
            callable : null
        }, {
            name : "first",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_AbstractSet],
            returnType : $rt_booleancls(),
            callable : null
        }];
    jur_UCICharSet.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_charcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "accepts",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_CharSequence],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getName",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }];
    jur_CICharSet.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_charcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "accepts",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_CharSequence],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getName",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "getChar",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [],
            returnType : $rt_charcls(),
            callable : null
        }];
    jur_DecomposedCharSet.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_intcls()), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getNext",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jur_AbstractSet,
            callable : null
        }, {
            name : "setNext",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_AbstractSet],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "matches",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_CharSequence, jur_MatchResultImpl],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getDecomposedChar",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "getName",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "codePointAt",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_CharSequence, $rt_intcls()],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "first",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_AbstractSet],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "hasConsumed",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_MatchResultImpl],
            returnType : $rt_booleancls(),
            callable : null
        }];
    jur_UCIDecomposedCharSet.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_intcls()), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }];
    jur_CIDecomposedCharSet.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_arraycls($rt_intcls()), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }];
    jur_PossessiveGroupQuantifierSet.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_AbstractSet, jur_AbstractSet, $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "matches",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_CharSequence, jur_MatchResultImpl],
            returnType : $rt_intcls(),
            callable : null
        }];
    jur_GroupQuantifierSet.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_AbstractSet, jur_AbstractSet, $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "matches",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_CharSequence, jur_MatchResultImpl],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getName",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }];
    jur_PosPlusGroupQuantifierSet.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_AbstractSet, jur_AbstractSet, $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "matches",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_CharSequence, jur_MatchResultImpl],
            returnType : $rt_intcls(),
            callable : null
        }];
    jur_PosAltGroupQuantifierSet.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_AbstractSet, jur_AbstractSet, $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "matches",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_CharSequence, jur_MatchResultImpl],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "setNext",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_AbstractSet],
            returnType : $rt_voidcls(),
            callable : null
        }];
    jur_AltGroupQuantifierSet.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_AbstractSet, jur_AbstractSet, $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "matches",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_CharSequence, jur_MatchResultImpl],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "setNext",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_AbstractSet],
            returnType : $rt_voidcls(),
            callable : null
        }];
    jur_PosCompositeGroupQuantifierSet.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_Quantifier, jur_AbstractSet, jur_AbstractSet, $rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "matches",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_CharSequence, jur_MatchResultImpl],
            returnType : $rt_intcls(),
            callable : null
        }];
    jur_CompositeGroupQuantifierSet.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_Quantifier, jur_AbstractSet, jur_AbstractSet, $rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "matches",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_CharSequence, jur_MatchResultImpl],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "reset",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getName",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "setQuantifier",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [jur_Quantifier],
            returnType : $rt_voidcls(),
            callable : null
        }];
    jur_ReluctantGroupQuantifierSet.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_AbstractSet, jur_AbstractSet, $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "matches",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_CharSequence, jur_MatchResultImpl],
            returnType : $rt_intcls(),
            callable : null
        }];
    jur_RelAltGroupQuantifierSet.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_AbstractSet, jur_AbstractSet, $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "matches",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_CharSequence, jur_MatchResultImpl],
            returnType : $rt_intcls(),
            callable : null
        }];
    jur_RelCompositeGroupQuantifierSet.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_Quantifier, jur_AbstractSet, jur_AbstractSet, $rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "matches",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_CharSequence, jur_MatchResultImpl],
            returnType : $rt_intcls(),
            callable : null
        }];
    jur_DotAllQuantifierSet.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_AbstractSet, jur_AbstractSet, $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "matches",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_CharSequence, jur_MatchResultImpl],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "find",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_CharSequence, jur_MatchResultImpl],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getName",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }];
    jur_DotQuantifierSet.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_AbstractSet, jur_AbstractSet, $rt_intcls(), jur_AbstractLineTerminator],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "matches",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_CharSequence, jur_MatchResultImpl],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "find",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_CharSequence, jur_MatchResultImpl],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "findLineTerminator",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [$rt_intcls(), $rt_intcls(), jl_CharSequence],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "findBackLineTerminator",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [$rt_intcls(), $rt_intcls(), jl_CharSequence],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getName",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }];
    jur_PossessiveQuantifierSet.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_LeafSet, jur_AbstractSet, $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "matches",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_CharSequence, jur_MatchResultImpl],
            returnType : $rt_intcls(),
            callable : null
        }];
    jur_PossessiveAltQuantifierSet.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_LeafSet, jur_AbstractSet, $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "matches",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_CharSequence, jur_MatchResultImpl],
            returnType : $rt_intcls(),
            callable : null
        }];
    jur_AltQuantifierSet.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_LeafSet, jur_AbstractSet, $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "matches",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_CharSequence, jur_MatchResultImpl],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "setNext",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_AbstractSet],
            returnType : $rt_voidcls(),
            callable : null
        }];
    jur_PossessiveCompositeQuantifierSet.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_Quantifier, jur_LeafSet, jur_AbstractSet, $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "matches",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_CharSequence, jur_MatchResultImpl],
            returnType : $rt_intcls(),
            callable : null
        }];
    jur_CompositeQuantifierSet.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_Quantifier, jur_LeafSet, jur_AbstractSet, $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "matches",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_CharSequence, jur_MatchResultImpl],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "reset",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getName",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "setQuantifier",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [jur_Quantifier],
            returnType : $rt_voidcls(),
            callable : null
        }];
    jur_ReluctantQuantifierSet.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_LeafSet, jur_AbstractSet, $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "matches",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_CharSequence, jur_MatchResultImpl],
            returnType : $rt_intcls(),
            callable : null
        }];
    jur_ReluctantAltQuantifierSet.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_LeafSet, jur_AbstractSet, $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "matches",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_CharSequence, jur_MatchResultImpl],
            returnType : $rt_intcls(),
            callable : null
        }];
    jur_ReluctantCompositeQuantifierSet.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_Quantifier, jur_LeafSet, jur_AbstractSet, $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "matches",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_CharSequence, jur_MatchResultImpl],
            returnType : $rt_intcls(),
            callable : null
        }];
    jur_SOLSet.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "matches",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_CharSequence, jur_MatchResultImpl],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "hasConsumed",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_MatchResultImpl],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "getName",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }];
    jur_WordBoundary.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_booleancls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "matches",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_CharSequence, jur_MatchResultImpl],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "hasConsumed",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_MatchResultImpl],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "getName",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "isSpace",
            modifiers : 0,
            accessLevel : 1,
            parameterTypes : [$rt_charcls(), $rt_intcls(), $rt_intcls(), jl_CharSequence],
            returnType : $rt_booleancls(),
            callable : null
        }];
    jur_PreviousMatch.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "matches",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_CharSequence, jur_MatchResultImpl],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "hasConsumed",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_MatchResultImpl],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "getName",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }];
    jur_EOLSet.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "matches",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_CharSequence, jur_MatchResultImpl],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "hasConsumed",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_MatchResultImpl],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "getName",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }];
    jur_EOISet.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "matches",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_CharSequence, jur_MatchResultImpl],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "hasConsumed",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_MatchResultImpl],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "getName",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }];
    jur_MultiLineSOLSet.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_AbstractLineTerminator],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "matches",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_CharSequence, jur_MatchResultImpl],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "hasConsumed",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_MatchResultImpl],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "getName",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }];
    jur_DotAllSet.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 0,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "matches",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_CharSequence, jur_MatchResultImpl],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getName",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "getNext",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jur_AbstractSet,
            callable : null
        }, {
            name : "setNext",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_AbstractSet],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getType",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "hasConsumed",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_MatchResultImpl],
            returnType : $rt_booleancls(),
            callable : null
        }];
    jur_DotSet.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_AbstractLineTerminator],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "matches",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_CharSequence, jur_MatchResultImpl],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getName",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "getNext",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jur_AbstractSet,
            callable : null
        }, {
            name : "setNext",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_AbstractSet],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getType",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "hasConsumed",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_MatchResultImpl],
            returnType : $rt_booleancls(),
            callable : null
        }];
    jur_UEOLSet.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "matches",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_CharSequence, jur_MatchResultImpl],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "hasConsumed",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_MatchResultImpl],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "getName",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }];
    jur_UMultiLineEOLSet.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "matches",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_CharSequence, jur_MatchResultImpl],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "hasConsumed",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_MatchResultImpl],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "getName",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }];
    jur_MultiLineEOLSet.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "matches",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_CharSequence, jur_MatchResultImpl],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "hasConsumed",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_MatchResultImpl],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "getName",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }];
    jur_BackReferenceSet.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "matches",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_CharSequence, jur_MatchResultImpl],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "find",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_CharSequence, jur_MatchResultImpl],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "findBack",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls(), jl_CharSequence, jur_MatchResultImpl],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "first",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_AbstractSet],
            returnType : $rt_booleancls(),
            callable : null
        }, {
            name : "getName",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }];
    jur_CIBackReferenceSet.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "accepts",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_CharSequence],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "matches",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_CharSequence, jur_MatchResultImpl],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getNext",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jur_AbstractSet,
            callable : null
        }, {
            name : "setNext",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_AbstractSet],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "getString",
            modifiers : 0,
            accessLevel : 2,
            parameterTypes : [jur_MatchResultImpl],
            returnType : jl_String,
            callable : null
        }, {
            name : "getName",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }, {
            name : "hasConsumed",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jur_MatchResultImpl],
            returnType : $rt_booleancls(),
            callable : null
        }];
    jur_UCIBackReferenceSet.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), $rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "matches",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls(), jl_CharSequence, jur_MatchResultImpl],
            returnType : $rt_intcls(),
            callable : null
        }, {
            name : "getName",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : jl_String,
            callable : null
        }];
    jl_StringBuffer.$meta.methods = [
        {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "<init>",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_CharSequence],
            returnType : $rt_voidcls(),
            callable : null
        }, {
            name : "append",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [jl_String],
            returnType : jl_StringBuffer,
            callable : null
        }, {
            name : "append",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_intcls()],
            returnType : jl_StringBuffer,
            callable : null
        }, {
            name : "append",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_longcls()],
            returnType : jl_StringBuffer,
            callable : null
        }, {
            name : "append",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_floatcls()],
            returnType : jl_StringBuffer,
            callable : null
        }, {
            name : "append",
            modifiers : 0,
            accessLevel : 3,
            parameterTypes : [$rt_doublecls()],
            returnType : jl_StringBuffer,
            callable : null
        }, {
            name : "append",
            modifiers : 0,
     